/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.Computation;

@SdkInternalApi
public class ComputationMarshaller {
    private static final MarshallingInfo<StructuredPojo> TOPBOTTOMRANKED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopBottomRanked").build();
    private static final MarshallingInfo<StructuredPojo> TOPBOTTOMMOVERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopBottomMovers").build();
    private static final MarshallingInfo<StructuredPojo> TOTALAGGREGATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalAggregation").build();
    private static final MarshallingInfo<StructuredPojo> MAXIMUMMINIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumMinimum").build();
    private static final MarshallingInfo<StructuredPojo> METRICCOMPARISON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricComparison").build();
    private static final MarshallingInfo<StructuredPojo> PERIODOVERPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PeriodOverPeriod").build();
    private static final MarshallingInfo<StructuredPojo> PERIODTODATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PeriodToDate").build();
    private static final MarshallingInfo<StructuredPojo> GROWTHRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrowthRate").build();
    private static final MarshallingInfo<StructuredPojo> UNIQUEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UniqueValues").build();
    private static final MarshallingInfo<StructuredPojo> FORECAST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Forecast").build();
    private static final ComputationMarshaller instance = new ComputationMarshaller();

    public static ComputationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Computation computation, ProtocolMarshaller protocolMarshaller) {
        if (computation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)computation.getTopBottomRanked(), TOPBOTTOMRANKED_BINDING);
            protocolMarshaller.marshall((Object)computation.getTopBottomMovers(), TOPBOTTOMMOVERS_BINDING);
            protocolMarshaller.marshall((Object)computation.getTotalAggregation(), TOTALAGGREGATION_BINDING);
            protocolMarshaller.marshall((Object)computation.getMaximumMinimum(), MAXIMUMMINIMUM_BINDING);
            protocolMarshaller.marshall((Object)computation.getMetricComparison(), METRICCOMPARISON_BINDING);
            protocolMarshaller.marshall((Object)computation.getPeriodOverPeriod(), PERIODOVERPERIOD_BINDING);
            protocolMarshaller.marshall((Object)computation.getPeriodToDate(), PERIODTODATE_BINDING);
            protocolMarshaller.marshall((Object)computation.getGrowthRate(), GROWTHRATE_BINDING);
            protocolMarshaller.marshall((Object)computation.getUniqueValues(), UNIQUEVALUES_BINDING);
            protocolMarshaller.marshall((Object)computation.getForecast(), FORECAST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

