/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.SheetStyle;

@SdkInternalApi
public class SheetStyleMarshaller {
    private static final MarshallingInfo<StructuredPojo> TILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tile").build();
    private static final MarshallingInfo<StructuredPojo> TILELAYOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TileLayout").build();
    private static final SheetStyleMarshaller instance = new SheetStyleMarshaller();

    public static SheetStyleMarshaller getInstance() {
        return instance;
    }

    public void marshall(SheetStyle sheetStyle, ProtocolMarshaller protocolMarshaller) {
        if (sheetStyle == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sheetStyle.getTile(), TILE_BINDING);
            protocolMarshaller.marshall((Object)sheetStyle.getTileLayout(), TILELAYOUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

