/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.Parameters;
import com.amazonaws.services.quicksight.model.SnapshotDestinationConfiguration;
import com.amazonaws.services.quicksight.model.SnapshotFileGroup;
import com.amazonaws.services.quicksight.model.transform.SnapshotConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SnapshotConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SnapshotFileGroup> fileGroups;
    private SnapshotDestinationConfiguration destinationConfiguration;
    private Parameters parameters;

    public List<SnapshotFileGroup> getFileGroups() {
        return this.fileGroups;
    }

    public void setFileGroups(Collection<SnapshotFileGroup> fileGroups) {
        if (fileGroups == null) {
            this.fileGroups = null;
            return;
        }
        this.fileGroups = new ArrayList<SnapshotFileGroup>(fileGroups);
    }

    public SnapshotConfiguration withFileGroups(SnapshotFileGroup ... fileGroups) {
        if (this.fileGroups == null) {
            this.setFileGroups(new ArrayList<SnapshotFileGroup>(fileGroups.length));
        }
        for (SnapshotFileGroup ele : fileGroups) {
            this.fileGroups.add(ele);
        }
        return this;
    }

    public SnapshotConfiguration withFileGroups(Collection<SnapshotFileGroup> fileGroups) {
        this.setFileGroups(fileGroups);
        return this;
    }

    public void setDestinationConfiguration(SnapshotDestinationConfiguration destinationConfiguration) {
        this.destinationConfiguration = destinationConfiguration;
    }

    public SnapshotDestinationConfiguration getDestinationConfiguration() {
        return this.destinationConfiguration;
    }

    public SnapshotConfiguration withDestinationConfiguration(SnapshotDestinationConfiguration destinationConfiguration) {
        this.setDestinationConfiguration(destinationConfiguration);
        return this;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public SnapshotConfiguration withParameters(Parameters parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileGroups() != null) {
            sb.append("FileGroups: ").append(this.getFileGroups()).append(",");
        }
        if (this.getDestinationConfiguration() != null) {
            sb.append("DestinationConfiguration: ").append(this.getDestinationConfiguration()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotConfiguration)) {
            return false;
        }
        SnapshotConfiguration other = (SnapshotConfiguration)obj;
        if (other.getFileGroups() == null ^ this.getFileGroups() == null) {
            return false;
        }
        if (other.getFileGroups() != null && !other.getFileGroups().equals(this.getFileGroups())) {
            return false;
        }
        if (other.getDestinationConfiguration() == null ^ this.getDestinationConfiguration() == null) {
            return false;
        }
        if (other.getDestinationConfiguration() != null && !other.getDestinationConfiguration().equals(this.getDestinationConfiguration())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileGroups() == null ? 0 : this.getFileGroups().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationConfiguration() == null ? 0 : this.getDestinationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public SnapshotConfiguration clone() {
        try {
            return (SnapshotConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnapshotConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

