/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListNamespacesRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.
     * </p>
     */
    private String awsAccountId;
    /**
     * <p>
     * A unique pagination token that can be used in a subsequent request. You will receive a pagination token in the
     * response body of a previous <code>ListNameSpaces</code> API call if there is more data that can be returned. To
     * receive the data, make another <code>ListNamespaces</code> API call with the returned token to retrieve the next
     * page of data. Each token is valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an
     * expired token, you will receive a <code>HTTP 400 InvalidNextTokenException</code> error.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     */
    private Integer maxResults;

    /**
     * <p>
     * The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.
     * </p>
     * 
     * @param awsAccountId
     *        The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to
     *        list.
     */

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want
     *         to list.
     */

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.
     * </p>
     * 
     * @param awsAccountId
     *        The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to
     *        list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNamespacesRequest withAwsAccountId(String awsAccountId) {
        setAwsAccountId(awsAccountId);
        return this;
    }

    /**
     * <p>
     * A unique pagination token that can be used in a subsequent request. You will receive a pagination token in the
     * response body of a previous <code>ListNameSpaces</code> API call if there is more data that can be returned. To
     * receive the data, make another <code>ListNamespaces</code> API call with the returned token to retrieve the next
     * page of data. Each token is valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an
     * expired token, you will receive a <code>HTTP 400 InvalidNextTokenException</code> error.
     * </p>
     * 
     * @param nextToken
     *        A unique pagination token that can be used in a subsequent request. You will receive a pagination token in
     *        the response body of a previous <code>ListNameSpaces</code> API call if there is more data that can be
     *        returned. To receive the data, make another <code>ListNamespaces</code> API call with the returned token
     *        to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a
     *        <code>ListNamespaces</code> API call with an expired token, you will receive a
     *        <code>HTTP 400 InvalidNextTokenException</code> error.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A unique pagination token that can be used in a subsequent request. You will receive a pagination token in the
     * response body of a previous <code>ListNameSpaces</code> API call if there is more data that can be returned. To
     * receive the data, make another <code>ListNamespaces</code> API call with the returned token to retrieve the next
     * page of data. Each token is valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an
     * expired token, you will receive a <code>HTTP 400 InvalidNextTokenException</code> error.
     * </p>
     * 
     * @return A unique pagination token that can be used in a subsequent request. You will receive a pagination token
     *         in the response body of a previous <code>ListNameSpaces</code> API call if there is more data that can be
     *         returned. To receive the data, make another <code>ListNamespaces</code> API call with the returned token
     *         to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a
     *         <code>ListNamespaces</code> API call with an expired token, you will receive a
     *         <code>HTTP 400 InvalidNextTokenException</code> error.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A unique pagination token that can be used in a subsequent request. You will receive a pagination token in the
     * response body of a previous <code>ListNameSpaces</code> API call if there is more data that can be returned. To
     * receive the data, make another <code>ListNamespaces</code> API call with the returned token to retrieve the next
     * page of data. Each token is valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an
     * expired token, you will receive a <code>HTTP 400 InvalidNextTokenException</code> error.
     * </p>
     * 
     * @param nextToken
     *        A unique pagination token that can be used in a subsequent request. You will receive a pagination token in
     *        the response body of a previous <code>ListNameSpaces</code> API call if there is more data that can be
     *        returned. To receive the data, make another <code>ListNamespaces</code> API call with the returned token
     *        to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a
     *        <code>ListNamespaces</code> API call with an expired token, you will receive a
     *        <code>HTTP 400 InvalidNextTokenException</code> error.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNamespacesRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNamespacesRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAwsAccountId() != null)
            sb.append("AwsAccountId: ").append(getAwsAccountId()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListNamespacesRequest == false)
            return false;
        ListNamespacesRequest other = (ListNamespacesRequest) obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null)
            return false;
        if (other.getAwsAccountId() != null && other.getAwsAccountId().equals(this.getAwsAccountId()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAwsAccountId() == null) ? 0 : getAwsAccountId().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public ListNamespacesRequest clone() {
        return (ListNamespacesRequest) super.clone();
    }

}
