/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.DescribeCertificatesRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeCertificatesRequestMarshaller
implements Marshaller<Request<DescribeCertificatesRequest>, DescribeCertificatesRequest> {
    public Request<DescribeCertificatesRequest> marshall(DescribeCertificatesRequest describeCertificatesRequest) {
        if (describeCertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCertificatesRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeCertificates");
        request.addParameter("Version", "2014-10-31");
        if (describeCertificatesRequest.getCertificateIdentifier() != null) {
            request.addParameter("CertificateIdentifier", StringUtils.fromString((String)describeCertificatesRequest.getCertificateIdentifier()));
        }
        List<Filter> filtersList = describeCertificatesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describeCertificatesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeCertificatesRequest.getMaxRecords()));
        }
        if (describeCertificatesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeCertificatesRequest.getMarker()));
        }
        return request;
    }
}

