/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.rds.AmazonRDSAsync;
import com.amazonaws.services.rds.AmazonRDSClient;
import com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest;
import com.amazonaws.services.rds.model.AddTagsToResourceRequest;
import com.amazonaws.services.rds.model.ApplyPendingMaintenanceActionRequest;
import com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.CopyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.CopyDBSnapshotRequest;
import com.amazonaws.services.rds.model.CopyOptionGroupRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.services.rds.model.CreateDBParameterGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSnapshotRequest;
import com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.CreateEventSubscriptionRequest;
import com.amazonaws.services.rds.model.CreateOptionGroupRequest;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBParameterGroup;
import com.amazonaws.services.rds.model.DBSecurityGroup;
import com.amazonaws.services.rds.model.DBSnapshot;
import com.amazonaws.services.rds.model.DBSubnetGroup;
import com.amazonaws.services.rds.model.DeleteDBInstanceRequest;
import com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSnapshotRequest;
import com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest;
import com.amazonaws.services.rds.model.DeleteOptionGroupRequest;
import com.amazonaws.services.rds.model.DescribeAccountAttributesRequest;
import com.amazonaws.services.rds.model.DescribeAccountAttributesResult;
import com.amazonaws.services.rds.model.DescribeCertificatesRequest;
import com.amazonaws.services.rds.model.DescribeCertificatesResult;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsResult;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.DescribeDBLogFilesRequest;
import com.amazonaws.services.rds.model.DescribeDBLogFilesResult;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBParametersRequest;
import com.amazonaws.services.rds.model.DescribeDBParametersResult;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSubnetGroupsResult;
import com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.rds.model.DescribeEventCategoriesRequest;
import com.amazonaws.services.rds.model.DescribeEventCategoriesResult;
import com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest;
import com.amazonaws.services.rds.model.DescribeEventSubscriptionsResult;
import com.amazonaws.services.rds.model.DescribeEventsRequest;
import com.amazonaws.services.rds.model.DescribeEventsResult;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsResult;
import com.amazonaws.services.rds.model.DescribeOptionGroupsRequest;
import com.amazonaws.services.rds.model.DescribeOptionGroupsResult;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsResult;
import com.amazonaws.services.rds.model.DescribePendingMaintenanceActionsRequest;
import com.amazonaws.services.rds.model.DescribePendingMaintenanceActionsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesResult;
import com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest;
import com.amazonaws.services.rds.model.DownloadDBLogFilePortionResult;
import com.amazonaws.services.rds.model.EngineDefaults;
import com.amazonaws.services.rds.model.EventSubscription;
import com.amazonaws.services.rds.model.ListTagsForResourceRequest;
import com.amazonaws.services.rds.model.ListTagsForResourceResult;
import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupResult;
import com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest;
import com.amazonaws.services.rds.model.ModifyOptionGroupRequest;
import com.amazonaws.services.rds.model.OptionGroup;
import com.amazonaws.services.rds.model.PromoteReadReplicaRequest;
import com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest;
import com.amazonaws.services.rds.model.RebootDBInstanceRequest;
import com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest;
import com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.rds.model.ReservedDBInstance;
import com.amazonaws.services.rds.model.ResetDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ResetDBParameterGroupResult;
import com.amazonaws.services.rds.model.ResourcePendingMaintenanceActions;
import com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest;
import com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonRDSAsyncClient
extends AmazonRDSClient
implements AmazonRDSAsync {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonRDSAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRDSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> deleteDBSubnetGroupAsync(final DeleteDBSubnetGroupRequest deleteDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.deleteDBSubnetGroup(deleteDBSubnetGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDBSubnetGroupAsync(final DeleteDBSubnetGroupRequest deleteDBSubnetGroupRequest, final AsyncHandler<DeleteDBSubnetGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRDSAsyncClient.this.deleteDBSubnetGroup(deleteDBSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDBSubnetGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<OptionGroup> copyOptionGroupAsync(final CopyOptionGroupRequest copyOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.copyOptionGroup(copyOptionGroupRequest);
            }
        });
    }

    @Override
    public Future<OptionGroup> copyOptionGroupAsync(final CopyOptionGroupRequest copyOptionGroupRequest, final AsyncHandler<CopyOptionGroupRequest, OptionGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                OptionGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.copyOptionGroup(copyOptionGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)copyOptionGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> restoreDBInstanceToPointInTimeAsync(final RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.restoreDBInstanceToPointInTime(restoreDBInstanceToPointInTimeRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> restoreDBInstanceToPointInTimeAsync(final RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest, final AsyncHandler<RestoreDBInstanceToPointInTimeRequest, DBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.restoreDBInstanceToPointInTime(restoreDBInstanceToPointInTimeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)restoreDBInstanceToPointInTimeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBSnapshot> copyDBSnapshotAsync(final CopyDBSnapshotRequest copyDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                return AmazonRDSAsyncClient.this.copyDBSnapshot(copyDBSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DBSnapshot> copyDBSnapshotAsync(final CopyDBSnapshotRequest copyDBSnapshotRequest, final AsyncHandler<CopyDBSnapshotRequest, DBSnapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                DBSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.copyDBSnapshot(copyDBSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)copyDBSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(final DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePendingMaintenanceActionsResult>(){

            @Override
            public DescribePendingMaintenanceActionsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describePendingMaintenanceActions(describePendingMaintenanceActionsRequest);
            }
        });
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(final DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest, final AsyncHandler<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePendingMaintenanceActionsResult>(){

            @Override
            public DescribePendingMaintenanceActionsResult call() throws Exception {
                DescribePendingMaintenanceActionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describePendingMaintenanceActions(describePendingMaintenanceActionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describePendingMaintenanceActionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(final CreateDBInstanceRequest createDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBInstance(createDBInstanceRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(final CreateDBInstanceRequest createDBInstanceRequest, final AsyncHandler<CreateDBInstanceRequest, DBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBInstance(createDBInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDBInstanceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> createDBSecurityGroupAsync(final CreateDBSecurityGroupRequest createDBSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBSecurityGroup(createDBSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> createDBSecurityGroupAsync(final CreateDBSecurityGroupRequest createDBSecurityGroupRequest, final AsyncHandler<CreateDBSecurityGroupRequest, DBSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                DBSecurityGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBSecurityGroup(createDBSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDBSecurityGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOptionGroupsResult> describeOptionGroupsAsync(final DescribeOptionGroupsRequest describeOptionGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOptionGroupsResult>(){

            @Override
            public DescribeOptionGroupsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeOptionGroups(describeOptionGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeOptionGroupsResult> describeOptionGroupsAsync(final DescribeOptionGroupsRequest describeOptionGroupsRequest, final AsyncHandler<DescribeOptionGroupsRequest, DescribeOptionGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOptionGroupsResult>(){

            @Override
            public DescribeOptionGroupsResult call() throws Exception {
                DescribeOptionGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeOptionGroups(describeOptionGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeOptionGroupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(final DescribeDBInstancesRequest describeDBInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBInstancesResult>(){

            @Override
            public DescribeDBInstancesResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBInstances(describeDBInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(final DescribeDBInstancesRequest describeDBInstancesRequest, final AsyncHandler<DescribeDBInstancesRequest, DescribeDBInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBInstancesResult>(){

            @Override
            public DescribeDBInstancesResult call() throws Exception {
                DescribeDBInstancesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBInstances(describeDBInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDBInstancesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> removeSourceIdentifierFromSubscriptionAsync(final RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                return AmazonRDSAsyncClient.this.removeSourceIdentifierFromSubscription(removeSourceIdentifierFromSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<EventSubscription> removeSourceIdentifierFromSubscriptionAsync(final RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest, final AsyncHandler<RemoveSourceIdentifierFromSubscriptionRequest, EventSubscription> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.removeSourceIdentifierFromSubscription(removeSourceIdentifierFromSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)removeSourceIdentifierFromSubscriptionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteDBSecurityGroupAsync(final DeleteDBSecurityGroupRequest deleteDBSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.deleteDBSecurityGroup(deleteDBSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDBSecurityGroupAsync(final DeleteDBSecurityGroupRequest deleteDBSecurityGroupRequest, final AsyncHandler<DeleteDBSecurityGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRDSAsyncClient.this.deleteDBSecurityGroup(deleteDBSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDBSecurityGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> authorizeDBSecurityGroupIngressAsync(final AuthorizeDBSecurityGroupIngressRequest authorizeDBSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.authorizeDBSecurityGroupIngress(authorizeDBSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> authorizeDBSecurityGroupIngressAsync(final AuthorizeDBSecurityGroupIngressRequest authorizeDBSecurityGroupIngressRequest, final AsyncHandler<AuthorizeDBSecurityGroupIngressRequest, DBSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                DBSecurityGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.authorizeDBSecurityGroupIngress(authorizeDBSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)authorizeDBSecurityGroupIngressRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ResourcePendingMaintenanceActions> applyPendingMaintenanceActionAsync(final ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResourcePendingMaintenanceActions>(){

            @Override
            public ResourcePendingMaintenanceActions call() throws Exception {
                return AmazonRDSAsyncClient.this.applyPendingMaintenanceAction(applyPendingMaintenanceActionRequest);
            }
        });
    }

    @Override
    public Future<ResourcePendingMaintenanceActions> applyPendingMaintenanceActionAsync(final ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest, final AsyncHandler<ApplyPendingMaintenanceActionRequest, ResourcePendingMaintenanceActions> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResourcePendingMaintenanceActions>(){

            @Override
            public ResourcePendingMaintenanceActions call() throws Exception {
                ResourcePendingMaintenanceActions result;
                try {
                    result = AmazonRDSAsyncClient.this.applyPendingMaintenanceAction(applyPendingMaintenanceActionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)applyPendingMaintenanceActionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(final ModifyDBInstanceRequest modifyDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyDBInstance(modifyDBInstanceRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(final ModifyDBInstanceRequest modifyDBInstanceRequest, final AsyncHandler<ModifyDBInstanceRequest, DBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBInstance(modifyDBInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyDBInstanceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> deleteEventSubscriptionAsync(final DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                return AmazonRDSAsyncClient.this.deleteEventSubscription(deleteEventSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<EventSubscription> deleteEventSubscriptionAsync(final DeleteEventSubscriptionRequest deleteEventSubscriptionRequest, final AsyncHandler<DeleteEventSubscriptionRequest, EventSubscription> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteEventSubscription(deleteEventSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteEventSubscriptionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> removeTagsFromResourceAsync(final RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.removeTagsFromResource(removeTagsFromResourceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> removeTagsFromResourceAsync(final RemoveTagsFromResourceRequest removeTagsFromResourceRequest, final AsyncHandler<RemoveTagsFromResourceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRDSAsyncClient.this.removeTagsFromResource(removeTagsFromResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)removeTagsFromResourceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(final DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventCategoriesResult>(){

            @Override
            public DescribeEventCategoriesResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeEventCategories(describeEventCategoriesRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(final DescribeEventCategoriesRequest describeEventCategoriesRequest, final AsyncHandler<DescribeEventCategoriesRequest, DescribeEventCategoriesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventCategoriesResult>(){

            @Override
            public DescribeEventCategoriesResult call() throws Exception {
                DescribeEventCategoriesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEventCategories(describeEventCategoriesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeEventCategoriesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBParameterGroup> copyDBParameterGroupAsync(final CopyDBParameterGroupRequest copyDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.copyDBParameterGroup(copyDBParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<DBParameterGroup> copyDBParameterGroupAsync(final CopyDBParameterGroupRequest copyDBParameterGroupRequest, final AsyncHandler<CopyDBParameterGroupRequest, DBParameterGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                DBParameterGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.copyDBParameterGroup(copyDBParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)copyDBParameterGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceReadReplicaAsync(final CreateDBInstanceReadReplicaRequest createDBInstanceReadReplicaRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBInstanceReadReplica(createDBInstanceReadReplicaRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceReadReplicaAsync(final CreateDBInstanceReadReplicaRequest createDBInstanceReadReplicaRequest, final AsyncHandler<CreateDBInstanceReadReplicaRequest, DBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBInstanceReadReplica(createDBInstanceReadReplicaRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDBInstanceReadReplicaRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBSnapshot> deleteDBSnapshotAsync(final DeleteDBSnapshotRequest deleteDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                return AmazonRDSAsyncClient.this.deleteDBSnapshot(deleteDBSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DBSnapshot> deleteDBSnapshotAsync(final DeleteDBSnapshotRequest deleteDBSnapshotRequest, final AsyncHandler<DeleteDBSnapshotRequest, DBSnapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                DBSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBSnapshot(deleteDBSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDBSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(final RebootDBInstanceRequest rebootDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.rebootDBInstance(rebootDBInstanceRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(final RebootDBInstanceRequest rebootDBInstanceRequest, final AsyncHandler<RebootDBInstanceRequest, DBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.rebootDBInstance(rebootDBInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)rebootDBInstanceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeEvents(describeEventsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEvents(describeEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeEventsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest listTagsForResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                return AmazonRDSAsyncClient.this.listTagsForResource(listTagsForResourceRequest);
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest listTagsForResourceRequest, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonRDSAsyncClient.this.listTagsForResource(listTagsForResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTagsForResourceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBParametersResult> describeDBParametersAsync(final DescribeDBParametersRequest describeDBParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBParametersResult>(){

            @Override
            public DescribeDBParametersResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBParameters(describeDBParametersRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBParametersResult> describeDBParametersAsync(final DescribeDBParametersRequest describeDBParametersRequest, final AsyncHandler<DescribeDBParametersRequest, DescribeDBParametersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBParametersResult>(){

            @Override
            public DescribeDBParametersResult call() throws Exception {
                DescribeDBParametersResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBParameters(describeDBParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDBParametersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOptionGroupOptionsResult> describeOptionGroupOptionsAsync(final DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOptionGroupOptionsResult>(){

            @Override
            public DescribeOptionGroupOptionsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeOptionGroupOptions(describeOptionGroupOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeOptionGroupOptionsResult> describeOptionGroupOptionsAsync(final DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest, final AsyncHandler<DescribeOptionGroupOptionsRequest, DescribeOptionGroupOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOptionGroupOptionsResult>(){

            @Override
            public DescribeOptionGroupOptionsResult call() throws Exception {
                DescribeOptionGroupOptionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeOptionGroupOptions(describeOptionGroupOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeOptionGroupOptionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ReservedDBInstance> purchaseReservedDBInstancesOfferingAsync(final PurchaseReservedDBInstancesOfferingRequest purchaseReservedDBInstancesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedDBInstance>(){

            @Override
            public ReservedDBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.purchaseReservedDBInstancesOffering(purchaseReservedDBInstancesOfferingRequest);
            }
        });
    }

    @Override
    public Future<ReservedDBInstance> purchaseReservedDBInstancesOfferingAsync(final PurchaseReservedDBInstancesOfferingRequest purchaseReservedDBInstancesOfferingRequest, final AsyncHandler<PurchaseReservedDBInstancesOfferingRequest, ReservedDBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedDBInstance>(){

            @Override
            public ReservedDBInstance call() throws Exception {
                ReservedDBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.purchaseReservedDBInstancesOffering(purchaseReservedDBInstancesOfferingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)purchaseReservedDBInstancesOfferingRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSecurityGroupsResult> describeDBSecurityGroupsAsync(final DescribeDBSecurityGroupsRequest describeDBSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSecurityGroupsResult>(){

            @Override
            public DescribeDBSecurityGroupsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBSecurityGroups(describeDBSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBSecurityGroupsResult> describeDBSecurityGroupsAsync(final DescribeDBSecurityGroupsRequest describeDBSecurityGroupsRequest, final AsyncHandler<DescribeDBSecurityGroupsRequest, DescribeDBSecurityGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSecurityGroupsResult>(){

            @Override
            public DescribeDBSecurityGroupsResult call() throws Exception {
                DescribeDBSecurityGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBSecurityGroups(describeDBSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDBSecurityGroupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(final ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyEventSubscription(modifyEventSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(final ModifyEventSubscriptionRequest modifyEventSubscriptionRequest, final AsyncHandler<ModifyEventSubscriptionRequest, EventSubscription> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyEventSubscription(modifyEventSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyEventSubscriptionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(final DeleteDBInstanceRequest deleteDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.deleteDBInstance(deleteDBInstanceRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(final DeleteDBInstanceRequest deleteDBInstanceRequest, final AsyncHandler<DeleteDBInstanceRequest, DBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBInstance(deleteDBInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDBInstanceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> restoreDBInstanceFromDBSnapshotAsync(final RestoreDBInstanceFromDBSnapshotRequest restoreDBInstanceFromDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.restoreDBInstanceFromDBSnapshot(restoreDBInstanceFromDBSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> restoreDBInstanceFromDBSnapshotAsync(final RestoreDBInstanceFromDBSnapshotRequest restoreDBInstanceFromDBSnapshotRequest, final AsyncHandler<RestoreDBInstanceFromDBSnapshotRequest, DBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.restoreDBInstanceFromDBSnapshot(restoreDBInstanceFromDBSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)restoreDBInstanceFromDBSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<OptionGroup> createOptionGroupAsync(final CreateOptionGroupRequest createOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.createOptionGroup(createOptionGroupRequest);
            }
        });
    }

    @Override
    public Future<OptionGroup> createOptionGroupAsync(final CreateOptionGroupRequest createOptionGroupRequest, final AsyncHandler<CreateOptionGroupRequest, OptionGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                OptionGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createOptionGroup(createOptionGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createOptionGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<OptionGroup> modifyOptionGroupAsync(final ModifyOptionGroupRequest modifyOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyOptionGroup(modifyOptionGroupRequest);
            }
        });
    }

    @Override
    public Future<OptionGroup> modifyOptionGroupAsync(final ModifyOptionGroupRequest modifyOptionGroupRequest, final AsyncHandler<ModifyOptionGroupRequest, OptionGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                OptionGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyOptionGroup(modifyOptionGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyOptionGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(final DescribeDBSubnetGroupsRequest describeDBSubnetGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSubnetGroupsResult>(){

            @Override
            public DescribeDBSubnetGroupsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBSubnetGroups(describeDBSubnetGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(final DescribeDBSubnetGroupsRequest describeDBSubnetGroupsRequest, final AsyncHandler<DescribeDBSubnetGroupsRequest, DescribeDBSubnetGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSubnetGroupsResult>(){

            @Override
            public DescribeDBSubnetGroupsResult call() throws Exception {
                DescribeDBSubnetGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBSubnetGroups(describeDBSubnetGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDBSubnetGroupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync(final DescribeDBParameterGroupsRequest describeDBParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBParameterGroupsResult>(){

            @Override
            public DescribeDBParameterGroupsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBParameterGroups(describeDBParameterGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync(final DescribeDBParameterGroupsRequest describeDBParameterGroupsRequest, final AsyncHandler<DescribeDBParameterGroupsRequest, DescribeDBParameterGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBParameterGroupsResult>(){

            @Override
            public DescribeDBParameterGroupsResult call() throws Exception {
                DescribeDBParameterGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBParameterGroups(describeDBParameterGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDBParameterGroupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(final DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventSubscriptionsResult>(){

            @Override
            public DescribeEventSubscriptionsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeEventSubscriptions(describeEventSubscriptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(final DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest, final AsyncHandler<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventSubscriptionsResult>(){

            @Override
            public DescribeEventSubscriptionsResult call() throws Exception {
                DescribeEventSubscriptionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEventSubscriptions(describeEventSubscriptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeEventSubscriptionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(final ModifyDBSubnetGroupRequest modifyDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyDBSubnetGroup(modifyDBSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(final ModifyDBSubnetGroupRequest modifyDBSubnetGroupRequest, final AsyncHandler<ModifyDBSubnetGroupRequest, DBSubnetGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                DBSubnetGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBSubnetGroup(modifyDBSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyDBSubnetGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSnapshotsResult> describeDBSnapshotsAsync(final DescribeDBSnapshotsRequest describeDBSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSnapshotsResult>(){

            @Override
            public DescribeDBSnapshotsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBSnapshots(describeDBSnapshotsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBSnapshotsResult> describeDBSnapshotsAsync(final DescribeDBSnapshotsRequest describeDBSnapshotsRequest, final AsyncHandler<DescribeDBSnapshotsRequest, DescribeDBSnapshotsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSnapshotsResult>(){

            @Override
            public DescribeDBSnapshotsResult call() throws Exception {
                DescribeDBSnapshotsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBSnapshots(describeDBSnapshotsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDBSnapshotsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(final CreateDBSubnetGroupRequest createDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBSubnetGroup(createDBSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(final CreateDBSubnetGroupRequest createDBSubnetGroupRequest, final AsyncHandler<CreateDBSubnetGroupRequest, DBSubnetGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                DBSubnetGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBSubnetGroup(createDBSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDBSubnetGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(final DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAccountAttributesResult>(){

            @Override
            public DescribeAccountAttributesResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeAccountAttributes(describeAccountAttributesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(final DescribeAccountAttributesRequest describeAccountAttributesRequest, final AsyncHandler<DescribeAccountAttributesRequest, DescribeAccountAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAccountAttributesResult>(){

            @Override
            public DescribeAccountAttributesResult call() throws Exception {
                DescribeAccountAttributesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeAccountAttributes(describeAccountAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeAccountAttributesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(final DescribeDBEngineVersionsRequest describeDBEngineVersionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBEngineVersionsResult>(){

            @Override
            public DescribeDBEngineVersionsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBEngineVersions(describeDBEngineVersionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(final DescribeDBEngineVersionsRequest describeDBEngineVersionsRequest, final AsyncHandler<DescribeDBEngineVersionsRequest, DescribeDBEngineVersionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBEngineVersionsResult>(){

            @Override
            public DescribeDBEngineVersionsResult call() throws Exception {
                DescribeDBEngineVersionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBEngineVersions(describeDBEngineVersionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDBEngineVersionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyDBParameterGroupResult> modifyDBParameterGroupAsync(final ModifyDBParameterGroupRequest modifyDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyDBParameterGroupResult>(){

            @Override
            public ModifyDBParameterGroupResult call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyDBParameterGroup(modifyDBParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ModifyDBParameterGroupResult> modifyDBParameterGroupAsync(final ModifyDBParameterGroupRequest modifyDBParameterGroupRequest, final AsyncHandler<ModifyDBParameterGroupRequest, ModifyDBParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyDBParameterGroupResult>(){

            @Override
            public ModifyDBParameterGroupResult call() throws Exception {
                ModifyDBParameterGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBParameterGroup(modifyDBParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyDBParameterGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                return AmazonRDSAsyncClient.this.describeEngineDefaultParameters(describeEngineDefaultParametersRequest);
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest, final AsyncHandler<DescribeEngineDefaultParametersRequest, EngineDefaults> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEngineDefaultParameters(describeEngineDefaultParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeEngineDefaultParametersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBSnapshot> createDBSnapshotAsync(final CreateDBSnapshotRequest createDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBSnapshot(createDBSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DBSnapshot> createDBSnapshotAsync(final CreateDBSnapshotRequest createDBSnapshotRequest, final AsyncHandler<CreateDBSnapshotRequest, DBSnapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                DBSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBSnapshot(createDBSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDBSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> addSourceIdentifierToSubscriptionAsync(final AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                return AmazonRDSAsyncClient.this.addSourceIdentifierToSubscription(addSourceIdentifierToSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<EventSubscription> addSourceIdentifierToSubscriptionAsync(final AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest, final AsyncHandler<AddSourceIdentifierToSubscriptionRequest, EventSubscription> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.addSourceIdentifierToSubscription(addSourceIdentifierToSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)addSourceIdentifierToSubscriptionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ResetDBParameterGroupResult> resetDBParameterGroupAsync(final ResetDBParameterGroupRequest resetDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetDBParameterGroupResult>(){

            @Override
            public ResetDBParameterGroupResult call() throws Exception {
                return AmazonRDSAsyncClient.this.resetDBParameterGroup(resetDBParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ResetDBParameterGroupResult> resetDBParameterGroupAsync(final ResetDBParameterGroupRequest resetDBParameterGroupRequest, final AsyncHandler<ResetDBParameterGroupRequest, ResetDBParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetDBParameterGroupResult>(){

            @Override
            public ResetDBParameterGroupResult call() throws Exception {
                ResetDBParameterGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.resetDBParameterGroup(resetDBParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)resetDBParameterGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteDBParameterGroupAsync(final DeleteDBParameterGroupRequest deleteDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.deleteDBParameterGroup(deleteDBParameterGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDBParameterGroupAsync(final DeleteDBParameterGroupRequest deleteDBParameterGroupRequest, final AsyncHandler<DeleteDBParameterGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRDSAsyncClient.this.deleteDBParameterGroup(deleteDBParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDBParameterGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeDBLogFilesResult> describeDBLogFilesAsync(final DescribeDBLogFilesRequest describeDBLogFilesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBLogFilesResult>(){

            @Override
            public DescribeDBLogFilesResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBLogFiles(describeDBLogFilesRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBLogFilesResult> describeDBLogFilesAsync(final DescribeDBLogFilesRequest describeDBLogFilesRequest, final AsyncHandler<DescribeDBLogFilesRequest, DescribeDBLogFilesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBLogFilesResult>(){

            @Override
            public DescribeDBLogFilesResult call() throws Exception {
                DescribeDBLogFilesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBLogFiles(describeDBLogFilesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDBLogFilesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedDBInstancesResult> describeReservedDBInstancesAsync(final DescribeReservedDBInstancesRequest describeReservedDBInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedDBInstancesResult>(){

            @Override
            public DescribeReservedDBInstancesResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeReservedDBInstances(describeReservedDBInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedDBInstancesResult> describeReservedDBInstancesAsync(final DescribeReservedDBInstancesRequest describeReservedDBInstancesRequest, final AsyncHandler<DescribeReservedDBInstancesRequest, DescribeReservedDBInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedDBInstancesResult>(){

            @Override
            public DescribeReservedDBInstancesResult call() throws Exception {
                DescribeReservedDBInstancesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeReservedDBInstances(describeReservedDBInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeReservedDBInstancesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> promoteReadReplicaAsync(final PromoteReadReplicaRequest promoteReadReplicaRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.promoteReadReplica(promoteReadReplicaRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> promoteReadReplicaAsync(final PromoteReadReplicaRequest promoteReadReplicaRequest, final AsyncHandler<PromoteReadReplicaRequest, DBInstance> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.promoteReadReplica(promoteReadReplicaRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)promoteReadReplicaRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> addTagsToResourceAsync(final AddTagsToResourceRequest addTagsToResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.addTagsToResource(addTagsToResourceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> addTagsToResourceAsync(final AddTagsToResourceRequest addTagsToResourceRequest, final AsyncHandler<AddTagsToResourceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRDSAsyncClient.this.addTagsToResource(addTagsToResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)addTagsToResourceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DownloadDBLogFilePortionResult> downloadDBLogFilePortionAsync(final DownloadDBLogFilePortionRequest downloadDBLogFilePortionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DownloadDBLogFilePortionResult>(){

            @Override
            public DownloadDBLogFilePortionResult call() throws Exception {
                return AmazonRDSAsyncClient.this.downloadDBLogFilePortion(downloadDBLogFilePortionRequest);
            }
        });
    }

    @Override
    public Future<DownloadDBLogFilePortionResult> downloadDBLogFilePortionAsync(final DownloadDBLogFilePortionRequest downloadDBLogFilePortionRequest, final AsyncHandler<DownloadDBLogFilePortionRequest, DownloadDBLogFilePortionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DownloadDBLogFilePortionResult>(){

            @Override
            public DownloadDBLogFilePortionResult call() throws Exception {
                DownloadDBLogFilePortionResult result;
                try {
                    result = AmazonRDSAsyncClient.this.downloadDBLogFilePortion(downloadDBLogFilePortionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)downloadDBLogFilePortionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(final CreateEventSubscriptionRequest createEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                return AmazonRDSAsyncClient.this.createEventSubscription(createEventSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(final CreateEventSubscriptionRequest createEventSubscriptionRequest, final AsyncHandler<CreateEventSubscriptionRequest, EventSubscription> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.createEventSubscription(createEventSubscriptionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createEventSubscriptionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> revokeDBSecurityGroupIngressAsync(final RevokeDBSecurityGroupIngressRequest revokeDBSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.revokeDBSecurityGroupIngress(revokeDBSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> revokeDBSecurityGroupIngressAsync(final RevokeDBSecurityGroupIngressRequest revokeDBSecurityGroupIngressRequest, final AsyncHandler<RevokeDBSecurityGroupIngressRequest, DBSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                DBSecurityGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.revokeDBSecurityGroupIngress(revokeDBSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)revokeDBSecurityGroupIngressRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(final DescribeOrderableDBInstanceOptionsRequest describeOrderableDBInstanceOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOrderableDBInstanceOptionsResult>(){

            @Override
            public DescribeOrderableDBInstanceOptionsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeOrderableDBInstanceOptions(describeOrderableDBInstanceOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(final DescribeOrderableDBInstanceOptionsRequest describeOrderableDBInstanceOptionsRequest, final AsyncHandler<DescribeOrderableDBInstanceOptionsRequest, DescribeOrderableDBInstanceOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOrderableDBInstanceOptionsResult>(){

            @Override
            public DescribeOrderableDBInstanceOptionsResult call() throws Exception {
                DescribeOrderableDBInstanceOptionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeOrderableDBInstanceOptions(describeOrderableDBInstanceOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeOrderableDBInstanceOptionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DBParameterGroup> createDBParameterGroupAsync(final CreateDBParameterGroupRequest createDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBParameterGroup(createDBParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<DBParameterGroup> createDBParameterGroupAsync(final CreateDBParameterGroupRequest createDBParameterGroupRequest, final AsyncHandler<CreateDBParameterGroupRequest, DBParameterGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                DBParameterGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBParameterGroup(createDBParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDBParameterGroupRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificatesResult> describeCertificatesAsync(final DescribeCertificatesRequest describeCertificatesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCertificatesResult>(){

            @Override
            public DescribeCertificatesResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeCertificates(describeCertificatesRequest);
            }
        });
    }

    @Override
    public Future<DescribeCertificatesResult> describeCertificatesAsync(final DescribeCertificatesRequest describeCertificatesRequest, final AsyncHandler<DescribeCertificatesRequest, DescribeCertificatesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCertificatesResult>(){

            @Override
            public DescribeCertificatesResult call() throws Exception {
                DescribeCertificatesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeCertificates(describeCertificatesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeCertificatesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedDBInstancesOfferingsResult> describeReservedDBInstancesOfferingsAsync(final DescribeReservedDBInstancesOfferingsRequest describeReservedDBInstancesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedDBInstancesOfferingsResult>(){

            @Override
            public DescribeReservedDBInstancesOfferingsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeReservedDBInstancesOfferings(describeReservedDBInstancesOfferingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedDBInstancesOfferingsResult> describeReservedDBInstancesOfferingsAsync(final DescribeReservedDBInstancesOfferingsRequest describeReservedDBInstancesOfferingsRequest, final AsyncHandler<DescribeReservedDBInstancesOfferingsRequest, DescribeReservedDBInstancesOfferingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedDBInstancesOfferingsResult>(){

            @Override
            public DescribeReservedDBInstancesOfferingsResult call() throws Exception {
                DescribeReservedDBInstancesOfferingsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeReservedDBInstancesOfferings(describeReservedDBInstancesOfferingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeReservedDBInstancesOfferingsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteOptionGroupAsync(final DeleteOptionGroupRequest deleteOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.deleteOptionGroup(deleteOptionGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteOptionGroupAsync(final DeleteOptionGroupRequest deleteOptionGroupRequest, final AsyncHandler<DeleteOptionGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRDSAsyncClient.this.deleteOptionGroup(deleteOptionGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteOptionGroupRequest, null);
                return null;
            }
        });
    }
}

