/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RestoreDBInstanceToPointInTimeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceDBInstanceIdentifier;
    private String targetDBInstanceIdentifier;
    private Date restoreTime;
    private Boolean useLatestRestorableTime;
    private String dBInstanceClass;
    private Integer port;
    private String availabilityZone;
    private String dBSubnetGroupName;
    private Boolean multiAZ;
    private Boolean publiclyAccessible;
    private Boolean autoMinorVersionUpgrade;
    private String licenseModel;
    private String dBName;
    private String engine;
    private Integer iops;
    private String optionGroupName;
    private Boolean copyTagsToSnapshot;
    private ListWithAutoConstructFlag<Tag> tags;
    private String storageType;
    private String tdeCredentialArn;
    private String tdeCredentialPassword;
    private String domain;
    private String domainIAMRoleName;

    public RestoreDBInstanceToPointInTimeRequest() {
    }

    public RestoreDBInstanceToPointInTimeRequest(String sourceDBInstanceIdentifier, String targetDBInstanceIdentifier) {
        this.setSourceDBInstanceIdentifier(sourceDBInstanceIdentifier);
        this.setTargetDBInstanceIdentifier(targetDBInstanceIdentifier);
    }

    public String getSourceDBInstanceIdentifier() {
        return this.sourceDBInstanceIdentifier;
    }

    public void setSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
        this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
    }

    public RestoreDBInstanceToPointInTimeRequest withSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
        this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
        return this;
    }

    public String getTargetDBInstanceIdentifier() {
        return this.targetDBInstanceIdentifier;
    }

    public void setTargetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
        this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
    }

    public RestoreDBInstanceToPointInTimeRequest withTargetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
        this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
        return this;
    }

    public Date getRestoreTime() {
        return this.restoreTime;
    }

    public void setRestoreTime(Date restoreTime) {
        this.restoreTime = restoreTime;
    }

    public RestoreDBInstanceToPointInTimeRequest withRestoreTime(Date restoreTime) {
        this.restoreTime = restoreTime;
        return this;
    }

    public Boolean isUseLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
        this.useLatestRestorableTime = useLatestRestorableTime;
    }

    public RestoreDBInstanceToPointInTimeRequest withUseLatestRestorableTime(Boolean useLatestRestorableTime) {
        this.useLatestRestorableTime = useLatestRestorableTime;
        return this;
    }

    public Boolean getUseLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public RestoreDBInstanceToPointInTimeRequest withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public RestoreDBInstanceToPointInTimeRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public RestoreDBInstanceToPointInTimeRequest withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public String getDBSubnetGroupName() {
        return this.dBSubnetGroupName;
    }

    public void setDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
    }

    public RestoreDBInstanceToPointInTimeRequest withDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public RestoreDBInstanceToPointInTimeRequest withMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
        return this;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public RestoreDBInstanceToPointInTimeRequest withPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
        return this;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public RestoreDBInstanceToPointInTimeRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public RestoreDBInstanceToPointInTimeRequest withLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
        return this;
    }

    public String getDBName() {
        return this.dBName;
    }

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public RestoreDBInstanceToPointInTimeRequest withDBName(String dBName) {
        this.dBName = dBName;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public RestoreDBInstanceToPointInTimeRequest withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public RestoreDBInstanceToPointInTimeRequest withIops(Integer iops) {
        this.iops = iops;
        return this;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public RestoreDBInstanceToPointInTimeRequest withOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
        return this;
    }

    public Boolean isCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
    }

    public RestoreDBInstanceToPointInTimeRequest withCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
        return this;
    }

    public Boolean getCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RestoreDBInstanceToPointInTimeRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RestoreDBInstanceToPointInTimeRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public RestoreDBInstanceToPointInTimeRequest withStorageType(String storageType) {
        this.storageType = storageType;
        return this;
    }

    public String getTdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public void setTdeCredentialArn(String tdeCredentialArn) {
        this.tdeCredentialArn = tdeCredentialArn;
    }

    public RestoreDBInstanceToPointInTimeRequest withTdeCredentialArn(String tdeCredentialArn) {
        this.tdeCredentialArn = tdeCredentialArn;
        return this;
    }

    public String getTdeCredentialPassword() {
        return this.tdeCredentialPassword;
    }

    public void setTdeCredentialPassword(String tdeCredentialPassword) {
        this.tdeCredentialPassword = tdeCredentialPassword;
    }

    public RestoreDBInstanceToPointInTimeRequest withTdeCredentialPassword(String tdeCredentialPassword) {
        this.tdeCredentialPassword = tdeCredentialPassword;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public RestoreDBInstanceToPointInTimeRequest withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getDomainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public void setDomainIAMRoleName(String domainIAMRoleName) {
        this.domainIAMRoleName = domainIAMRoleName;
    }

    public RestoreDBInstanceToPointInTimeRequest withDomainIAMRoleName(String domainIAMRoleName) {
        this.domainIAMRoleName = domainIAMRoleName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceDBInstanceIdentifier() != null) {
            sb.append("SourceDBInstanceIdentifier: " + this.getSourceDBInstanceIdentifier() + ",");
        }
        if (this.getTargetDBInstanceIdentifier() != null) {
            sb.append("TargetDBInstanceIdentifier: " + this.getTargetDBInstanceIdentifier() + ",");
        }
        if (this.getRestoreTime() != null) {
            sb.append("RestoreTime: " + this.getRestoreTime() + ",");
        }
        if (this.isUseLatestRestorableTime() != null) {
            sb.append("UseLatestRestorableTime: " + this.isUseLatestRestorableTime() + ",");
        }
        if (this.getDBInstanceClass() != null) {
            sb.append("DBInstanceClass: " + this.getDBInstanceClass() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getDBSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: " + this.getDBSubnetGroupName() + ",");
        }
        if (this.isMultiAZ() != null) {
            sb.append("MultiAZ: " + this.isMultiAZ() + ",");
        }
        if (this.isPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: " + this.isPubliclyAccessible() + ",");
        }
        if (this.isAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.isAutoMinorVersionUpgrade() + ",");
        }
        if (this.getLicenseModel() != null) {
            sb.append("LicenseModel: " + this.getLicenseModel() + ",");
        }
        if (this.getDBName() != null) {
            sb.append("DBName: " + this.getDBName() + ",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getIops() != null) {
            sb.append("Iops: " + this.getIops() + ",");
        }
        if (this.getOptionGroupName() != null) {
            sb.append("OptionGroupName: " + this.getOptionGroupName() + ",");
        }
        if (this.isCopyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: " + this.isCopyTagsToSnapshot() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getStorageType() != null) {
            sb.append("StorageType: " + this.getStorageType() + ",");
        }
        if (this.getTdeCredentialArn() != null) {
            sb.append("TdeCredentialArn: " + this.getTdeCredentialArn() + ",");
        }
        if (this.getTdeCredentialPassword() != null) {
            sb.append("TdeCredentialPassword: " + this.getTdeCredentialPassword() + ",");
        }
        if (this.getDomain() != null) {
            sb.append("Domain: " + this.getDomain() + ",");
        }
        if (this.getDomainIAMRoleName() != null) {
            sb.append("DomainIAMRoleName: " + this.getDomainIAMRoleName());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceDBInstanceIdentifier() == null ? 0 : this.getSourceDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDBInstanceIdentifier() == null ? 0 : this.getTargetDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getRestoreTime() == null ? 0 : this.getRestoreTime().hashCode());
        hashCode = 31 * hashCode + (this.isUseLatestRestorableTime() == null ? 0 : this.isUseLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroupName() == null ? 0 : this.getDBSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.isMultiAZ() == null ? 0 : this.isMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.isPubliclyAccessible() == null ? 0 : this.isPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.isCopyTagsToSnapshot() == null ? 0 : this.isCopyTagsToSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getStorageType() == null ? 0 : this.getStorageType().hashCode());
        hashCode = 31 * hashCode + (this.getTdeCredentialArn() == null ? 0 : this.getTdeCredentialArn().hashCode());
        hashCode = 31 * hashCode + (this.getTdeCredentialPassword() == null ? 0 : this.getTdeCredentialPassword().hashCode());
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIAMRoleName() == null ? 0 : this.getDomainIAMRoleName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDBInstanceToPointInTimeRequest)) {
            return false;
        }
        RestoreDBInstanceToPointInTimeRequest other = (RestoreDBInstanceToPointInTimeRequest)obj;
        if (other.getSourceDBInstanceIdentifier() == null ^ this.getSourceDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getSourceDBInstanceIdentifier() != null && !other.getSourceDBInstanceIdentifier().equals(this.getSourceDBInstanceIdentifier())) {
            return false;
        }
        if (other.getTargetDBInstanceIdentifier() == null ^ this.getTargetDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getTargetDBInstanceIdentifier() != null && !other.getTargetDBInstanceIdentifier().equals(this.getTargetDBInstanceIdentifier())) {
            return false;
        }
        if (other.getRestoreTime() == null ^ this.getRestoreTime() == null) {
            return false;
        }
        if (other.getRestoreTime() != null && !other.getRestoreTime().equals(this.getRestoreTime())) {
            return false;
        }
        if (other.isUseLatestRestorableTime() == null ^ this.isUseLatestRestorableTime() == null) {
            return false;
        }
        if (other.isUseLatestRestorableTime() != null && !other.isUseLatestRestorableTime().equals(this.isUseLatestRestorableTime())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDBSubnetGroupName() == null ^ this.getDBSubnetGroupName() == null) {
            return false;
        }
        if (other.getDBSubnetGroupName() != null && !other.getDBSubnetGroupName().equals(this.getDBSubnetGroupName())) {
            return false;
        }
        if (other.isMultiAZ() == null ^ this.isMultiAZ() == null) {
            return false;
        }
        if (other.isMultiAZ() != null && !other.isMultiAZ().equals(this.isMultiAZ())) {
            return false;
        }
        if (other.isPubliclyAccessible() == null ^ this.isPubliclyAccessible() == null) {
            return false;
        }
        if (other.isPubliclyAccessible() != null && !other.isPubliclyAccessible().equals(this.isPubliclyAccessible())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() != null && !other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        if (other.getLicenseModel() != null && !other.getLicenseModel().equals(this.getLicenseModel())) {
            return false;
        }
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        if (other.getIops() != null && !other.getIops().equals(this.getIops())) {
            return false;
        }
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.isCopyTagsToSnapshot() == null ^ this.isCopyTagsToSnapshot() == null) {
            return false;
        }
        if (other.isCopyTagsToSnapshot() != null && !other.isCopyTagsToSnapshot().equals(this.isCopyTagsToSnapshot())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getStorageType() == null ^ this.getStorageType() == null) {
            return false;
        }
        if (other.getStorageType() != null && !other.getStorageType().equals(this.getStorageType())) {
            return false;
        }
        if (other.getTdeCredentialArn() == null ^ this.getTdeCredentialArn() == null) {
            return false;
        }
        if (other.getTdeCredentialArn() != null && !other.getTdeCredentialArn().equals(this.getTdeCredentialArn())) {
            return false;
        }
        if (other.getTdeCredentialPassword() == null ^ this.getTdeCredentialPassword() == null) {
            return false;
        }
        if (other.getTdeCredentialPassword() != null && !other.getTdeCredentialPassword().equals(this.getTdeCredentialPassword())) {
            return false;
        }
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getDomainIAMRoleName() == null ^ this.getDomainIAMRoleName() == null) {
            return false;
        }
        return other.getDomainIAMRoleName() == null || other.getDomainIAMRoleName().equals(this.getDomainIAMRoleName());
    }

    public RestoreDBInstanceToPointInTimeRequest clone() {
        return (RestoreDBInstanceToPointInTimeRequest)super.clone();
    }
}

