/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.Certificate;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CertificateStaxUnmarshaller
implements Unmarshaller<Certificate, StaxUnmarshallerContext> {
    private static CertificateStaxUnmarshaller instance;

    public Certificate unmarshall(StaxUnmarshallerContext context) throws Exception {
        Certificate certificate = new Certificate();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return certificate;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CertificateIdentifier", targetDepth)) {
                    certificate.setCertificateIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CertificateType", targetDepth)) {
                    certificate.setCertificateType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Thumbprint", targetDepth)) {
                    certificate.setThumbprint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ValidFrom", targetDepth)) {
                    certificate.setValidFrom(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ValidTill", targetDepth)) continue;
                certificate.setValidTill(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return certificate;
    }

    public static CertificateStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CertificateStaxUnmarshaller();
        }
        return instance;
    }
}

