/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.OptionConfiguration;
import com.amazonaws.services.rds.model.transform.OptionSettingStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class OptionConfigurationStaxUnmarshaller
implements Unmarshaller<OptionConfiguration, StaxUnmarshallerContext> {
    private static OptionConfigurationStaxUnmarshaller instance;

    public OptionConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        OptionConfiguration optionConfiguration = new OptionConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return optionConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("OptionName", targetDepth)) {
                    optionConfiguration.setOptionName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    optionConfiguration.setPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBSecurityGroupMemberships/DBSecurityGroupName", targetDepth)) {
                    optionConfiguration.withDBSecurityGroupMemberships(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroupMemberships/VpcSecurityGroupId", targetDepth)) {
                    optionConfiguration.withVpcSecurityGroupMemberships(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OptionSettings/OptionSetting", targetDepth)) continue;
                optionConfiguration.withOptionSettings(OptionSettingStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return optionConfiguration;
    }

    public static OptionConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OptionConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

