/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CopyDBClusterSnapshotRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopyDBClusterSnapshotRequestMarshaller
implements Marshaller<Request<CopyDBClusterSnapshotRequest>, CopyDBClusterSnapshotRequest> {
    public Request<CopyDBClusterSnapshotRequest> marshall(CopyDBClusterSnapshotRequest copyDBClusterSnapshotRequest) {
        SdkInternalList tagsList;
        if (copyDBClusterSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDBClusterSnapshotRequest, "AmazonRDS");
        request.addParameter("Action", "CopyDBClusterSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBClusterSnapshotRequest.getSourceDBClusterSnapshotIdentifier() != null) {
            request.addParameter("SourceDBClusterSnapshotIdentifier", StringUtils.fromString((String)copyDBClusterSnapshotRequest.getSourceDBClusterSnapshotIdentifier()));
        }
        if (copyDBClusterSnapshotRequest.getTargetDBClusterSnapshotIdentifier() != null) {
            request.addParameter("TargetDBClusterSnapshotIdentifier", StringUtils.fromString((String)copyDBClusterSnapshotRequest.getTargetDBClusterSnapshotIdentifier()));
        }
        if (copyDBClusterSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)copyDBClusterSnapshotRequest.getKmsKeyId()));
        }
        if (copyDBClusterSnapshotRequest.getPreSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)copyDBClusterSnapshotRequest.getPreSignedUrl()));
        }
        if (copyDBClusterSnapshotRequest.getCopyTags() != null) {
            request.addParameter("CopyTags", StringUtils.fromBoolean((Boolean)copyDBClusterSnapshotRequest.getCopyTags()));
        }
        if (!(tagsList = (SdkInternalList)copyDBClusterSnapshotRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (copyDBClusterSnapshotRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)copyDBClusterSnapshotRequest.getSourceRegion()));
        }
        return request;
    }
}

