/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.waiters.DBInstanceAvailable;
import com.amazonaws.services.rds.waiters.DBInstanceDeleted;
import com.amazonaws.services.rds.waiters.DescribeDBInstancesFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonRDSWaiters {
    private final AmazonRDS client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonRDSWaiters(AmazonRDS client) {
        this.client = client;
    }

    public Waiter dBInstanceAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDBInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DBInstanceAvailable.IsAvailableMatcher(), new DBInstanceAvailable.IsDeletedMatcher(), new DBInstanceAvailable.IsDeletingMatcher(), new DBInstanceAvailable.IsFailedMatcher(), new DBInstanceAvailable.IsIncompatibleparametersMatcher(), new DBInstanceAvailable.IsIncompatiblerestoreMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter dBInstanceDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDBInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DBInstanceDeleted.IsDeletedMatcher(), new DBInstanceDeleted.IsDBInstanceNotFoundMatcher(), new DBInstanceDeleted.IsCreatingMatcher(), new DBInstanceDeleted.IsModifyingMatcher(), new DBInstanceDeleted.IsRebootingMatcher(), new DBInstanceDeleted.IsResettingmastercredentialsMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

