/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DBClusterMember;
import com.amazonaws.services.rds.model.DBClusterOptionGroupStatus;
import com.amazonaws.services.rds.model.DBClusterRole;
import com.amazonaws.services.rds.model.VpcSecurityGroupMembership;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DBCluster
implements Serializable,
Cloneable {
    private Integer allocatedStorage;
    private SdkInternalList<String> availabilityZones;
    private Integer backupRetentionPeriod;
    private String characterSetName;
    private String databaseName;
    private String dBClusterIdentifier;
    private String dBClusterParameterGroup;
    private String dBSubnetGroup;
    private String status;
    private String percentProgress;
    private Date earliestRestorableTime;
    private String endpoint;
    private String readerEndpoint;
    private Boolean multiAZ;
    private String engine;
    private String engineVersion;
    private Date latestRestorableTime;
    private Integer port;
    private String masterUsername;
    private SdkInternalList<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships;
    private String preferredBackupWindow;
    private String preferredMaintenanceWindow;
    private String replicationSourceIdentifier;
    private SdkInternalList<String> readReplicaIdentifiers;
    private SdkInternalList<DBClusterMember> dBClusterMembers;
    private SdkInternalList<VpcSecurityGroupMembership> vpcSecurityGroups;
    private String hostedZoneId;
    private Boolean storageEncrypted;
    private String kmsKeyId;
    private String dbClusterResourceId;
    private String dBClusterArn;
    private SdkInternalList<DBClusterRole> associatedRoles;
    private Boolean iAMDatabaseAuthenticationEnabled;
    private String cloneGroupId;
    private Date clusterCreateTime;
    private Date earliestBacktrackTime;
    private Long backtrackWindow;
    private Long backtrackConsumedChangeRecords;

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public DBCluster withAllocatedStorage(Integer allocatedStorage) {
        this.setAllocatedStorage(allocatedStorage);
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList(availabilityZones);
    }

    public DBCluster withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones((Collection<String>)new SdkInternalList(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add((Object)ele);
        }
        return this;
    }

    public DBCluster withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public DBCluster withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.setBackupRetentionPeriod(backupRetentionPeriod);
        return this;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public DBCluster withCharacterSetName(String characterSetName) {
        this.setCharacterSetName(characterSetName);
        return this;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DBCluster withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public DBCluster withDBClusterIdentifier(String dBClusterIdentifier) {
        this.setDBClusterIdentifier(dBClusterIdentifier);
        return this;
    }

    public void setDBClusterParameterGroup(String dBClusterParameterGroup) {
        this.dBClusterParameterGroup = dBClusterParameterGroup;
    }

    public String getDBClusterParameterGroup() {
        return this.dBClusterParameterGroup;
    }

    public DBCluster withDBClusterParameterGroup(String dBClusterParameterGroup) {
        this.setDBClusterParameterGroup(dBClusterParameterGroup);
        return this;
    }

    public void setDBSubnetGroup(String dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
    }

    public String getDBSubnetGroup() {
        return this.dBSubnetGroup;
    }

    public DBCluster withDBSubnetGroup(String dBSubnetGroup) {
        this.setDBSubnetGroup(dBSubnetGroup);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DBCluster withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setPercentProgress(String percentProgress) {
        this.percentProgress = percentProgress;
    }

    public String getPercentProgress() {
        return this.percentProgress;
    }

    public DBCluster withPercentProgress(String percentProgress) {
        this.setPercentProgress(percentProgress);
        return this;
    }

    public void setEarliestRestorableTime(Date earliestRestorableTime) {
        this.earliestRestorableTime = earliestRestorableTime;
    }

    public Date getEarliestRestorableTime() {
        return this.earliestRestorableTime;
    }

    public DBCluster withEarliestRestorableTime(Date earliestRestorableTime) {
        this.setEarliestRestorableTime(earliestRestorableTime);
        return this;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public DBCluster withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setReaderEndpoint(String readerEndpoint) {
        this.readerEndpoint = readerEndpoint;
    }

    public String getReaderEndpoint() {
        return this.readerEndpoint;
    }

    public DBCluster withReaderEndpoint(String readerEndpoint) {
        this.setReaderEndpoint(readerEndpoint);
        return this;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public DBCluster withMultiAZ(Boolean multiAZ) {
        this.setMultiAZ(multiAZ);
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public DBCluster withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public DBCluster withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public Date getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public DBCluster withLatestRestorableTime(Date latestRestorableTime) {
        this.setLatestRestorableTime(latestRestorableTime);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public DBCluster withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public DBCluster withMasterUsername(String masterUsername) {
        this.setMasterUsername(masterUsername);
        return this;
    }

    public List<DBClusterOptionGroupStatus> getDBClusterOptionGroupMemberships() {
        if (this.dBClusterOptionGroupMemberships == null) {
            this.dBClusterOptionGroupMemberships = new SdkInternalList();
        }
        return this.dBClusterOptionGroupMemberships;
    }

    public void setDBClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships) {
        if (dBClusterOptionGroupMemberships == null) {
            this.dBClusterOptionGroupMemberships = null;
            return;
        }
        this.dBClusterOptionGroupMemberships = new SdkInternalList(dBClusterOptionGroupMemberships);
    }

    public DBCluster withDBClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... dBClusterOptionGroupMemberships) {
        if (this.dBClusterOptionGroupMemberships == null) {
            this.setDBClusterOptionGroupMemberships((Collection<DBClusterOptionGroupStatus>)new SdkInternalList(dBClusterOptionGroupMemberships.length));
        }
        for (DBClusterOptionGroupStatus ele : dBClusterOptionGroupMemberships) {
            this.dBClusterOptionGroupMemberships.add((Object)ele);
        }
        return this;
    }

    public DBCluster withDBClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships) {
        this.setDBClusterOptionGroupMemberships(dBClusterOptionGroupMemberships);
        return this;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public DBCluster withPreferredBackupWindow(String preferredBackupWindow) {
        this.setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public DBCluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
        this.replicationSourceIdentifier = replicationSourceIdentifier;
    }

    public String getReplicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public DBCluster withReplicationSourceIdentifier(String replicationSourceIdentifier) {
        this.setReplicationSourceIdentifier(replicationSourceIdentifier);
        return this;
    }

    public List<String> getReadReplicaIdentifiers() {
        if (this.readReplicaIdentifiers == null) {
            this.readReplicaIdentifiers = new SdkInternalList();
        }
        return this.readReplicaIdentifiers;
    }

    public void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
        if (readReplicaIdentifiers == null) {
            this.readReplicaIdentifiers = null;
            return;
        }
        this.readReplicaIdentifiers = new SdkInternalList(readReplicaIdentifiers);
    }

    public DBCluster withReadReplicaIdentifiers(String ... readReplicaIdentifiers) {
        if (this.readReplicaIdentifiers == null) {
            this.setReadReplicaIdentifiers((Collection<String>)new SdkInternalList(readReplicaIdentifiers.length));
        }
        for (String ele : readReplicaIdentifiers) {
            this.readReplicaIdentifiers.add((Object)ele);
        }
        return this;
    }

    public DBCluster withReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
        this.setReadReplicaIdentifiers(readReplicaIdentifiers);
        return this;
    }

    public List<DBClusterMember> getDBClusterMembers() {
        if (this.dBClusterMembers == null) {
            this.dBClusterMembers = new SdkInternalList();
        }
        return this.dBClusterMembers;
    }

    public void setDBClusterMembers(Collection<DBClusterMember> dBClusterMembers) {
        if (dBClusterMembers == null) {
            this.dBClusterMembers = null;
            return;
        }
        this.dBClusterMembers = new SdkInternalList(dBClusterMembers);
    }

    public DBCluster withDBClusterMembers(DBClusterMember ... dBClusterMembers) {
        if (this.dBClusterMembers == null) {
            this.setDBClusterMembers((Collection<DBClusterMember>)new SdkInternalList(dBClusterMembers.length));
        }
        for (DBClusterMember ele : dBClusterMembers) {
            this.dBClusterMembers.add((Object)ele);
        }
        return this;
    }

    public DBCluster withDBClusterMembers(Collection<DBClusterMember> dBClusterMembers) {
        this.setDBClusterMembers(dBClusterMembers);
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        if (this.vpcSecurityGroups == null) {
            this.vpcSecurityGroups = new SdkInternalList();
        }
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        this.vpcSecurityGroups = new SdkInternalList(vpcSecurityGroups);
    }

    public DBCluster withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.vpcSecurityGroups == null) {
            this.setVpcSecurityGroups((Collection<VpcSecurityGroupMembership>)new SdkInternalList(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership ele : vpcSecurityGroups) {
            this.vpcSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public DBCluster withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        this.setVpcSecurityGroups(vpcSecurityGroups);
        return this;
    }

    public void setHostedZoneId(String hostedZoneId) {
        this.hostedZoneId = hostedZoneId;
    }

    public String getHostedZoneId() {
        return this.hostedZoneId;
    }

    public DBCluster withHostedZoneId(String hostedZoneId) {
        this.setHostedZoneId(hostedZoneId);
        return this;
    }

    public void setStorageEncrypted(Boolean storageEncrypted) {
        this.storageEncrypted = storageEncrypted;
    }

    public Boolean getStorageEncrypted() {
        return this.storageEncrypted;
    }

    public DBCluster withStorageEncrypted(Boolean storageEncrypted) {
        this.setStorageEncrypted(storageEncrypted);
        return this;
    }

    public Boolean isStorageEncrypted() {
        return this.storageEncrypted;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public DBCluster withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setDbClusterResourceId(String dbClusterResourceId) {
        this.dbClusterResourceId = dbClusterResourceId;
    }

    public String getDbClusterResourceId() {
        return this.dbClusterResourceId;
    }

    public DBCluster withDbClusterResourceId(String dbClusterResourceId) {
        this.setDbClusterResourceId(dbClusterResourceId);
        return this;
    }

    public void setDBClusterArn(String dBClusterArn) {
        this.dBClusterArn = dBClusterArn;
    }

    public String getDBClusterArn() {
        return this.dBClusterArn;
    }

    public DBCluster withDBClusterArn(String dBClusterArn) {
        this.setDBClusterArn(dBClusterArn);
        return this;
    }

    public List<DBClusterRole> getAssociatedRoles() {
        if (this.associatedRoles == null) {
            this.associatedRoles = new SdkInternalList();
        }
        return this.associatedRoles;
    }

    public void setAssociatedRoles(Collection<DBClusterRole> associatedRoles) {
        if (associatedRoles == null) {
            this.associatedRoles = null;
            return;
        }
        this.associatedRoles = new SdkInternalList(associatedRoles);
    }

    public DBCluster withAssociatedRoles(DBClusterRole ... associatedRoles) {
        if (this.associatedRoles == null) {
            this.setAssociatedRoles((Collection<DBClusterRole>)new SdkInternalList(associatedRoles.length));
        }
        for (DBClusterRole ele : associatedRoles) {
            this.associatedRoles.add((Object)ele);
        }
        return this;
    }

    public DBCluster withAssociatedRoles(Collection<DBClusterRole> associatedRoles) {
        this.setAssociatedRoles(associatedRoles);
        return this;
    }

    public void setIAMDatabaseAuthenticationEnabled(Boolean iAMDatabaseAuthenticationEnabled) {
        this.iAMDatabaseAuthenticationEnabled = iAMDatabaseAuthenticationEnabled;
    }

    public Boolean getIAMDatabaseAuthenticationEnabled() {
        return this.iAMDatabaseAuthenticationEnabled;
    }

    public DBCluster withIAMDatabaseAuthenticationEnabled(Boolean iAMDatabaseAuthenticationEnabled) {
        this.setIAMDatabaseAuthenticationEnabled(iAMDatabaseAuthenticationEnabled);
        return this;
    }

    public Boolean isIAMDatabaseAuthenticationEnabled() {
        return this.iAMDatabaseAuthenticationEnabled;
    }

    public void setCloneGroupId(String cloneGroupId) {
        this.cloneGroupId = cloneGroupId;
    }

    public String getCloneGroupId() {
        return this.cloneGroupId;
    }

    public DBCluster withCloneGroupId(String cloneGroupId) {
        this.setCloneGroupId(cloneGroupId);
        return this;
    }

    public void setClusterCreateTime(Date clusterCreateTime) {
        this.clusterCreateTime = clusterCreateTime;
    }

    public Date getClusterCreateTime() {
        return this.clusterCreateTime;
    }

    public DBCluster withClusterCreateTime(Date clusterCreateTime) {
        this.setClusterCreateTime(clusterCreateTime);
        return this;
    }

    public void setEarliestBacktrackTime(Date earliestBacktrackTime) {
        this.earliestBacktrackTime = earliestBacktrackTime;
    }

    public Date getEarliestBacktrackTime() {
        return this.earliestBacktrackTime;
    }

    public DBCluster withEarliestBacktrackTime(Date earliestBacktrackTime) {
        this.setEarliestBacktrackTime(earliestBacktrackTime);
        return this;
    }

    public void setBacktrackWindow(Long backtrackWindow) {
        this.backtrackWindow = backtrackWindow;
    }

    public Long getBacktrackWindow() {
        return this.backtrackWindow;
    }

    public DBCluster withBacktrackWindow(Long backtrackWindow) {
        this.setBacktrackWindow(backtrackWindow);
        return this;
    }

    public void setBacktrackConsumedChangeRecords(Long backtrackConsumedChangeRecords) {
        this.backtrackConsumedChangeRecords = backtrackConsumedChangeRecords;
    }

    public Long getBacktrackConsumedChangeRecords() {
        return this.backtrackConsumedChangeRecords;
    }

    public DBCluster withBacktrackConsumedChangeRecords(Long backtrackConsumedChangeRecords) {
        this.setBacktrackConsumedChangeRecords(backtrackConsumedChangeRecords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.getAllocatedStorage()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getBackupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.getBackupRetentionPeriod()).append(",");
        }
        if (this.getCharacterSetName() != null) {
            sb.append("CharacterSetName: ").append(this.getCharacterSetName()).append(",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.getDBClusterIdentifier()).append(",");
        }
        if (this.getDBClusterParameterGroup() != null) {
            sb.append("DBClusterParameterGroup: ").append(this.getDBClusterParameterGroup()).append(",");
        }
        if (this.getDBSubnetGroup() != null) {
            sb.append("DBSubnetGroup: ").append(this.getDBSubnetGroup()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getPercentProgress() != null) {
            sb.append("PercentProgress: ").append(this.getPercentProgress()).append(",");
        }
        if (this.getEarliestRestorableTime() != null) {
            sb.append("EarliestRestorableTime: ").append(this.getEarliestRestorableTime()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getReaderEndpoint() != null) {
            sb.append("ReaderEndpoint: ").append(this.getReaderEndpoint()).append(",");
        }
        if (this.getMultiAZ() != null) {
            sb.append("MultiAZ: ").append(this.getMultiAZ()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getLatestRestorableTime() != null) {
            sb.append("LatestRestorableTime: ").append(this.getLatestRestorableTime()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: ").append(this.getMasterUsername()).append(",");
        }
        if (this.getDBClusterOptionGroupMemberships() != null) {
            sb.append("DBClusterOptionGroupMemberships: ").append(this.getDBClusterOptionGroupMemberships()).append(",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.getPreferredBackupWindow()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getReplicationSourceIdentifier() != null) {
            sb.append("ReplicationSourceIdentifier: ").append(this.getReplicationSourceIdentifier()).append(",");
        }
        if (this.getReadReplicaIdentifiers() != null) {
            sb.append("ReadReplicaIdentifiers: ").append(this.getReadReplicaIdentifiers()).append(",");
        }
        if (this.getDBClusterMembers() != null) {
            sb.append("DBClusterMembers: ").append(this.getDBClusterMembers()).append(",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.getVpcSecurityGroups()).append(",");
        }
        if (this.getHostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.getHostedZoneId()).append(",");
        }
        if (this.getStorageEncrypted() != null) {
            sb.append("StorageEncrypted: ").append(this.getStorageEncrypted()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getDbClusterResourceId() != null) {
            sb.append("DbClusterResourceId: ").append(this.getDbClusterResourceId()).append(",");
        }
        if (this.getDBClusterArn() != null) {
            sb.append("DBClusterArn: ").append(this.getDBClusterArn()).append(",");
        }
        if (this.getAssociatedRoles() != null) {
            sb.append("AssociatedRoles: ").append(this.getAssociatedRoles()).append(",");
        }
        if (this.getIAMDatabaseAuthenticationEnabled() != null) {
            sb.append("IAMDatabaseAuthenticationEnabled: ").append(this.getIAMDatabaseAuthenticationEnabled()).append(",");
        }
        if (this.getCloneGroupId() != null) {
            sb.append("CloneGroupId: ").append(this.getCloneGroupId()).append(",");
        }
        if (this.getClusterCreateTime() != null) {
            sb.append("ClusterCreateTime: ").append(this.getClusterCreateTime()).append(",");
        }
        if (this.getEarliestBacktrackTime() != null) {
            sb.append("EarliestBacktrackTime: ").append(this.getEarliestBacktrackTime()).append(",");
        }
        if (this.getBacktrackWindow() != null) {
            sb.append("BacktrackWindow: ").append(this.getBacktrackWindow()).append(",");
        }
        if (this.getBacktrackConsumedChangeRecords() != null) {
            sb.append("BacktrackConsumedChangeRecords: ").append(this.getBacktrackConsumedChangeRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster)obj;
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getCharacterSetName() == null ^ this.getCharacterSetName() == null) {
            return false;
        }
        if (other.getCharacterSetName() != null && !other.getCharacterSetName().equals(this.getCharacterSetName())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getDBClusterParameterGroup() == null ^ this.getDBClusterParameterGroup() == null) {
            return false;
        }
        if (other.getDBClusterParameterGroup() != null && !other.getDBClusterParameterGroup().equals(this.getDBClusterParameterGroup())) {
            return false;
        }
        if (other.getDBSubnetGroup() == null ^ this.getDBSubnetGroup() == null) {
            return false;
        }
        if (other.getDBSubnetGroup() != null && !other.getDBSubnetGroup().equals(this.getDBSubnetGroup())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPercentProgress() == null ^ this.getPercentProgress() == null) {
            return false;
        }
        if (other.getPercentProgress() != null && !other.getPercentProgress().equals(this.getPercentProgress())) {
            return false;
        }
        if (other.getEarliestRestorableTime() == null ^ this.getEarliestRestorableTime() == null) {
            return false;
        }
        if (other.getEarliestRestorableTime() != null && !other.getEarliestRestorableTime().equals(this.getEarliestRestorableTime())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getReaderEndpoint() == null ^ this.getReaderEndpoint() == null) {
            return false;
        }
        if (other.getReaderEndpoint() != null && !other.getReaderEndpoint().equals(this.getReaderEndpoint())) {
            return false;
        }
        if (other.getMultiAZ() == null ^ this.getMultiAZ() == null) {
            return false;
        }
        if (other.getMultiAZ() != null && !other.getMultiAZ().equals(this.getMultiAZ())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getLatestRestorableTime() == null ^ this.getLatestRestorableTime() == null) {
            return false;
        }
        if (other.getLatestRestorableTime() != null && !other.getLatestRestorableTime().equals(this.getLatestRestorableTime())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getDBClusterOptionGroupMemberships() == null ^ this.getDBClusterOptionGroupMemberships() == null) {
            return false;
        }
        if (other.getDBClusterOptionGroupMemberships() != null && !other.getDBClusterOptionGroupMemberships().equals(this.getDBClusterOptionGroupMemberships())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getReplicationSourceIdentifier() == null ^ this.getReplicationSourceIdentifier() == null) {
            return false;
        }
        if (other.getReplicationSourceIdentifier() != null && !other.getReplicationSourceIdentifier().equals(this.getReplicationSourceIdentifier())) {
            return false;
        }
        if (other.getReadReplicaIdentifiers() == null ^ this.getReadReplicaIdentifiers() == null) {
            return false;
        }
        if (other.getReadReplicaIdentifiers() != null && !other.getReadReplicaIdentifiers().equals(this.getReadReplicaIdentifiers())) {
            return false;
        }
        if (other.getDBClusterMembers() == null ^ this.getDBClusterMembers() == null) {
            return false;
        }
        if (other.getDBClusterMembers() != null && !other.getDBClusterMembers().equals(this.getDBClusterMembers())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getHostedZoneId() == null ^ this.getHostedZoneId() == null) {
            return false;
        }
        if (other.getHostedZoneId() != null && !other.getHostedZoneId().equals(this.getHostedZoneId())) {
            return false;
        }
        if (other.getStorageEncrypted() == null ^ this.getStorageEncrypted() == null) {
            return false;
        }
        if (other.getStorageEncrypted() != null && !other.getStorageEncrypted().equals(this.getStorageEncrypted())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getDbClusterResourceId() == null ^ this.getDbClusterResourceId() == null) {
            return false;
        }
        if (other.getDbClusterResourceId() != null && !other.getDbClusterResourceId().equals(this.getDbClusterResourceId())) {
            return false;
        }
        if (other.getDBClusterArn() == null ^ this.getDBClusterArn() == null) {
            return false;
        }
        if (other.getDBClusterArn() != null && !other.getDBClusterArn().equals(this.getDBClusterArn())) {
            return false;
        }
        if (other.getAssociatedRoles() == null ^ this.getAssociatedRoles() == null) {
            return false;
        }
        if (other.getAssociatedRoles() != null && !other.getAssociatedRoles().equals(this.getAssociatedRoles())) {
            return false;
        }
        if (other.getIAMDatabaseAuthenticationEnabled() == null ^ this.getIAMDatabaseAuthenticationEnabled() == null) {
            return false;
        }
        if (other.getIAMDatabaseAuthenticationEnabled() != null && !other.getIAMDatabaseAuthenticationEnabled().equals(this.getIAMDatabaseAuthenticationEnabled())) {
            return false;
        }
        if (other.getCloneGroupId() == null ^ this.getCloneGroupId() == null) {
            return false;
        }
        if (other.getCloneGroupId() != null && !other.getCloneGroupId().equals(this.getCloneGroupId())) {
            return false;
        }
        if (other.getClusterCreateTime() == null ^ this.getClusterCreateTime() == null) {
            return false;
        }
        if (other.getClusterCreateTime() != null && !other.getClusterCreateTime().equals(this.getClusterCreateTime())) {
            return false;
        }
        if (other.getEarliestBacktrackTime() == null ^ this.getEarliestBacktrackTime() == null) {
            return false;
        }
        if (other.getEarliestBacktrackTime() != null && !other.getEarliestBacktrackTime().equals(this.getEarliestBacktrackTime())) {
            return false;
        }
        if (other.getBacktrackWindow() == null ^ this.getBacktrackWindow() == null) {
            return false;
        }
        if (other.getBacktrackWindow() != null && !other.getBacktrackWindow().equals(this.getBacktrackWindow())) {
            return false;
        }
        if (other.getBacktrackConsumedChangeRecords() == null ^ this.getBacktrackConsumedChangeRecords() == null) {
            return false;
        }
        return other.getBacktrackConsumedChangeRecords() == null || other.getBacktrackConsumedChangeRecords().equals(this.getBacktrackConsumedChangeRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getCharacterSetName() == null ? 0 : this.getCharacterSetName().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterParameterGroup() == null ? 0 : this.getDBClusterParameterGroup().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroup() == null ? 0 : this.getDBSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPercentProgress() == null ? 0 : this.getPercentProgress().hashCode());
        hashCode = 31 * hashCode + (this.getEarliestRestorableTime() == null ? 0 : this.getEarliestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getReaderEndpoint() == null ? 0 : this.getReaderEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getMultiAZ() == null ? 0 : this.getMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLatestRestorableTime() == null ? 0 : this.getLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterOptionGroupMemberships() == null ? 0 : this.getDBClusterOptionGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationSourceIdentifier() == null ? 0 : this.getReplicationSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaIdentifiers() == null ? 0 : this.getReadReplicaIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterMembers() == null ? 0 : this.getDBClusterMembers().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getHostedZoneId() == null ? 0 : this.getHostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.getStorageEncrypted() == null ? 0 : this.getStorageEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getDbClusterResourceId() == null ? 0 : this.getDbClusterResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterArn() == null ? 0 : this.getDBClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedRoles() == null ? 0 : this.getAssociatedRoles().hashCode());
        hashCode = 31 * hashCode + (this.getIAMDatabaseAuthenticationEnabled() == null ? 0 : this.getIAMDatabaseAuthenticationEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getCloneGroupId() == null ? 0 : this.getCloneGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getClusterCreateTime() == null ? 0 : this.getClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getEarliestBacktrackTime() == null ? 0 : this.getEarliestBacktrackTime().hashCode());
        hashCode = 31 * hashCode + (this.getBacktrackWindow() == null ? 0 : this.getBacktrackWindow().hashCode());
        hashCode = 31 * hashCode + (this.getBacktrackConsumedChangeRecords() == null ? 0 : this.getBacktrackConsumedChangeRecords().hashCode());
        return hashCode;
    }

    public DBCluster clone() {
        try {
            return (DBCluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

