/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.RestoreDBClusterFromS3Request;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RestoreDBClusterFromS3RequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromS3Request>, RestoreDBClusterFromS3Request> {
    public Request<RestoreDBClusterFromS3Request> marshall(RestoreDBClusterFromS3Request restoreDBClusterFromS3Request) {
        if (restoreDBClusterFromS3Request == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterFromS3Request, "AmazonRDS");
        request.addParameter("Action", "RestoreDBClusterFromS3");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (!restoreDBClusterFromS3Request.getAvailabilityZones().isEmpty() || !((SdkInternalList)restoreDBClusterFromS3Request.getAvailabilityZones()).isAutoConstruct()) {
            SdkInternalList availabilityZonesList = (SdkInternalList)restoreDBClusterFromS3Request.getAvailabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (restoreDBClusterFromS3Request.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)restoreDBClusterFromS3Request.getBackupRetentionPeriod()));
        }
        if (restoreDBClusterFromS3Request.getCharacterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString((String)restoreDBClusterFromS3Request.getCharacterSetName()));
        }
        if (restoreDBClusterFromS3Request.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)restoreDBClusterFromS3Request.getDatabaseName()));
        }
        if (restoreDBClusterFromS3Request.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterFromS3Request.getDBClusterIdentifier()));
        }
        if (restoreDBClusterFromS3Request.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)restoreDBClusterFromS3Request.getDBClusterParameterGroupName()));
        }
        if (!restoreDBClusterFromS3Request.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)restoreDBClusterFromS3Request.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)restoreDBClusterFromS3Request.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreDBClusterFromS3Request.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterFromS3Request.getDBSubnetGroupName()));
        }
        if (restoreDBClusterFromS3Request.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBClusterFromS3Request.getEngine()));
        }
        if (restoreDBClusterFromS3Request.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBClusterFromS3Request.getEngineVersion()));
        }
        if (restoreDBClusterFromS3Request.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterFromS3Request.getPort()));
        }
        if (restoreDBClusterFromS3Request.getMasterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)restoreDBClusterFromS3Request.getMasterUsername()));
        }
        if (restoreDBClusterFromS3Request.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)restoreDBClusterFromS3Request.getMasterUserPassword()));
        }
        if (restoreDBClusterFromS3Request.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterFromS3Request.getOptionGroupName()));
        }
        if (restoreDBClusterFromS3Request.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)restoreDBClusterFromS3Request.getPreferredBackupWindow()));
        }
        if (restoreDBClusterFromS3Request.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)restoreDBClusterFromS3Request.getPreferredMaintenanceWindow()));
        }
        if (!restoreDBClusterFromS3Request.getTags().isEmpty() || !((SdkInternalList)restoreDBClusterFromS3Request.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)restoreDBClusterFromS3Request.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBClusterFromS3Request.getStorageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)restoreDBClusterFromS3Request.getStorageEncrypted()));
        }
        if (restoreDBClusterFromS3Request.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterFromS3Request.getKmsKeyId()));
        }
        if (restoreDBClusterFromS3Request.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterFromS3Request.getEnableIAMDatabaseAuthentication()));
        }
        if (restoreDBClusterFromS3Request.getSourceEngine() != null) {
            request.addParameter("SourceEngine", StringUtils.fromString((String)restoreDBClusterFromS3Request.getSourceEngine()));
        }
        if (restoreDBClusterFromS3Request.getSourceEngineVersion() != null) {
            request.addParameter("SourceEngineVersion", StringUtils.fromString((String)restoreDBClusterFromS3Request.getSourceEngineVersion()));
        }
        if (restoreDBClusterFromS3Request.getS3BucketName() != null) {
            request.addParameter("S3BucketName", StringUtils.fromString((String)restoreDBClusterFromS3Request.getS3BucketName()));
        }
        if (restoreDBClusterFromS3Request.getS3Prefix() != null) {
            request.addParameter("S3Prefix", StringUtils.fromString((String)restoreDBClusterFromS3Request.getS3Prefix()));
        }
        if (restoreDBClusterFromS3Request.getS3IngestionRoleArn() != null) {
            request.addParameter("S3IngestionRoleArn", StringUtils.fromString((String)restoreDBClusterFromS3Request.getS3IngestionRoleArn()));
        }
        if (restoreDBClusterFromS3Request.getBacktrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringUtils.fromLong((Long)restoreDBClusterFromS3Request.getBacktrackWindow()));
        }
        return request;
    }
}

