/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.rds.model.PromoteReadReplicaRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PromoteReadReplicaRequestMarshaller
implements Marshaller<Request<PromoteReadReplicaRequest>, PromoteReadReplicaRequest> {
    public Request<PromoteReadReplicaRequest> marshall(PromoteReadReplicaRequest promoteReadReplicaRequest) {
        if (promoteReadReplicaRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)promoteReadReplicaRequest, "AmazonRDS");
        request.addParameter("Action", "PromoteReadReplica");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (promoteReadReplicaRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)promoteReadReplicaRequest.getDBInstanceIdentifier()));
        }
        if (promoteReadReplicaRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)promoteReadReplicaRequest.getBackupRetentionPeriod()));
        }
        if (promoteReadReplicaRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)promoteReadReplicaRequest.getPreferredBackupWindow()));
        }
        return request;
    }
}

