/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBClusterEndpointsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBClusterEndpointsRequestMarshaller
implements Marshaller<Request<DescribeDBClusterEndpointsRequest>, DescribeDBClusterEndpointsRequest> {
    public Request<DescribeDBClusterEndpointsRequest> marshall(DescribeDBClusterEndpointsRequest describeDBClusterEndpointsRequest) {
        if (describeDBClusterEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBClusterEndpointsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBClusterEndpoints");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterEndpointsRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)describeDBClusterEndpointsRequest.getDBClusterIdentifier()));
        }
        if (describeDBClusterEndpointsRequest.getDBClusterEndpointIdentifier() != null) {
            request.addParameter("DBClusterEndpointIdentifier", StringUtils.fromString((String)describeDBClusterEndpointsRequest.getDBClusterEndpointIdentifier()));
        }
        if (!describeDBClusterEndpointsRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBClusterEndpointsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBClusterEndpointsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBClusterEndpointsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBClusterEndpointsRequest.getMaxRecords()));
        }
        if (describeDBClusterEndpointsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBClusterEndpointsRequest.getMarker()));
        }
        return request;
    }
}

