/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeInstallationMediaRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstallationMediaRequestMarshaller
implements Marshaller<Request<DescribeInstallationMediaRequest>, DescribeInstallationMediaRequest> {
    public Request<DescribeInstallationMediaRequest> marshall(DescribeInstallationMediaRequest describeInstallationMediaRequest) {
        if (describeInstallationMediaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstallationMediaRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeInstallationMedia");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstallationMediaRequest.getInstallationMediaId() != null) {
            request.addParameter("InstallationMediaId", StringUtils.fromString((String)describeInstallationMediaRequest.getInstallationMediaId()));
        }
        if (!describeInstallationMediaRequest.getFilters().isEmpty() || !((SdkInternalList)describeInstallationMediaRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeInstallationMediaRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeInstallationMediaRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeInstallationMediaRequest.getMaxRecords()));
        }
        if (describeInstallationMediaRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeInstallationMediaRequest.getMarker()));
        }
        return request;
    }
}

