/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CopyDBClusterSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceDBClusterSnapshotIdentifier;
    private String targetDBClusterSnapshotIdentifier;
    private SdkInternalList<Tag> tags;

    public void setSourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
        this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
    }

    public String getSourceDBClusterSnapshotIdentifier() {
        return this.sourceDBClusterSnapshotIdentifier;
    }

    public CopyDBClusterSnapshotRequest withSourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
        this.setSourceDBClusterSnapshotIdentifier(sourceDBClusterSnapshotIdentifier);
        return this;
    }

    public void setTargetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
        this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
    }

    public String getTargetDBClusterSnapshotIdentifier() {
        return this.targetDBClusterSnapshotIdentifier;
    }

    public CopyDBClusterSnapshotRequest withTargetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
        this.setTargetDBClusterSnapshotIdentifier(targetDBClusterSnapshotIdentifier);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CopyDBClusterSnapshotRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CopyDBClusterSnapshotRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceDBClusterSnapshotIdentifier() != null) {
            sb.append("SourceDBClusterSnapshotIdentifier: ").append(this.getSourceDBClusterSnapshotIdentifier()).append(",");
        }
        if (this.getTargetDBClusterSnapshotIdentifier() != null) {
            sb.append("TargetDBClusterSnapshotIdentifier: ").append(this.getTargetDBClusterSnapshotIdentifier()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBClusterSnapshotRequest)) {
            return false;
        }
        CopyDBClusterSnapshotRequest other = (CopyDBClusterSnapshotRequest)obj;
        if (other.getSourceDBClusterSnapshotIdentifier() == null ^ this.getSourceDBClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSourceDBClusterSnapshotIdentifier() != null && !other.getSourceDBClusterSnapshotIdentifier().equals(this.getSourceDBClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.getTargetDBClusterSnapshotIdentifier() == null ^ this.getTargetDBClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getTargetDBClusterSnapshotIdentifier() != null && !other.getTargetDBClusterSnapshotIdentifier().equals(this.getTargetDBClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceDBClusterSnapshotIdentifier() == null ? 0 : this.getSourceDBClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDBClusterSnapshotIdentifier() == null ? 0 : this.getTargetDBClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CopyDBClusterSnapshotRequest clone() {
        return (CopyDBClusterSnapshotRequest)super.clone();
    }
}

