/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ProcessorFeature;
import com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class RestoreDBInstanceToPointInTimeRequestMarshaller
implements Marshaller<Request<RestoreDBInstanceToPointInTimeRequest>, RestoreDBInstanceToPointInTimeRequest> {
    public Request<RestoreDBInstanceToPointInTimeRequest> marshall(RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest) {
        if (restoreDBInstanceToPointInTimeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBInstanceToPointInTimeRequest, "AmazonRDS");
        request.addParameter("Action", "RestoreDBInstanceToPointInTime");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBInstanceToPointInTimeRequest.getSourceDBInstanceIdentifier() != null) {
            request.addParameter("SourceDBInstanceIdentifier", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getSourceDBInstanceIdentifier()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getTargetDBInstanceIdentifier() != null) {
            request.addParameter("TargetDBInstanceIdentifier", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getTargetDBInstanceIdentifier()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getRestoreTime() != null) {
            request.addParameter("RestoreTime", StringUtils.fromDate((Date)restoreDBInstanceToPointInTimeRequest.getRestoreTime()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getUseLatestRestorableTime() != null) {
            request.addParameter("UseLatestRestorableTime", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.getUseLatestRestorableTime()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getDBInstanceClass()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBInstanceToPointInTimeRequest.getPort()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getAvailabilityZone()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getDBSubnetGroupName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getMultiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.getMultiAZ()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.getPubliclyAccessible()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.getAutoMinorVersionUpgrade()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getLicenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getLicenseModel()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getDBName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getDBName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getEngine()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)restoreDBInstanceToPointInTimeRequest.getIops()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getOptionGroupName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.getCopyTagsToSnapshot()));
        }
        if (!restoreDBInstanceToPointInTimeRequest.getTags().isEmpty() || !((SdkInternalList)restoreDBInstanceToPointInTimeRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)restoreDBInstanceToPointInTimeRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBInstanceToPointInTimeRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getStorageType()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getTdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getTdeCredentialArn()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getTdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getTdeCredentialPassword()));
        }
        if (!restoreDBInstanceToPointInTimeRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)restoreDBInstanceToPointInTimeRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)restoreDBInstanceToPointInTimeRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreDBInstanceToPointInTimeRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getDomain()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getDomainIAMRoleName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (!restoreDBInstanceToPointInTimeRequest.getEnableCloudwatchLogsExports().isEmpty() || !((SdkInternalList)restoreDBInstanceToPointInTimeRequest.getEnableCloudwatchLogsExports()).isAutoConstruct()) {
            SdkInternalList enableCloudwatchLogsExportsList = (SdkInternalList)restoreDBInstanceToPointInTimeRequest.getEnableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (!restoreDBInstanceToPointInTimeRequest.getProcessorFeatures().isEmpty() || !((SdkInternalList)restoreDBInstanceToPointInTimeRequest.getProcessorFeatures()).isAutoConstruct()) {
            SdkInternalList processorFeaturesList = (SdkInternalList)restoreDBInstanceToPointInTimeRequest.getProcessorFeatures();
            int processorFeaturesListIndex = 1;
            for (ProcessorFeature processorFeaturesListValue : processorFeaturesList) {
                if (processorFeaturesListValue.getName() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Name", StringUtils.fromString((String)processorFeaturesListValue.getName()));
                }
                if (processorFeaturesListValue.getValue() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Value", StringUtils.fromString((String)processorFeaturesListValue.getValue()));
                }
                ++processorFeaturesListIndex;
            }
        }
        if (restoreDBInstanceToPointInTimeRequest.getUseDefaultProcessorFeatures() != null) {
            request.addParameter("UseDefaultProcessorFeatures", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.getUseDefaultProcessorFeatures()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getDBParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getDBParameterGroupName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.getDeletionProtection()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getSourceDbiResourceId() != null) {
            request.addParameter("SourceDbiResourceId", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getSourceDbiResourceId()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getMaxAllocatedStorage() != null) {
            request.addParameter("MaxAllocatedStorage", StringUtils.fromInteger((Integer)restoreDBInstanceToPointInTimeRequest.getMaxAllocatedStorage()));
        }
        if (restoreDBInstanceToPointInTimeRequest.getSourceDBInstanceAutomatedBackupsArn() != null) {
            request.addParameter("SourceDBInstanceAutomatedBackupsArn", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.getSourceDBInstanceAutomatedBackupsArn()));
        }
        return request;
    }
}

