/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest;
import com.amazonaws.services.rds.model.ProcessorFeature;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDBInstanceReadReplicaRequestMarshaller
implements Marshaller<Request<CreateDBInstanceReadReplicaRequest>, CreateDBInstanceReadReplicaRequest> {
    public Request<CreateDBInstanceReadReplicaRequest> marshall(CreateDBInstanceReadReplicaRequest createDBInstanceReadReplicaRequest) {
        if (createDBInstanceReadReplicaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBInstanceReadReplicaRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBInstanceReadReplica");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBInstanceReadReplicaRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getDBInstanceIdentifier()));
        }
        if (createDBInstanceReadReplicaRequest.getSourceDBInstanceIdentifier() != null) {
            request.addParameter("SourceDBInstanceIdentifier", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getSourceDBInstanceIdentifier()));
        }
        if (createDBInstanceReadReplicaRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getDBInstanceClass()));
        }
        if (createDBInstanceReadReplicaRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getAvailabilityZone()));
        }
        if (createDBInstanceReadReplicaRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.getPort()));
        }
        if (createDBInstanceReadReplicaRequest.getMultiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getMultiAZ()));
        }
        if (createDBInstanceReadReplicaRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getAutoMinorVersionUpgrade()));
        }
        if (createDBInstanceReadReplicaRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.getIops()));
        }
        if (createDBInstanceReadReplicaRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getOptionGroupName()));
        }
        if (createDBInstanceReadReplicaRequest.getDBParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getDBParameterGroupName()));
        }
        if (createDBInstanceReadReplicaRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getPubliclyAccessible()));
        }
        if (!createDBInstanceReadReplicaRequest.getTags().isEmpty() || !((SdkInternalList)createDBInstanceReadReplicaRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBInstanceReadReplicaRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (createDBInstanceReadReplicaRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getDBSubnetGroupName()));
        }
        if (!createDBInstanceReadReplicaRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)createDBInstanceReadReplicaRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)createDBInstanceReadReplicaRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBInstanceReadReplicaRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getStorageType()));
        }
        if (createDBInstanceReadReplicaRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getCopyTagsToSnapshot()));
        }
        if (createDBInstanceReadReplicaRequest.getMonitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.getMonitoringInterval()));
        }
        if (createDBInstanceReadReplicaRequest.getMonitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getMonitoringRoleArn()));
        }
        if (createDBInstanceReadReplicaRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getKmsKeyId()));
        }
        if (createDBInstanceReadReplicaRequest.getPreSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getPreSignedUrl()));
        }
        if (createDBInstanceReadReplicaRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (createDBInstanceReadReplicaRequest.getEnablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getEnablePerformanceInsights()));
        }
        if (createDBInstanceReadReplicaRequest.getPerformanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getPerformanceInsightsKMSKeyId()));
        }
        if (createDBInstanceReadReplicaRequest.getPerformanceInsightsRetentionPeriod() != null) {
            request.addParameter("PerformanceInsightsRetentionPeriod", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.getPerformanceInsightsRetentionPeriod()));
        }
        if (!createDBInstanceReadReplicaRequest.getEnableCloudwatchLogsExports().isEmpty() || !((SdkInternalList)createDBInstanceReadReplicaRequest.getEnableCloudwatchLogsExports()).isAutoConstruct()) {
            SdkInternalList enableCloudwatchLogsExportsList = (SdkInternalList)createDBInstanceReadReplicaRequest.getEnableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (!createDBInstanceReadReplicaRequest.getProcessorFeatures().isEmpty() || !((SdkInternalList)createDBInstanceReadReplicaRequest.getProcessorFeatures()).isAutoConstruct()) {
            SdkInternalList processorFeaturesList = (SdkInternalList)createDBInstanceReadReplicaRequest.getProcessorFeatures();
            int processorFeaturesListIndex = 1;
            for (ProcessorFeature processorFeaturesListValue : processorFeaturesList) {
                if (processorFeaturesListValue != null) {
                    if (processorFeaturesListValue.getName() != null) {
                        request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Name", StringUtils.fromString((String)processorFeaturesListValue.getName()));
                    }
                    if (processorFeaturesListValue.getValue() != null) {
                        request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Value", StringUtils.fromString((String)processorFeaturesListValue.getValue()));
                    }
                }
                ++processorFeaturesListIndex;
            }
        }
        if (createDBInstanceReadReplicaRequest.getUseDefaultProcessorFeatures() != null) {
            request.addParameter("UseDefaultProcessorFeatures", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getUseDefaultProcessorFeatures()));
        }
        if (createDBInstanceReadReplicaRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getDeletionProtection()));
        }
        if (createDBInstanceReadReplicaRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getDomain()));
        }
        if (createDBInstanceReadReplicaRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getDomainIAMRoleName()));
        }
        if (createDBInstanceReadReplicaRequest.getReplicaMode() != null) {
            request.addParameter("ReplicaMode", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getReplicaMode()));
        }
        if (createDBInstanceReadReplicaRequest.getMaxAllocatedStorage() != null) {
            request.addParameter("MaxAllocatedStorage", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.getMaxAllocatedStorage()));
        }
        if (createDBInstanceReadReplicaRequest.getCustomIamInstanceProfile() != null) {
            request.addParameter("CustomIamInstanceProfile", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getCustomIamInstanceProfile()));
        }
        if (createDBInstanceReadReplicaRequest.getNetworkType() != null) {
            request.addParameter("NetworkType", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getNetworkType()));
        }
        if (createDBInstanceReadReplicaRequest.getStorageThroughput() != null) {
            request.addParameter("StorageThroughput", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.getStorageThroughput()));
        }
        if (createDBInstanceReadReplicaRequest.getEnableCustomerOwnedIp() != null) {
            request.addParameter("EnableCustomerOwnedIp", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.getEnableCustomerOwnedIp()));
        }
        if (createDBInstanceReadReplicaRequest.getAllocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.getAllocatedStorage()));
        }
        if (createDBInstanceReadReplicaRequest.getSourceDBClusterIdentifier() != null) {
            request.addParameter("SourceDBClusterIdentifier", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getSourceDBClusterIdentifier()));
        }
        if (createDBInstanceReadReplicaRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.getSourceRegion()));
        }
        return request;
    }
}

