/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CloudwatchLogsExportConfiguration;
import com.amazonaws.services.rds.model.ScalingConfiguration;
import com.amazonaws.services.rds.model.ServerlessV2ScalingConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyDBClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBClusterIdentifier;
    private String newDBClusterIdentifier;
    private Boolean applyImmediately;
    private Integer backupRetentionPeriod;
    private String dBClusterParameterGroupName;
    private SdkInternalList<String> vpcSecurityGroupIds;
    private Integer port;
    private String masterUserPassword;
    private String optionGroupName;
    private String preferredBackupWindow;
    private String preferredMaintenanceWindow;
    private Boolean enableIAMDatabaseAuthentication;
    private Long backtrackWindow;
    private CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
    private String engineVersion;
    private Boolean allowMajorVersionUpgrade;
    private String dBInstanceParameterGroupName;
    private String domain;
    private String domainIAMRoleName;
    private ScalingConfiguration scalingConfiguration;
    private Boolean deletionProtection;
    private Boolean enableHttpEndpoint;
    private Boolean copyTagsToSnapshot;
    private Boolean enableGlobalWriteForwarding;
    private String dBClusterInstanceClass;
    private Integer allocatedStorage;
    private String storageType;
    private Integer iops;
    private Boolean autoMinorVersionUpgrade;
    private Integer monitoringInterval;
    private String monitoringRoleArn;
    private Boolean enablePerformanceInsights;
    private String performanceInsightsKMSKeyId;
    private Integer performanceInsightsRetentionPeriod;
    private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
    private String networkType;
    private Boolean manageMasterUserPassword;
    private Boolean rotateMasterUserPassword;
    private String masterUserSecretKmsKeyId;
    private String engineMode;
    private Boolean allowEngineModeChange;
    private Boolean enableLocalWriteForwarding;

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public ModifyDBClusterRequest withDBClusterIdentifier(String dBClusterIdentifier) {
        this.setDBClusterIdentifier(dBClusterIdentifier);
        return this;
    }

    public void setNewDBClusterIdentifier(String newDBClusterIdentifier) {
        this.newDBClusterIdentifier = newDBClusterIdentifier;
    }

    public String getNewDBClusterIdentifier() {
        return this.newDBClusterIdentifier;
    }

    public ModifyDBClusterRequest withNewDBClusterIdentifier(String newDBClusterIdentifier) {
        this.setNewDBClusterIdentifier(newDBClusterIdentifier);
        return this;
    }

    public void setApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }

    public Boolean getApplyImmediately() {
        return this.applyImmediately;
    }

    public ModifyDBClusterRequest withApplyImmediately(Boolean applyImmediately) {
        this.setApplyImmediately(applyImmediately);
        return this;
    }

    public Boolean isApplyImmediately() {
        return this.applyImmediately;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public ModifyDBClusterRequest withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.setBackupRetentionPeriod(backupRetentionPeriod);
        return this;
    }

    public void setDBClusterParameterGroupName(String dBClusterParameterGroupName) {
        this.dBClusterParameterGroupName = dBClusterParameterGroupName;
    }

    public String getDBClusterParameterGroupName() {
        return this.dBClusterParameterGroupName;
    }

    public ModifyDBClusterRequest withDBClusterParameterGroupName(String dBClusterParameterGroupName) {
        this.setDBClusterParameterGroupName(dBClusterParameterGroupName);
        return this;
    }

    public List<String> getVpcSecurityGroupIds() {
        if (this.vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = new SdkInternalList();
        }
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
            return;
        }
        this.vpcSecurityGroupIds = new SdkInternalList(vpcSecurityGroupIds);
    }

    public ModifyDBClusterRequest withVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
        if (this.vpcSecurityGroupIds == null) {
            this.setVpcSecurityGroupIds((Collection<String>)new SdkInternalList(vpcSecurityGroupIds.length));
        }
        for (String ele : vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds.add((Object)ele);
        }
        return this;
    }

    public ModifyDBClusterRequest withVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        this.setVpcSecurityGroupIds(vpcSecurityGroupIds);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public ModifyDBClusterRequest withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    public ModifyDBClusterRequest withMasterUserPassword(String masterUserPassword) {
        this.setMasterUserPassword(masterUserPassword);
        return this;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public ModifyDBClusterRequest withOptionGroupName(String optionGroupName) {
        this.setOptionGroupName(optionGroupName);
        return this;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public ModifyDBClusterRequest withPreferredBackupWindow(String preferredBackupWindow) {
        this.setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public ModifyDBClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
        this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
    }

    public Boolean getEnableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public ModifyDBClusterRequest withEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
        this.setEnableIAMDatabaseAuthentication(enableIAMDatabaseAuthentication);
        return this;
    }

    public Boolean isEnableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public void setBacktrackWindow(Long backtrackWindow) {
        this.backtrackWindow = backtrackWindow;
    }

    public Long getBacktrackWindow() {
        return this.backtrackWindow;
    }

    public ModifyDBClusterRequest withBacktrackWindow(Long backtrackWindow) {
        this.setBacktrackWindow(backtrackWindow);
        return this;
    }

    public void setCloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration) {
        this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration;
    }

    public CloudwatchLogsExportConfiguration getCloudwatchLogsExportConfiguration() {
        return this.cloudwatchLogsExportConfiguration;
    }

    public ModifyDBClusterRequest withCloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration) {
        this.setCloudwatchLogsExportConfiguration(cloudwatchLogsExportConfiguration);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public ModifyDBClusterRequest withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
        this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
    }

    public Boolean getAllowMajorVersionUpgrade() {
        return this.allowMajorVersionUpgrade;
    }

    public ModifyDBClusterRequest withAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
        this.setAllowMajorVersionUpgrade(allowMajorVersionUpgrade);
        return this;
    }

    public Boolean isAllowMajorVersionUpgrade() {
        return this.allowMajorVersionUpgrade;
    }

    public void setDBInstanceParameterGroupName(String dBInstanceParameterGroupName) {
        this.dBInstanceParameterGroupName = dBInstanceParameterGroupName;
    }

    public String getDBInstanceParameterGroupName() {
        return this.dBInstanceParameterGroupName;
    }

    public ModifyDBClusterRequest withDBInstanceParameterGroupName(String dBInstanceParameterGroupName) {
        this.setDBInstanceParameterGroupName(dBInstanceParameterGroupName);
        return this;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public ModifyDBClusterRequest withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public void setDomainIAMRoleName(String domainIAMRoleName) {
        this.domainIAMRoleName = domainIAMRoleName;
    }

    public String getDomainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public ModifyDBClusterRequest withDomainIAMRoleName(String domainIAMRoleName) {
        this.setDomainIAMRoleName(domainIAMRoleName);
        return this;
    }

    public void setScalingConfiguration(ScalingConfiguration scalingConfiguration) {
        this.scalingConfiguration = scalingConfiguration;
    }

    public ScalingConfiguration getScalingConfiguration() {
        return this.scalingConfiguration;
    }

    public ModifyDBClusterRequest withScalingConfiguration(ScalingConfiguration scalingConfiguration) {
        this.setScalingConfiguration(scalingConfiguration);
        return this;
    }

    public void setDeletionProtection(Boolean deletionProtection) {
        this.deletionProtection = deletionProtection;
    }

    public Boolean getDeletionProtection() {
        return this.deletionProtection;
    }

    public ModifyDBClusterRequest withDeletionProtection(Boolean deletionProtection) {
        this.setDeletionProtection(deletionProtection);
        return this;
    }

    public Boolean isDeletionProtection() {
        return this.deletionProtection;
    }

    public void setEnableHttpEndpoint(Boolean enableHttpEndpoint) {
        this.enableHttpEndpoint = enableHttpEndpoint;
    }

    public Boolean getEnableHttpEndpoint() {
        return this.enableHttpEndpoint;
    }

    public ModifyDBClusterRequest withEnableHttpEndpoint(Boolean enableHttpEndpoint) {
        this.setEnableHttpEndpoint(enableHttpEndpoint);
        return this;
    }

    public Boolean isEnableHttpEndpoint() {
        return this.enableHttpEndpoint;
    }

    public void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
    }

    public Boolean getCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public ModifyDBClusterRequest withCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.setCopyTagsToSnapshot(copyTagsToSnapshot);
        return this;
    }

    public Boolean isCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public void setEnableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
        this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
    }

    public Boolean getEnableGlobalWriteForwarding() {
        return this.enableGlobalWriteForwarding;
    }

    public ModifyDBClusterRequest withEnableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
        this.setEnableGlobalWriteForwarding(enableGlobalWriteForwarding);
        return this;
    }

    public Boolean isEnableGlobalWriteForwarding() {
        return this.enableGlobalWriteForwarding;
    }

    public void setDBClusterInstanceClass(String dBClusterInstanceClass) {
        this.dBClusterInstanceClass = dBClusterInstanceClass;
    }

    public String getDBClusterInstanceClass() {
        return this.dBClusterInstanceClass;
    }

    public ModifyDBClusterRequest withDBClusterInstanceClass(String dBClusterInstanceClass) {
        this.setDBClusterInstanceClass(dBClusterInstanceClass);
        return this;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public ModifyDBClusterRequest withAllocatedStorage(Integer allocatedStorage) {
        this.setAllocatedStorage(allocatedStorage);
        return this;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public ModifyDBClusterRequest withStorageType(String storageType) {
        this.setStorageType(storageType);
        return this;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public Integer getIops() {
        return this.iops;
    }

    public ModifyDBClusterRequest withIops(Integer iops) {
        this.setIops(iops);
        return this;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public ModifyDBClusterRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setMonitoringInterval(Integer monitoringInterval) {
        this.monitoringInterval = monitoringInterval;
    }

    public Integer getMonitoringInterval() {
        return this.monitoringInterval;
    }

    public ModifyDBClusterRequest withMonitoringInterval(Integer monitoringInterval) {
        this.setMonitoringInterval(monitoringInterval);
        return this;
    }

    public void setMonitoringRoleArn(String monitoringRoleArn) {
        this.monitoringRoleArn = monitoringRoleArn;
    }

    public String getMonitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public ModifyDBClusterRequest withMonitoringRoleArn(String monitoringRoleArn) {
        this.setMonitoringRoleArn(monitoringRoleArn);
        return this;
    }

    public void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
        this.enablePerformanceInsights = enablePerformanceInsights;
    }

    public Boolean getEnablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public ModifyDBClusterRequest withEnablePerformanceInsights(Boolean enablePerformanceInsights) {
        this.setEnablePerformanceInsights(enablePerformanceInsights);
        return this;
    }

    public Boolean isEnablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
        this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
    }

    public String getPerformanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public ModifyDBClusterRequest withPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
        this.setPerformanceInsightsKMSKeyId(performanceInsightsKMSKeyId);
        return this;
    }

    public void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
        this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
    }

    public Integer getPerformanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public ModifyDBClusterRequest withPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
        this.setPerformanceInsightsRetentionPeriod(performanceInsightsRetentionPeriod);
        return this;
    }

    public void setServerlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
        this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
    }

    public ServerlessV2ScalingConfiguration getServerlessV2ScalingConfiguration() {
        return this.serverlessV2ScalingConfiguration;
    }

    public ModifyDBClusterRequest withServerlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
        this.setServerlessV2ScalingConfiguration(serverlessV2ScalingConfiguration);
        return this;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public ModifyDBClusterRequest withNetworkType(String networkType) {
        this.setNetworkType(networkType);
        return this;
    }

    public void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
        this.manageMasterUserPassword = manageMasterUserPassword;
    }

    public Boolean getManageMasterUserPassword() {
        return this.manageMasterUserPassword;
    }

    public ModifyDBClusterRequest withManageMasterUserPassword(Boolean manageMasterUserPassword) {
        this.setManageMasterUserPassword(manageMasterUserPassword);
        return this;
    }

    public Boolean isManageMasterUserPassword() {
        return this.manageMasterUserPassword;
    }

    public void setRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
        this.rotateMasterUserPassword = rotateMasterUserPassword;
    }

    public Boolean getRotateMasterUserPassword() {
        return this.rotateMasterUserPassword;
    }

    public ModifyDBClusterRequest withRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
        this.setRotateMasterUserPassword(rotateMasterUserPassword);
        return this;
    }

    public Boolean isRotateMasterUserPassword() {
        return this.rotateMasterUserPassword;
    }

    public void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
        this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
    }

    public String getMasterUserSecretKmsKeyId() {
        return this.masterUserSecretKmsKeyId;
    }

    public ModifyDBClusterRequest withMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
        this.setMasterUserSecretKmsKeyId(masterUserSecretKmsKeyId);
        return this;
    }

    public void setEngineMode(String engineMode) {
        this.engineMode = engineMode;
    }

    public String getEngineMode() {
        return this.engineMode;
    }

    public ModifyDBClusterRequest withEngineMode(String engineMode) {
        this.setEngineMode(engineMode);
        return this;
    }

    public void setAllowEngineModeChange(Boolean allowEngineModeChange) {
        this.allowEngineModeChange = allowEngineModeChange;
    }

    public Boolean getAllowEngineModeChange() {
        return this.allowEngineModeChange;
    }

    public ModifyDBClusterRequest withAllowEngineModeChange(Boolean allowEngineModeChange) {
        this.setAllowEngineModeChange(allowEngineModeChange);
        return this;
    }

    public Boolean isAllowEngineModeChange() {
        return this.allowEngineModeChange;
    }

    public void setEnableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
        this.enableLocalWriteForwarding = enableLocalWriteForwarding;
    }

    public Boolean getEnableLocalWriteForwarding() {
        return this.enableLocalWriteForwarding;
    }

    public ModifyDBClusterRequest withEnableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
        this.setEnableLocalWriteForwarding(enableLocalWriteForwarding);
        return this;
    }

    public Boolean isEnableLocalWriteForwarding() {
        return this.enableLocalWriteForwarding;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.getDBClusterIdentifier()).append(",");
        }
        if (this.getNewDBClusterIdentifier() != null) {
            sb.append("NewDBClusterIdentifier: ").append(this.getNewDBClusterIdentifier()).append(",");
        }
        if (this.getApplyImmediately() != null) {
            sb.append("ApplyImmediately: ").append(this.getApplyImmediately()).append(",");
        }
        if (this.getBackupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.getBackupRetentionPeriod()).append(",");
        }
        if (this.getDBClusterParameterGroupName() != null) {
            sb.append("DBClusterParameterGroupName: ").append(this.getDBClusterParameterGroupName()).append(",");
        }
        if (this.getVpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.getVpcSecurityGroupIds()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getMasterUserPassword() != null) {
            sb.append("MasterUserPassword: ").append(this.getMasterUserPassword()).append(",");
        }
        if (this.getOptionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.getOptionGroupName()).append(",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.getPreferredBackupWindow()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getEnableIAMDatabaseAuthentication() != null) {
            sb.append("EnableIAMDatabaseAuthentication: ").append(this.getEnableIAMDatabaseAuthentication()).append(",");
        }
        if (this.getBacktrackWindow() != null) {
            sb.append("BacktrackWindow: ").append(this.getBacktrackWindow()).append(",");
        }
        if (this.getCloudwatchLogsExportConfiguration() != null) {
            sb.append("CloudwatchLogsExportConfiguration: ").append(this.getCloudwatchLogsExportConfiguration()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getAllowMajorVersionUpgrade() != null) {
            sb.append("AllowMajorVersionUpgrade: ").append(this.getAllowMajorVersionUpgrade()).append(",");
        }
        if (this.getDBInstanceParameterGroupName() != null) {
            sb.append("DBInstanceParameterGroupName: ").append(this.getDBInstanceParameterGroupName()).append(",");
        }
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getDomainIAMRoleName() != null) {
            sb.append("DomainIAMRoleName: ").append(this.getDomainIAMRoleName()).append(",");
        }
        if (this.getScalingConfiguration() != null) {
            sb.append("ScalingConfiguration: ").append(this.getScalingConfiguration()).append(",");
        }
        if (this.getDeletionProtection() != null) {
            sb.append("DeletionProtection: ").append(this.getDeletionProtection()).append(",");
        }
        if (this.getEnableHttpEndpoint() != null) {
            sb.append("EnableHttpEndpoint: ").append(this.getEnableHttpEndpoint()).append(",");
        }
        if (this.getCopyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: ").append(this.getCopyTagsToSnapshot()).append(",");
        }
        if (this.getEnableGlobalWriteForwarding() != null) {
            sb.append("EnableGlobalWriteForwarding: ").append(this.getEnableGlobalWriteForwarding()).append(",");
        }
        if (this.getDBClusterInstanceClass() != null) {
            sb.append("DBClusterInstanceClass: ").append(this.getDBClusterInstanceClass()).append(",");
        }
        if (this.getAllocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.getAllocatedStorage()).append(",");
        }
        if (this.getStorageType() != null) {
            sb.append("StorageType: ").append(this.getStorageType()).append(",");
        }
        if (this.getIops() != null) {
            sb.append("Iops: ").append(this.getIops()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade()).append(",");
        }
        if (this.getMonitoringInterval() != null) {
            sb.append("MonitoringInterval: ").append(this.getMonitoringInterval()).append(",");
        }
        if (this.getMonitoringRoleArn() != null) {
            sb.append("MonitoringRoleArn: ").append(this.getMonitoringRoleArn()).append(",");
        }
        if (this.getEnablePerformanceInsights() != null) {
            sb.append("EnablePerformanceInsights: ").append(this.getEnablePerformanceInsights()).append(",");
        }
        if (this.getPerformanceInsightsKMSKeyId() != null) {
            sb.append("PerformanceInsightsKMSKeyId: ").append(this.getPerformanceInsightsKMSKeyId()).append(",");
        }
        if (this.getPerformanceInsightsRetentionPeriod() != null) {
            sb.append("PerformanceInsightsRetentionPeriod: ").append(this.getPerformanceInsightsRetentionPeriod()).append(",");
        }
        if (this.getServerlessV2ScalingConfiguration() != null) {
            sb.append("ServerlessV2ScalingConfiguration: ").append(this.getServerlessV2ScalingConfiguration()).append(",");
        }
        if (this.getNetworkType() != null) {
            sb.append("NetworkType: ").append(this.getNetworkType()).append(",");
        }
        if (this.getManageMasterUserPassword() != null) {
            sb.append("ManageMasterUserPassword: ").append(this.getManageMasterUserPassword()).append(",");
        }
        if (this.getRotateMasterUserPassword() != null) {
            sb.append("RotateMasterUserPassword: ").append(this.getRotateMasterUserPassword()).append(",");
        }
        if (this.getMasterUserSecretKmsKeyId() != null) {
            sb.append("MasterUserSecretKmsKeyId: ").append(this.getMasterUserSecretKmsKeyId()).append(",");
        }
        if (this.getEngineMode() != null) {
            sb.append("EngineMode: ").append(this.getEngineMode()).append(",");
        }
        if (this.getAllowEngineModeChange() != null) {
            sb.append("AllowEngineModeChange: ").append(this.getAllowEngineModeChange()).append(",");
        }
        if (this.getEnableLocalWriteForwarding() != null) {
            sb.append("EnableLocalWriteForwarding: ").append(this.getEnableLocalWriteForwarding());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBClusterRequest)) {
            return false;
        }
        ModifyDBClusterRequest other = (ModifyDBClusterRequest)obj;
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getNewDBClusterIdentifier() == null ^ this.getNewDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getNewDBClusterIdentifier() != null && !other.getNewDBClusterIdentifier().equals(this.getNewDBClusterIdentifier())) {
            return false;
        }
        if (other.getApplyImmediately() == null ^ this.getApplyImmediately() == null) {
            return false;
        }
        if (other.getApplyImmediately() != null && !other.getApplyImmediately().equals(this.getApplyImmediately())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getDBClusterParameterGroupName() == null ^ this.getDBClusterParameterGroupName() == null) {
            return false;
        }
        if (other.getDBClusterParameterGroupName() != null && !other.getDBClusterParameterGroupName().equals(this.getDBClusterParameterGroupName())) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() == null ^ this.getVpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() != null && !other.getVpcSecurityGroupIds().equals(this.getVpcSecurityGroupIds())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getMasterUserPassword() == null ^ this.getMasterUserPassword() == null) {
            return false;
        }
        if (other.getMasterUserPassword() != null && !other.getMasterUserPassword().equals(this.getMasterUserPassword())) {
            return false;
        }
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getEnableIAMDatabaseAuthentication() == null ^ this.getEnableIAMDatabaseAuthentication() == null) {
            return false;
        }
        if (other.getEnableIAMDatabaseAuthentication() != null && !other.getEnableIAMDatabaseAuthentication().equals(this.getEnableIAMDatabaseAuthentication())) {
            return false;
        }
        if (other.getBacktrackWindow() == null ^ this.getBacktrackWindow() == null) {
            return false;
        }
        if (other.getBacktrackWindow() != null && !other.getBacktrackWindow().equals(this.getBacktrackWindow())) {
            return false;
        }
        if (other.getCloudwatchLogsExportConfiguration() == null ^ this.getCloudwatchLogsExportConfiguration() == null) {
            return false;
        }
        if (other.getCloudwatchLogsExportConfiguration() != null && !other.getCloudwatchLogsExportConfiguration().equals(this.getCloudwatchLogsExportConfiguration())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getAllowMajorVersionUpgrade() == null ^ this.getAllowMajorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAllowMajorVersionUpgrade() != null && !other.getAllowMajorVersionUpgrade().equals(this.getAllowMajorVersionUpgrade())) {
            return false;
        }
        if (other.getDBInstanceParameterGroupName() == null ^ this.getDBInstanceParameterGroupName() == null) {
            return false;
        }
        if (other.getDBInstanceParameterGroupName() != null && !other.getDBInstanceParameterGroupName().equals(this.getDBInstanceParameterGroupName())) {
            return false;
        }
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getDomainIAMRoleName() == null ^ this.getDomainIAMRoleName() == null) {
            return false;
        }
        if (other.getDomainIAMRoleName() != null && !other.getDomainIAMRoleName().equals(this.getDomainIAMRoleName())) {
            return false;
        }
        if (other.getScalingConfiguration() == null ^ this.getScalingConfiguration() == null) {
            return false;
        }
        if (other.getScalingConfiguration() != null && !other.getScalingConfiguration().equals(this.getScalingConfiguration())) {
            return false;
        }
        if (other.getDeletionProtection() == null ^ this.getDeletionProtection() == null) {
            return false;
        }
        if (other.getDeletionProtection() != null && !other.getDeletionProtection().equals(this.getDeletionProtection())) {
            return false;
        }
        if (other.getEnableHttpEndpoint() == null ^ this.getEnableHttpEndpoint() == null) {
            return false;
        }
        if (other.getEnableHttpEndpoint() != null && !other.getEnableHttpEndpoint().equals(this.getEnableHttpEndpoint())) {
            return false;
        }
        if (other.getCopyTagsToSnapshot() == null ^ this.getCopyTagsToSnapshot() == null) {
            return false;
        }
        if (other.getCopyTagsToSnapshot() != null && !other.getCopyTagsToSnapshot().equals(this.getCopyTagsToSnapshot())) {
            return false;
        }
        if (other.getEnableGlobalWriteForwarding() == null ^ this.getEnableGlobalWriteForwarding() == null) {
            return false;
        }
        if (other.getEnableGlobalWriteForwarding() != null && !other.getEnableGlobalWriteForwarding().equals(this.getEnableGlobalWriteForwarding())) {
            return false;
        }
        if (other.getDBClusterInstanceClass() == null ^ this.getDBClusterInstanceClass() == null) {
            return false;
        }
        if (other.getDBClusterInstanceClass() != null && !other.getDBClusterInstanceClass().equals(this.getDBClusterInstanceClass())) {
            return false;
        }
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getStorageType() == null ^ this.getStorageType() == null) {
            return false;
        }
        if (other.getStorageType() != null && !other.getStorageType().equals(this.getStorageType())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        if (other.getIops() != null && !other.getIops().equals(this.getIops())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() != null && !other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getMonitoringInterval() == null ^ this.getMonitoringInterval() == null) {
            return false;
        }
        if (other.getMonitoringInterval() != null && !other.getMonitoringInterval().equals(this.getMonitoringInterval())) {
            return false;
        }
        if (other.getMonitoringRoleArn() == null ^ this.getMonitoringRoleArn() == null) {
            return false;
        }
        if (other.getMonitoringRoleArn() != null && !other.getMonitoringRoleArn().equals(this.getMonitoringRoleArn())) {
            return false;
        }
        if (other.getEnablePerformanceInsights() == null ^ this.getEnablePerformanceInsights() == null) {
            return false;
        }
        if (other.getEnablePerformanceInsights() != null && !other.getEnablePerformanceInsights().equals(this.getEnablePerformanceInsights())) {
            return false;
        }
        if (other.getPerformanceInsightsKMSKeyId() == null ^ this.getPerformanceInsightsKMSKeyId() == null) {
            return false;
        }
        if (other.getPerformanceInsightsKMSKeyId() != null && !other.getPerformanceInsightsKMSKeyId().equals(this.getPerformanceInsightsKMSKeyId())) {
            return false;
        }
        if (other.getPerformanceInsightsRetentionPeriod() == null ^ this.getPerformanceInsightsRetentionPeriod() == null) {
            return false;
        }
        if (other.getPerformanceInsightsRetentionPeriod() != null && !other.getPerformanceInsightsRetentionPeriod().equals(this.getPerformanceInsightsRetentionPeriod())) {
            return false;
        }
        if (other.getServerlessV2ScalingConfiguration() == null ^ this.getServerlessV2ScalingConfiguration() == null) {
            return false;
        }
        if (other.getServerlessV2ScalingConfiguration() != null && !other.getServerlessV2ScalingConfiguration().equals(this.getServerlessV2ScalingConfiguration())) {
            return false;
        }
        if (other.getNetworkType() == null ^ this.getNetworkType() == null) {
            return false;
        }
        if (other.getNetworkType() != null && !other.getNetworkType().equals(this.getNetworkType())) {
            return false;
        }
        if (other.getManageMasterUserPassword() == null ^ this.getManageMasterUserPassword() == null) {
            return false;
        }
        if (other.getManageMasterUserPassword() != null && !other.getManageMasterUserPassword().equals(this.getManageMasterUserPassword())) {
            return false;
        }
        if (other.getRotateMasterUserPassword() == null ^ this.getRotateMasterUserPassword() == null) {
            return false;
        }
        if (other.getRotateMasterUserPassword() != null && !other.getRotateMasterUserPassword().equals(this.getRotateMasterUserPassword())) {
            return false;
        }
        if (other.getMasterUserSecretKmsKeyId() == null ^ this.getMasterUserSecretKmsKeyId() == null) {
            return false;
        }
        if (other.getMasterUserSecretKmsKeyId() != null && !other.getMasterUserSecretKmsKeyId().equals(this.getMasterUserSecretKmsKeyId())) {
            return false;
        }
        if (other.getEngineMode() == null ^ this.getEngineMode() == null) {
            return false;
        }
        if (other.getEngineMode() != null && !other.getEngineMode().equals(this.getEngineMode())) {
            return false;
        }
        if (other.getAllowEngineModeChange() == null ^ this.getAllowEngineModeChange() == null) {
            return false;
        }
        if (other.getAllowEngineModeChange() != null && !other.getAllowEngineModeChange().equals(this.getAllowEngineModeChange())) {
            return false;
        }
        if (other.getEnableLocalWriteForwarding() == null ^ this.getEnableLocalWriteForwarding() == null) {
            return false;
        }
        return other.getEnableLocalWriteForwarding() == null || other.getEnableLocalWriteForwarding().equals(this.getEnableLocalWriteForwarding());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getNewDBClusterIdentifier() == null ? 0 : this.getNewDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getApplyImmediately() == null ? 0 : this.getApplyImmediately().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterParameterGroupName() == null ? 0 : this.getDBClusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupIds() == null ? 0 : this.getVpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUserPassword() == null ? 0 : this.getMasterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getEnableIAMDatabaseAuthentication() == null ? 0 : this.getEnableIAMDatabaseAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getBacktrackWindow() == null ? 0 : this.getBacktrackWindow().hashCode());
        hashCode = 31 * hashCode + (this.getCloudwatchLogsExportConfiguration() == null ? 0 : this.getCloudwatchLogsExportConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAllowMajorVersionUpgrade() == null ? 0 : this.getAllowMajorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceParameterGroupName() == null ? 0 : this.getDBInstanceParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIAMRoleName() == null ? 0 : this.getDomainIAMRoleName().hashCode());
        hashCode = 31 * hashCode + (this.getScalingConfiguration() == null ? 0 : this.getScalingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeletionProtection() == null ? 0 : this.getDeletionProtection().hashCode());
        hashCode = 31 * hashCode + (this.getEnableHttpEndpoint() == null ? 0 : this.getEnableHttpEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToSnapshot() == null ? 0 : this.getCopyTagsToSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.getEnableGlobalWriteForwarding() == null ? 0 : this.getEnableGlobalWriteForwarding().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterInstanceClass() == null ? 0 : this.getDBClusterInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getStorageType() == null ? 0 : this.getStorageType().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringInterval() == null ? 0 : this.getMonitoringInterval().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringRoleArn() == null ? 0 : this.getMonitoringRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getEnablePerformanceInsights() == null ? 0 : this.getEnablePerformanceInsights().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceInsightsKMSKeyId() == null ? 0 : this.getPerformanceInsightsKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceInsightsRetentionPeriod() == null ? 0 : this.getPerformanceInsightsRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getServerlessV2ScalingConfiguration() == null ? 0 : this.getServerlessV2ScalingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkType() == null ? 0 : this.getNetworkType().hashCode());
        hashCode = 31 * hashCode + (this.getManageMasterUserPassword() == null ? 0 : this.getManageMasterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.getRotateMasterUserPassword() == null ? 0 : this.getRotateMasterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUserSecretKmsKeyId() == null ? 0 : this.getMasterUserSecretKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getEngineMode() == null ? 0 : this.getEngineMode().hashCode());
        hashCode = 31 * hashCode + (this.getAllowEngineModeChange() == null ? 0 : this.getAllowEngineModeChange().hashCode());
        hashCode = 31 * hashCode + (this.getEnableLocalWriteForwarding() == null ? 0 : this.getEnableLocalWriteForwarding().hashCode());
        return hashCode;
    }

    public ModifyDBClusterRequest clone() {
        return (ModifyDBClusterRequest)super.clone();
    }
}

