/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.rds.model.IntegrationError;
import com.amazonaws.services.rds.model.IntegrationStatus;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CreateIntegrationResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String sourceArn;
    private String targetArn;
    private String integrationName;
    private String integrationArn;
    private String kMSKeyId;
    private SdkInternalMap<String, String> additionalEncryptionContext;
    private String status;
    private SdkInternalList<Tag> tags;
    private Date createTime;
    private SdkInternalList<IntegrationError> errors;

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public CreateIntegrationResult withSourceArn(String sourceArn) {
        this.setSourceArn(sourceArn);
        return this;
    }

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public CreateIntegrationResult withTargetArn(String targetArn) {
        this.setTargetArn(targetArn);
        return this;
    }

    public void setIntegrationName(String integrationName) {
        this.integrationName = integrationName;
    }

    public String getIntegrationName() {
        return this.integrationName;
    }

    public CreateIntegrationResult withIntegrationName(String integrationName) {
        this.setIntegrationName(integrationName);
        return this;
    }

    public void setIntegrationArn(String integrationArn) {
        this.integrationArn = integrationArn;
    }

    public String getIntegrationArn() {
        return this.integrationArn;
    }

    public CreateIntegrationResult withIntegrationArn(String integrationArn) {
        this.setIntegrationArn(integrationArn);
        return this;
    }

    public void setKMSKeyId(String kMSKeyId) {
        this.kMSKeyId = kMSKeyId;
    }

    public String getKMSKeyId() {
        return this.kMSKeyId;
    }

    public CreateIntegrationResult withKMSKeyId(String kMSKeyId) {
        this.setKMSKeyId(kMSKeyId);
        return this;
    }

    public Map<String, String> getAdditionalEncryptionContext() {
        if (this.additionalEncryptionContext == null) {
            this.additionalEncryptionContext = new SdkInternalMap();
        }
        return this.additionalEncryptionContext;
    }

    public void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.additionalEncryptionContext = additionalEncryptionContext == null ? null : new SdkInternalMap(additionalEncryptionContext);
    }

    public CreateIntegrationResult withAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.setAdditionalEncryptionContext(additionalEncryptionContext);
        return this;
    }

    public CreateIntegrationResult addAdditionalEncryptionContextEntry(String key, String value) {
        if (null == this.additionalEncryptionContext) {
            this.additionalEncryptionContext = new SdkInternalMap();
        }
        if (this.additionalEncryptionContext.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalEncryptionContext.put((Object)key, (Object)value);
        return this;
    }

    public CreateIntegrationResult clearAdditionalEncryptionContextEntries() {
        this.additionalEncryptionContext = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public CreateIntegrationResult withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public CreateIntegrationResult withStatus(IntegrationStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateIntegrationResult withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateIntegrationResult withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public CreateIntegrationResult withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public List<IntegrationError> getErrors() {
        if (this.errors == null) {
            this.errors = new SdkInternalList();
        }
        return this.errors;
    }

    public void setErrors(Collection<IntegrationError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new SdkInternalList(errors);
    }

    public CreateIntegrationResult withErrors(IntegrationError ... errors) {
        if (this.errors == null) {
            this.setErrors((Collection<IntegrationError>)new SdkInternalList(errors.length));
        }
        for (IntegrationError ele : errors) {
            this.errors.add((Object)ele);
        }
        return this;
    }

    public CreateIntegrationResult withErrors(Collection<IntegrationError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceArn() != null) {
            sb.append("SourceArn: ").append(this.getSourceArn()).append(",");
        }
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: ").append(this.getTargetArn()).append(",");
        }
        if (this.getIntegrationName() != null) {
            sb.append("IntegrationName: ").append(this.getIntegrationName()).append(",");
        }
        if (this.getIntegrationArn() != null) {
            sb.append("IntegrationArn: ").append(this.getIntegrationArn()).append(",");
        }
        if (this.getKMSKeyId() != null) {
            sb.append("KMSKeyId: ").append(this.getKMSKeyId()).append(",");
        }
        if (this.getAdditionalEncryptionContext() != null) {
            sb.append("AdditionalEncryptionContext: ").append(this.getAdditionalEncryptionContext()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationResult)) {
            return false;
        }
        CreateIntegrationResult other = (CreateIntegrationResult)obj;
        if (other.getSourceArn() == null ^ this.getSourceArn() == null) {
            return false;
        }
        if (other.getSourceArn() != null && !other.getSourceArn().equals(this.getSourceArn())) {
            return false;
        }
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getIntegrationName() == null ^ this.getIntegrationName() == null) {
            return false;
        }
        if (other.getIntegrationName() != null && !other.getIntegrationName().equals(this.getIntegrationName())) {
            return false;
        }
        if (other.getIntegrationArn() == null ^ this.getIntegrationArn() == null) {
            return false;
        }
        if (other.getIntegrationArn() != null && !other.getIntegrationArn().equals(this.getIntegrationArn())) {
            return false;
        }
        if (other.getKMSKeyId() == null ^ this.getKMSKeyId() == null) {
            return false;
        }
        if (other.getKMSKeyId() != null && !other.getKMSKeyId().equals(this.getKMSKeyId())) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() == null ^ this.getAdditionalEncryptionContext() == null) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() != null && !other.getAdditionalEncryptionContext().equals(this.getAdditionalEncryptionContext())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceArn() == null ? 0 : this.getSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationName() == null ? 0 : this.getIntegrationName().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationArn() == null ? 0 : this.getIntegrationArn().hashCode());
        hashCode = 31 * hashCode + (this.getKMSKeyId() == null ? 0 : this.getKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalEncryptionContext() == null ? 0 : this.getAdditionalEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public CreateIntegrationResult clone() {
        try {
            return (CreateIntegrationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

