/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ActivityStreamMode;
import com.amazonaws.services.rds.model.ActivityStreamStatus;
import com.amazonaws.services.rds.model.ClusterPendingModifiedValues;
import com.amazonaws.services.rds.model.DBClusterMember;
import com.amazonaws.services.rds.model.DBClusterOptionGroupStatus;
import com.amazonaws.services.rds.model.DBClusterRole;
import com.amazonaws.services.rds.model.DBClusterStatusInfo;
import com.amazonaws.services.rds.model.DomainMembership;
import com.amazonaws.services.rds.model.LimitlessDatabase;
import com.amazonaws.services.rds.model.LocalWriteForwardingStatus;
import com.amazonaws.services.rds.model.MasterUserSecret;
import com.amazonaws.services.rds.model.RdsCustomClusterConfiguration;
import com.amazonaws.services.rds.model.ScalingConfigurationInfo;
import com.amazonaws.services.rds.model.ServerlessV2ScalingConfigurationInfo;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.services.rds.model.VpcSecurityGroupMembership;
import com.amazonaws.services.rds.model.WriteForwardingStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DBCluster
implements Serializable,
Cloneable {
    private Integer allocatedStorage;
    private SdkInternalList<String> availabilityZones;
    private Integer backupRetentionPeriod;
    private String characterSetName;
    private String databaseName;
    private String dBClusterIdentifier;
    private String dBClusterParameterGroup;
    private String dBSubnetGroup;
    private String status;
    private Date automaticRestartTime;
    private String percentProgress;
    private Date earliestRestorableTime;
    private String endpoint;
    private String readerEndpoint;
    private SdkInternalList<String> customEndpoints;
    private Boolean multiAZ;
    private String engine;
    private String engineVersion;
    private Date latestRestorableTime;
    private Integer port;
    private String masterUsername;
    private SdkInternalList<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships;
    private String preferredBackupWindow;
    private String preferredMaintenanceWindow;
    private String replicationSourceIdentifier;
    private SdkInternalList<String> readReplicaIdentifiers;
    private SdkInternalList<DBClusterStatusInfo> statusInfos;
    private SdkInternalList<DBClusterMember> dBClusterMembers;
    private SdkInternalList<VpcSecurityGroupMembership> vpcSecurityGroups;
    private String hostedZoneId;
    private Boolean storageEncrypted;
    private String kmsKeyId;
    private String dbClusterResourceId;
    private String dBClusterArn;
    private SdkInternalList<DBClusterRole> associatedRoles;
    private Boolean iAMDatabaseAuthenticationEnabled;
    private String cloneGroupId;
    private Date clusterCreateTime;
    private Date earliestBacktrackTime;
    private Long backtrackWindow;
    private Long backtrackConsumedChangeRecords;
    private SdkInternalList<String> enabledCloudwatchLogsExports;
    private Integer capacity;
    private String engineMode;
    private ScalingConfigurationInfo scalingConfigurationInfo;
    private RdsCustomClusterConfiguration rdsCustomClusterConfiguration;
    private Boolean deletionProtection;
    private Boolean httpEndpointEnabled;
    private String activityStreamMode;
    private String activityStreamStatus;
    private String activityStreamKmsKeyId;
    private String activityStreamKinesisStreamName;
    private Boolean copyTagsToSnapshot;
    private Boolean crossAccountClone;
    private SdkInternalList<DomainMembership> domainMemberships;
    private SdkInternalList<Tag> tagList;
    private String globalWriteForwardingStatus;
    private Boolean globalWriteForwardingRequested;
    private ClusterPendingModifiedValues pendingModifiedValues;
    private String dBClusterInstanceClass;
    private String storageType;
    private Integer iops;
    private Boolean publiclyAccessible;
    private Boolean autoMinorVersionUpgrade;
    private Integer monitoringInterval;
    private String monitoringRoleArn;
    private Boolean performanceInsightsEnabled;
    private String performanceInsightsKMSKeyId;
    private Integer performanceInsightsRetentionPeriod;
    private ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration;
    private String networkType;
    private String dBSystemId;
    private MasterUserSecret masterUserSecret;
    private Date iOOptimizedNextAllowedModificationTime;
    private String localWriteForwardingStatus;
    private String awsBackupRecoveryPointArn;
    private LimitlessDatabase limitlessDatabase;

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public DBCluster withAllocatedStorage(Integer allocatedStorage) {
        this.setAllocatedStorage(allocatedStorage);
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList(availabilityZones);
    }

    public DBCluster withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones((Collection<String>)new SdkInternalList(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add((Object)ele);
        }
        return this;
    }

    public DBCluster withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public DBCluster withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.setBackupRetentionPeriod(backupRetentionPeriod);
        return this;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public DBCluster withCharacterSetName(String characterSetName) {
        this.setCharacterSetName(characterSetName);
        return this;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DBCluster withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public DBCluster withDBClusterIdentifier(String dBClusterIdentifier) {
        this.setDBClusterIdentifier(dBClusterIdentifier);
        return this;
    }

    public void setDBClusterParameterGroup(String dBClusterParameterGroup) {
        this.dBClusterParameterGroup = dBClusterParameterGroup;
    }

    public String getDBClusterParameterGroup() {
        return this.dBClusterParameterGroup;
    }

    public DBCluster withDBClusterParameterGroup(String dBClusterParameterGroup) {
        this.setDBClusterParameterGroup(dBClusterParameterGroup);
        return this;
    }

    public void setDBSubnetGroup(String dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
    }

    public String getDBSubnetGroup() {
        return this.dBSubnetGroup;
    }

    public DBCluster withDBSubnetGroup(String dBSubnetGroup) {
        this.setDBSubnetGroup(dBSubnetGroup);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DBCluster withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setAutomaticRestartTime(Date automaticRestartTime) {
        this.automaticRestartTime = automaticRestartTime;
    }

    public Date getAutomaticRestartTime() {
        return this.automaticRestartTime;
    }

    public DBCluster withAutomaticRestartTime(Date automaticRestartTime) {
        this.setAutomaticRestartTime(automaticRestartTime);
        return this;
    }

    public void setPercentProgress(String percentProgress) {
        this.percentProgress = percentProgress;
    }

    public String getPercentProgress() {
        return this.percentProgress;
    }

    public DBCluster withPercentProgress(String percentProgress) {
        this.setPercentProgress(percentProgress);
        return this;
    }

    public void setEarliestRestorableTime(Date earliestRestorableTime) {
        this.earliestRestorableTime = earliestRestorableTime;
    }

    public Date getEarliestRestorableTime() {
        return this.earliestRestorableTime;
    }

    public DBCluster withEarliestRestorableTime(Date earliestRestorableTime) {
        this.setEarliestRestorableTime(earliestRestorableTime);
        return this;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public DBCluster withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setReaderEndpoint(String readerEndpoint) {
        this.readerEndpoint = readerEndpoint;
    }

    public String getReaderEndpoint() {
        return this.readerEndpoint;
    }

    public DBCluster withReaderEndpoint(String readerEndpoint) {
        this.setReaderEndpoint(readerEndpoint);
        return this;
    }

    public List<String> getCustomEndpoints() {
        if (this.customEndpoints == null) {
            this.customEndpoints = new SdkInternalList();
        }
        return this.customEndpoints;
    }

    public void setCustomEndpoints(Collection<String> customEndpoints) {
        if (customEndpoints == null) {
            this.customEndpoints = null;
            return;
        }
        this.customEndpoints = new SdkInternalList(customEndpoints);
    }

    public DBCluster withCustomEndpoints(String ... customEndpoints) {
        if (this.customEndpoints == null) {
            this.setCustomEndpoints((Collection<String>)new SdkInternalList(customEndpoints.length));
        }
        for (String ele : customEndpoints) {
            this.customEndpoints.add((Object)ele);
        }
        return this;
    }

    public DBCluster withCustomEndpoints(Collection<String> customEndpoints) {
        this.setCustomEndpoints(customEndpoints);
        return this;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public DBCluster withMultiAZ(Boolean multiAZ) {
        this.setMultiAZ(multiAZ);
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public DBCluster withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public DBCluster withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public Date getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public DBCluster withLatestRestorableTime(Date latestRestorableTime) {
        this.setLatestRestorableTime(latestRestorableTime);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public DBCluster withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public DBCluster withMasterUsername(String masterUsername) {
        this.setMasterUsername(masterUsername);
        return this;
    }

    public List<DBClusterOptionGroupStatus> getDBClusterOptionGroupMemberships() {
        if (this.dBClusterOptionGroupMemberships == null) {
            this.dBClusterOptionGroupMemberships = new SdkInternalList();
        }
        return this.dBClusterOptionGroupMemberships;
    }

    public void setDBClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships) {
        if (dBClusterOptionGroupMemberships == null) {
            this.dBClusterOptionGroupMemberships = null;
            return;
        }
        this.dBClusterOptionGroupMemberships = new SdkInternalList(dBClusterOptionGroupMemberships);
    }

    public DBCluster withDBClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... dBClusterOptionGroupMemberships) {
        if (this.dBClusterOptionGroupMemberships == null) {
            this.setDBClusterOptionGroupMemberships((Collection<DBClusterOptionGroupStatus>)new SdkInternalList(dBClusterOptionGroupMemberships.length));
        }
        for (DBClusterOptionGroupStatus ele : dBClusterOptionGroupMemberships) {
            this.dBClusterOptionGroupMemberships.add((Object)ele);
        }
        return this;
    }

    public DBCluster withDBClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dBClusterOptionGroupMemberships) {
        this.setDBClusterOptionGroupMemberships(dBClusterOptionGroupMemberships);
        return this;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public DBCluster withPreferredBackupWindow(String preferredBackupWindow) {
        this.setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public DBCluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
        this.replicationSourceIdentifier = replicationSourceIdentifier;
    }

    public String getReplicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public DBCluster withReplicationSourceIdentifier(String replicationSourceIdentifier) {
        this.setReplicationSourceIdentifier(replicationSourceIdentifier);
        return this;
    }

    public List<String> getReadReplicaIdentifiers() {
        if (this.readReplicaIdentifiers == null) {
            this.readReplicaIdentifiers = new SdkInternalList();
        }
        return this.readReplicaIdentifiers;
    }

    public void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
        if (readReplicaIdentifiers == null) {
            this.readReplicaIdentifiers = null;
            return;
        }
        this.readReplicaIdentifiers = new SdkInternalList(readReplicaIdentifiers);
    }

    public DBCluster withReadReplicaIdentifiers(String ... readReplicaIdentifiers) {
        if (this.readReplicaIdentifiers == null) {
            this.setReadReplicaIdentifiers((Collection<String>)new SdkInternalList(readReplicaIdentifiers.length));
        }
        for (String ele : readReplicaIdentifiers) {
            this.readReplicaIdentifiers.add((Object)ele);
        }
        return this;
    }

    public DBCluster withReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
        this.setReadReplicaIdentifiers(readReplicaIdentifiers);
        return this;
    }

    public List<DBClusterStatusInfo> getStatusInfos() {
        if (this.statusInfos == null) {
            this.statusInfos = new SdkInternalList();
        }
        return this.statusInfos;
    }

    public void setStatusInfos(Collection<DBClusterStatusInfo> statusInfos) {
        if (statusInfos == null) {
            this.statusInfos = null;
            return;
        }
        this.statusInfos = new SdkInternalList(statusInfos);
    }

    public DBCluster withStatusInfos(DBClusterStatusInfo ... statusInfos) {
        if (this.statusInfos == null) {
            this.setStatusInfos((Collection<DBClusterStatusInfo>)new SdkInternalList(statusInfos.length));
        }
        for (DBClusterStatusInfo ele : statusInfos) {
            this.statusInfos.add((Object)ele);
        }
        return this;
    }

    public DBCluster withStatusInfos(Collection<DBClusterStatusInfo> statusInfos) {
        this.setStatusInfos(statusInfos);
        return this;
    }

    public List<DBClusterMember> getDBClusterMembers() {
        if (this.dBClusterMembers == null) {
            this.dBClusterMembers = new SdkInternalList();
        }
        return this.dBClusterMembers;
    }

    public void setDBClusterMembers(Collection<DBClusterMember> dBClusterMembers) {
        if (dBClusterMembers == null) {
            this.dBClusterMembers = null;
            return;
        }
        this.dBClusterMembers = new SdkInternalList(dBClusterMembers);
    }

    public DBCluster withDBClusterMembers(DBClusterMember ... dBClusterMembers) {
        if (this.dBClusterMembers == null) {
            this.setDBClusterMembers((Collection<DBClusterMember>)new SdkInternalList(dBClusterMembers.length));
        }
        for (DBClusterMember ele : dBClusterMembers) {
            this.dBClusterMembers.add((Object)ele);
        }
        return this;
    }

    public DBCluster withDBClusterMembers(Collection<DBClusterMember> dBClusterMembers) {
        this.setDBClusterMembers(dBClusterMembers);
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        if (this.vpcSecurityGroups == null) {
            this.vpcSecurityGroups = new SdkInternalList();
        }
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        this.vpcSecurityGroups = new SdkInternalList(vpcSecurityGroups);
    }

    public DBCluster withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.vpcSecurityGroups == null) {
            this.setVpcSecurityGroups((Collection<VpcSecurityGroupMembership>)new SdkInternalList(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership ele : vpcSecurityGroups) {
            this.vpcSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public DBCluster withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        this.setVpcSecurityGroups(vpcSecurityGroups);
        return this;
    }

    public void setHostedZoneId(String hostedZoneId) {
        this.hostedZoneId = hostedZoneId;
    }

    public String getHostedZoneId() {
        return this.hostedZoneId;
    }

    public DBCluster withHostedZoneId(String hostedZoneId) {
        this.setHostedZoneId(hostedZoneId);
        return this;
    }

    public void setStorageEncrypted(Boolean storageEncrypted) {
        this.storageEncrypted = storageEncrypted;
    }

    public Boolean getStorageEncrypted() {
        return this.storageEncrypted;
    }

    public DBCluster withStorageEncrypted(Boolean storageEncrypted) {
        this.setStorageEncrypted(storageEncrypted);
        return this;
    }

    public Boolean isStorageEncrypted() {
        return this.storageEncrypted;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public DBCluster withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setDbClusterResourceId(String dbClusterResourceId) {
        this.dbClusterResourceId = dbClusterResourceId;
    }

    public String getDbClusterResourceId() {
        return this.dbClusterResourceId;
    }

    public DBCluster withDbClusterResourceId(String dbClusterResourceId) {
        this.setDbClusterResourceId(dbClusterResourceId);
        return this;
    }

    public void setDBClusterArn(String dBClusterArn) {
        this.dBClusterArn = dBClusterArn;
    }

    public String getDBClusterArn() {
        return this.dBClusterArn;
    }

    public DBCluster withDBClusterArn(String dBClusterArn) {
        this.setDBClusterArn(dBClusterArn);
        return this;
    }

    public List<DBClusterRole> getAssociatedRoles() {
        if (this.associatedRoles == null) {
            this.associatedRoles = new SdkInternalList();
        }
        return this.associatedRoles;
    }

    public void setAssociatedRoles(Collection<DBClusterRole> associatedRoles) {
        if (associatedRoles == null) {
            this.associatedRoles = null;
            return;
        }
        this.associatedRoles = new SdkInternalList(associatedRoles);
    }

    public DBCluster withAssociatedRoles(DBClusterRole ... associatedRoles) {
        if (this.associatedRoles == null) {
            this.setAssociatedRoles((Collection<DBClusterRole>)new SdkInternalList(associatedRoles.length));
        }
        for (DBClusterRole ele : associatedRoles) {
            this.associatedRoles.add((Object)ele);
        }
        return this;
    }

    public DBCluster withAssociatedRoles(Collection<DBClusterRole> associatedRoles) {
        this.setAssociatedRoles(associatedRoles);
        return this;
    }

    public void setIAMDatabaseAuthenticationEnabled(Boolean iAMDatabaseAuthenticationEnabled) {
        this.iAMDatabaseAuthenticationEnabled = iAMDatabaseAuthenticationEnabled;
    }

    public Boolean getIAMDatabaseAuthenticationEnabled() {
        return this.iAMDatabaseAuthenticationEnabled;
    }

    public DBCluster withIAMDatabaseAuthenticationEnabled(Boolean iAMDatabaseAuthenticationEnabled) {
        this.setIAMDatabaseAuthenticationEnabled(iAMDatabaseAuthenticationEnabled);
        return this;
    }

    public Boolean isIAMDatabaseAuthenticationEnabled() {
        return this.iAMDatabaseAuthenticationEnabled;
    }

    public void setCloneGroupId(String cloneGroupId) {
        this.cloneGroupId = cloneGroupId;
    }

    public String getCloneGroupId() {
        return this.cloneGroupId;
    }

    public DBCluster withCloneGroupId(String cloneGroupId) {
        this.setCloneGroupId(cloneGroupId);
        return this;
    }

    public void setClusterCreateTime(Date clusterCreateTime) {
        this.clusterCreateTime = clusterCreateTime;
    }

    public Date getClusterCreateTime() {
        return this.clusterCreateTime;
    }

    public DBCluster withClusterCreateTime(Date clusterCreateTime) {
        this.setClusterCreateTime(clusterCreateTime);
        return this;
    }

    public void setEarliestBacktrackTime(Date earliestBacktrackTime) {
        this.earliestBacktrackTime = earliestBacktrackTime;
    }

    public Date getEarliestBacktrackTime() {
        return this.earliestBacktrackTime;
    }

    public DBCluster withEarliestBacktrackTime(Date earliestBacktrackTime) {
        this.setEarliestBacktrackTime(earliestBacktrackTime);
        return this;
    }

    public void setBacktrackWindow(Long backtrackWindow) {
        this.backtrackWindow = backtrackWindow;
    }

    public Long getBacktrackWindow() {
        return this.backtrackWindow;
    }

    public DBCluster withBacktrackWindow(Long backtrackWindow) {
        this.setBacktrackWindow(backtrackWindow);
        return this;
    }

    public void setBacktrackConsumedChangeRecords(Long backtrackConsumedChangeRecords) {
        this.backtrackConsumedChangeRecords = backtrackConsumedChangeRecords;
    }

    public Long getBacktrackConsumedChangeRecords() {
        return this.backtrackConsumedChangeRecords;
    }

    public DBCluster withBacktrackConsumedChangeRecords(Long backtrackConsumedChangeRecords) {
        this.setBacktrackConsumedChangeRecords(backtrackConsumedChangeRecords);
        return this;
    }

    public List<String> getEnabledCloudwatchLogsExports() {
        if (this.enabledCloudwatchLogsExports == null) {
            this.enabledCloudwatchLogsExports = new SdkInternalList();
        }
        return this.enabledCloudwatchLogsExports;
    }

    public void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
        if (enabledCloudwatchLogsExports == null) {
            this.enabledCloudwatchLogsExports = null;
            return;
        }
        this.enabledCloudwatchLogsExports = new SdkInternalList(enabledCloudwatchLogsExports);
    }

    public DBCluster withEnabledCloudwatchLogsExports(String ... enabledCloudwatchLogsExports) {
        if (this.enabledCloudwatchLogsExports == null) {
            this.setEnabledCloudwatchLogsExports((Collection<String>)new SdkInternalList(enabledCloudwatchLogsExports.length));
        }
        for (String ele : enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports.add((Object)ele);
        }
        return this;
    }

    public DBCluster withEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
        this.setEnabledCloudwatchLogsExports(enabledCloudwatchLogsExports);
        return this;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public DBCluster withCapacity(Integer capacity) {
        this.setCapacity(capacity);
        return this;
    }

    public void setEngineMode(String engineMode) {
        this.engineMode = engineMode;
    }

    public String getEngineMode() {
        return this.engineMode;
    }

    public DBCluster withEngineMode(String engineMode) {
        this.setEngineMode(engineMode);
        return this;
    }

    public void setScalingConfigurationInfo(ScalingConfigurationInfo scalingConfigurationInfo) {
        this.scalingConfigurationInfo = scalingConfigurationInfo;
    }

    public ScalingConfigurationInfo getScalingConfigurationInfo() {
        return this.scalingConfigurationInfo;
    }

    public DBCluster withScalingConfigurationInfo(ScalingConfigurationInfo scalingConfigurationInfo) {
        this.setScalingConfigurationInfo(scalingConfigurationInfo);
        return this;
    }

    public void setRdsCustomClusterConfiguration(RdsCustomClusterConfiguration rdsCustomClusterConfiguration) {
        this.rdsCustomClusterConfiguration = rdsCustomClusterConfiguration;
    }

    public RdsCustomClusterConfiguration getRdsCustomClusterConfiguration() {
        return this.rdsCustomClusterConfiguration;
    }

    public DBCluster withRdsCustomClusterConfiguration(RdsCustomClusterConfiguration rdsCustomClusterConfiguration) {
        this.setRdsCustomClusterConfiguration(rdsCustomClusterConfiguration);
        return this;
    }

    public void setDeletionProtection(Boolean deletionProtection) {
        this.deletionProtection = deletionProtection;
    }

    public Boolean getDeletionProtection() {
        return this.deletionProtection;
    }

    public DBCluster withDeletionProtection(Boolean deletionProtection) {
        this.setDeletionProtection(deletionProtection);
        return this;
    }

    public Boolean isDeletionProtection() {
        return this.deletionProtection;
    }

    public void setHttpEndpointEnabled(Boolean httpEndpointEnabled) {
        this.httpEndpointEnabled = httpEndpointEnabled;
    }

    public Boolean getHttpEndpointEnabled() {
        return this.httpEndpointEnabled;
    }

    public DBCluster withHttpEndpointEnabled(Boolean httpEndpointEnabled) {
        this.setHttpEndpointEnabled(httpEndpointEnabled);
        return this;
    }

    public Boolean isHttpEndpointEnabled() {
        return this.httpEndpointEnabled;
    }

    public void setActivityStreamMode(String activityStreamMode) {
        this.activityStreamMode = activityStreamMode;
    }

    public String getActivityStreamMode() {
        return this.activityStreamMode;
    }

    public DBCluster withActivityStreamMode(String activityStreamMode) {
        this.setActivityStreamMode(activityStreamMode);
        return this;
    }

    public DBCluster withActivityStreamMode(ActivityStreamMode activityStreamMode) {
        this.activityStreamMode = activityStreamMode.toString();
        return this;
    }

    public void setActivityStreamStatus(String activityStreamStatus) {
        this.activityStreamStatus = activityStreamStatus;
    }

    public String getActivityStreamStatus() {
        return this.activityStreamStatus;
    }

    public DBCluster withActivityStreamStatus(String activityStreamStatus) {
        this.setActivityStreamStatus(activityStreamStatus);
        return this;
    }

    public DBCluster withActivityStreamStatus(ActivityStreamStatus activityStreamStatus) {
        this.activityStreamStatus = activityStreamStatus.toString();
        return this;
    }

    public void setActivityStreamKmsKeyId(String activityStreamKmsKeyId) {
        this.activityStreamKmsKeyId = activityStreamKmsKeyId;
    }

    public String getActivityStreamKmsKeyId() {
        return this.activityStreamKmsKeyId;
    }

    public DBCluster withActivityStreamKmsKeyId(String activityStreamKmsKeyId) {
        this.setActivityStreamKmsKeyId(activityStreamKmsKeyId);
        return this;
    }

    public void setActivityStreamKinesisStreamName(String activityStreamKinesisStreamName) {
        this.activityStreamKinesisStreamName = activityStreamKinesisStreamName;
    }

    public String getActivityStreamKinesisStreamName() {
        return this.activityStreamKinesisStreamName;
    }

    public DBCluster withActivityStreamKinesisStreamName(String activityStreamKinesisStreamName) {
        this.setActivityStreamKinesisStreamName(activityStreamKinesisStreamName);
        return this;
    }

    public void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
    }

    public Boolean getCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public DBCluster withCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.setCopyTagsToSnapshot(copyTagsToSnapshot);
        return this;
    }

    public Boolean isCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public void setCrossAccountClone(Boolean crossAccountClone) {
        this.crossAccountClone = crossAccountClone;
    }

    public Boolean getCrossAccountClone() {
        return this.crossAccountClone;
    }

    public DBCluster withCrossAccountClone(Boolean crossAccountClone) {
        this.setCrossAccountClone(crossAccountClone);
        return this;
    }

    public Boolean isCrossAccountClone() {
        return this.crossAccountClone;
    }

    public List<DomainMembership> getDomainMemberships() {
        if (this.domainMemberships == null) {
            this.domainMemberships = new SdkInternalList();
        }
        return this.domainMemberships;
    }

    public void setDomainMemberships(Collection<DomainMembership> domainMemberships) {
        if (domainMemberships == null) {
            this.domainMemberships = null;
            return;
        }
        this.domainMemberships = new SdkInternalList(domainMemberships);
    }

    public DBCluster withDomainMemberships(DomainMembership ... domainMemberships) {
        if (this.domainMemberships == null) {
            this.setDomainMemberships((Collection<DomainMembership>)new SdkInternalList(domainMemberships.length));
        }
        for (DomainMembership ele : domainMemberships) {
            this.domainMemberships.add((Object)ele);
        }
        return this;
    }

    public DBCluster withDomainMemberships(Collection<DomainMembership> domainMemberships) {
        this.setDomainMemberships(domainMemberships);
        return this;
    }

    public List<Tag> getTagList() {
        if (this.tagList == null) {
            this.tagList = new SdkInternalList();
        }
        return this.tagList;
    }

    public void setTagList(Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        this.tagList = new SdkInternalList(tagList);
    }

    public DBCluster withTagList(Tag ... tagList) {
        if (this.tagList == null) {
            this.setTagList((Collection<Tag>)new SdkInternalList(tagList.length));
        }
        for (Tag ele : tagList) {
            this.tagList.add((Object)ele);
        }
        return this;
    }

    public DBCluster withTagList(Collection<Tag> tagList) {
        this.setTagList(tagList);
        return this;
    }

    public void setGlobalWriteForwardingStatus(String globalWriteForwardingStatus) {
        this.globalWriteForwardingStatus = globalWriteForwardingStatus;
    }

    public String getGlobalWriteForwardingStatus() {
        return this.globalWriteForwardingStatus;
    }

    public DBCluster withGlobalWriteForwardingStatus(String globalWriteForwardingStatus) {
        this.setGlobalWriteForwardingStatus(globalWriteForwardingStatus);
        return this;
    }

    public DBCluster withGlobalWriteForwardingStatus(WriteForwardingStatus globalWriteForwardingStatus) {
        this.globalWriteForwardingStatus = globalWriteForwardingStatus.toString();
        return this;
    }

    public void setGlobalWriteForwardingRequested(Boolean globalWriteForwardingRequested) {
        this.globalWriteForwardingRequested = globalWriteForwardingRequested;
    }

    public Boolean getGlobalWriteForwardingRequested() {
        return this.globalWriteForwardingRequested;
    }

    public DBCluster withGlobalWriteForwardingRequested(Boolean globalWriteForwardingRequested) {
        this.setGlobalWriteForwardingRequested(globalWriteForwardingRequested);
        return this;
    }

    public Boolean isGlobalWriteForwardingRequested() {
        return this.globalWriteForwardingRequested;
    }

    public void setPendingModifiedValues(ClusterPendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public ClusterPendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public DBCluster withPendingModifiedValues(ClusterPendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public void setDBClusterInstanceClass(String dBClusterInstanceClass) {
        this.dBClusterInstanceClass = dBClusterInstanceClass;
    }

    public String getDBClusterInstanceClass() {
        return this.dBClusterInstanceClass;
    }

    public DBCluster withDBClusterInstanceClass(String dBClusterInstanceClass) {
        this.setDBClusterInstanceClass(dBClusterInstanceClass);
        return this;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public DBCluster withStorageType(String storageType) {
        this.setStorageType(storageType);
        return this;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public Integer getIops() {
        return this.iops;
    }

    public DBCluster withIops(Integer iops) {
        this.setIops(iops);
        return this;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public DBCluster withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public DBCluster withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setMonitoringInterval(Integer monitoringInterval) {
        this.monitoringInterval = monitoringInterval;
    }

    public Integer getMonitoringInterval() {
        return this.monitoringInterval;
    }

    public DBCluster withMonitoringInterval(Integer monitoringInterval) {
        this.setMonitoringInterval(monitoringInterval);
        return this;
    }

    public void setMonitoringRoleArn(String monitoringRoleArn) {
        this.monitoringRoleArn = monitoringRoleArn;
    }

    public String getMonitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public DBCluster withMonitoringRoleArn(String monitoringRoleArn) {
        this.setMonitoringRoleArn(monitoringRoleArn);
        return this;
    }

    public void setPerformanceInsightsEnabled(Boolean performanceInsightsEnabled) {
        this.performanceInsightsEnabled = performanceInsightsEnabled;
    }

    public Boolean getPerformanceInsightsEnabled() {
        return this.performanceInsightsEnabled;
    }

    public DBCluster withPerformanceInsightsEnabled(Boolean performanceInsightsEnabled) {
        this.setPerformanceInsightsEnabled(performanceInsightsEnabled);
        return this;
    }

    public Boolean isPerformanceInsightsEnabled() {
        return this.performanceInsightsEnabled;
    }

    public void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
        this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
    }

    public String getPerformanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public DBCluster withPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
        this.setPerformanceInsightsKMSKeyId(performanceInsightsKMSKeyId);
        return this;
    }

    public void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
        this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
    }

    public Integer getPerformanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public DBCluster withPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
        this.setPerformanceInsightsRetentionPeriod(performanceInsightsRetentionPeriod);
        return this;
    }

    public void setServerlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration) {
        this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
    }

    public ServerlessV2ScalingConfigurationInfo getServerlessV2ScalingConfiguration() {
        return this.serverlessV2ScalingConfiguration;
    }

    public DBCluster withServerlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration) {
        this.setServerlessV2ScalingConfiguration(serverlessV2ScalingConfiguration);
        return this;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public DBCluster withNetworkType(String networkType) {
        this.setNetworkType(networkType);
        return this;
    }

    public void setDBSystemId(String dBSystemId) {
        this.dBSystemId = dBSystemId;
    }

    public String getDBSystemId() {
        return this.dBSystemId;
    }

    public DBCluster withDBSystemId(String dBSystemId) {
        this.setDBSystemId(dBSystemId);
        return this;
    }

    public void setMasterUserSecret(MasterUserSecret masterUserSecret) {
        this.masterUserSecret = masterUserSecret;
    }

    public MasterUserSecret getMasterUserSecret() {
        return this.masterUserSecret;
    }

    public DBCluster withMasterUserSecret(MasterUserSecret masterUserSecret) {
        this.setMasterUserSecret(masterUserSecret);
        return this;
    }

    public void setIOOptimizedNextAllowedModificationTime(Date iOOptimizedNextAllowedModificationTime) {
        this.iOOptimizedNextAllowedModificationTime = iOOptimizedNextAllowedModificationTime;
    }

    public Date getIOOptimizedNextAllowedModificationTime() {
        return this.iOOptimizedNextAllowedModificationTime;
    }

    public DBCluster withIOOptimizedNextAllowedModificationTime(Date iOOptimizedNextAllowedModificationTime) {
        this.setIOOptimizedNextAllowedModificationTime(iOOptimizedNextAllowedModificationTime);
        return this;
    }

    public void setLocalWriteForwardingStatus(String localWriteForwardingStatus) {
        this.localWriteForwardingStatus = localWriteForwardingStatus;
    }

    public String getLocalWriteForwardingStatus() {
        return this.localWriteForwardingStatus;
    }

    public DBCluster withLocalWriteForwardingStatus(String localWriteForwardingStatus) {
        this.setLocalWriteForwardingStatus(localWriteForwardingStatus);
        return this;
    }

    public DBCluster withLocalWriteForwardingStatus(LocalWriteForwardingStatus localWriteForwardingStatus) {
        this.localWriteForwardingStatus = localWriteForwardingStatus.toString();
        return this;
    }

    public void setAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
        this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
    }

    public String getAwsBackupRecoveryPointArn() {
        return this.awsBackupRecoveryPointArn;
    }

    public DBCluster withAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
        this.setAwsBackupRecoveryPointArn(awsBackupRecoveryPointArn);
        return this;
    }

    public void setLimitlessDatabase(LimitlessDatabase limitlessDatabase) {
        this.limitlessDatabase = limitlessDatabase;
    }

    public LimitlessDatabase getLimitlessDatabase() {
        return this.limitlessDatabase;
    }

    public DBCluster withLimitlessDatabase(LimitlessDatabase limitlessDatabase) {
        this.setLimitlessDatabase(limitlessDatabase);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.getAllocatedStorage()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getBackupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.getBackupRetentionPeriod()).append(",");
        }
        if (this.getCharacterSetName() != null) {
            sb.append("CharacterSetName: ").append(this.getCharacterSetName()).append(",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.getDBClusterIdentifier()).append(",");
        }
        if (this.getDBClusterParameterGroup() != null) {
            sb.append("DBClusterParameterGroup: ").append(this.getDBClusterParameterGroup()).append(",");
        }
        if (this.getDBSubnetGroup() != null) {
            sb.append("DBSubnetGroup: ").append(this.getDBSubnetGroup()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAutomaticRestartTime() != null) {
            sb.append("AutomaticRestartTime: ").append(this.getAutomaticRestartTime()).append(",");
        }
        if (this.getPercentProgress() != null) {
            sb.append("PercentProgress: ").append(this.getPercentProgress()).append(",");
        }
        if (this.getEarliestRestorableTime() != null) {
            sb.append("EarliestRestorableTime: ").append(this.getEarliestRestorableTime()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getReaderEndpoint() != null) {
            sb.append("ReaderEndpoint: ").append(this.getReaderEndpoint()).append(",");
        }
        if (this.getCustomEndpoints() != null) {
            sb.append("CustomEndpoints: ").append(this.getCustomEndpoints()).append(",");
        }
        if (this.getMultiAZ() != null) {
            sb.append("MultiAZ: ").append(this.getMultiAZ()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getLatestRestorableTime() != null) {
            sb.append("LatestRestorableTime: ").append(this.getLatestRestorableTime()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: ").append(this.getMasterUsername()).append(",");
        }
        if (this.getDBClusterOptionGroupMemberships() != null) {
            sb.append("DBClusterOptionGroupMemberships: ").append(this.getDBClusterOptionGroupMemberships()).append(",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.getPreferredBackupWindow()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getReplicationSourceIdentifier() != null) {
            sb.append("ReplicationSourceIdentifier: ").append(this.getReplicationSourceIdentifier()).append(",");
        }
        if (this.getReadReplicaIdentifiers() != null) {
            sb.append("ReadReplicaIdentifiers: ").append(this.getReadReplicaIdentifiers()).append(",");
        }
        if (this.getStatusInfos() != null) {
            sb.append("StatusInfos: ").append(this.getStatusInfos()).append(",");
        }
        if (this.getDBClusterMembers() != null) {
            sb.append("DBClusterMembers: ").append(this.getDBClusterMembers()).append(",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.getVpcSecurityGroups()).append(",");
        }
        if (this.getHostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.getHostedZoneId()).append(",");
        }
        if (this.getStorageEncrypted() != null) {
            sb.append("StorageEncrypted: ").append(this.getStorageEncrypted()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getDbClusterResourceId() != null) {
            sb.append("DbClusterResourceId: ").append(this.getDbClusterResourceId()).append(",");
        }
        if (this.getDBClusterArn() != null) {
            sb.append("DBClusterArn: ").append(this.getDBClusterArn()).append(",");
        }
        if (this.getAssociatedRoles() != null) {
            sb.append("AssociatedRoles: ").append(this.getAssociatedRoles()).append(",");
        }
        if (this.getIAMDatabaseAuthenticationEnabled() != null) {
            sb.append("IAMDatabaseAuthenticationEnabled: ").append(this.getIAMDatabaseAuthenticationEnabled()).append(",");
        }
        if (this.getCloneGroupId() != null) {
            sb.append("CloneGroupId: ").append(this.getCloneGroupId()).append(",");
        }
        if (this.getClusterCreateTime() != null) {
            sb.append("ClusterCreateTime: ").append(this.getClusterCreateTime()).append(",");
        }
        if (this.getEarliestBacktrackTime() != null) {
            sb.append("EarliestBacktrackTime: ").append(this.getEarliestBacktrackTime()).append(",");
        }
        if (this.getBacktrackWindow() != null) {
            sb.append("BacktrackWindow: ").append(this.getBacktrackWindow()).append(",");
        }
        if (this.getBacktrackConsumedChangeRecords() != null) {
            sb.append("BacktrackConsumedChangeRecords: ").append(this.getBacktrackConsumedChangeRecords()).append(",");
        }
        if (this.getEnabledCloudwatchLogsExports() != null) {
            sb.append("EnabledCloudwatchLogsExports: ").append(this.getEnabledCloudwatchLogsExports()).append(",");
        }
        if (this.getCapacity() != null) {
            sb.append("Capacity: ").append(this.getCapacity()).append(",");
        }
        if (this.getEngineMode() != null) {
            sb.append("EngineMode: ").append(this.getEngineMode()).append(",");
        }
        if (this.getScalingConfigurationInfo() != null) {
            sb.append("ScalingConfigurationInfo: ").append(this.getScalingConfigurationInfo()).append(",");
        }
        if (this.getRdsCustomClusterConfiguration() != null) {
            sb.append("RdsCustomClusterConfiguration: ").append(this.getRdsCustomClusterConfiguration()).append(",");
        }
        if (this.getDeletionProtection() != null) {
            sb.append("DeletionProtection: ").append(this.getDeletionProtection()).append(",");
        }
        if (this.getHttpEndpointEnabled() != null) {
            sb.append("HttpEndpointEnabled: ").append(this.getHttpEndpointEnabled()).append(",");
        }
        if (this.getActivityStreamMode() != null) {
            sb.append("ActivityStreamMode: ").append(this.getActivityStreamMode()).append(",");
        }
        if (this.getActivityStreamStatus() != null) {
            sb.append("ActivityStreamStatus: ").append(this.getActivityStreamStatus()).append(",");
        }
        if (this.getActivityStreamKmsKeyId() != null) {
            sb.append("ActivityStreamKmsKeyId: ").append(this.getActivityStreamKmsKeyId()).append(",");
        }
        if (this.getActivityStreamKinesisStreamName() != null) {
            sb.append("ActivityStreamKinesisStreamName: ").append(this.getActivityStreamKinesisStreamName()).append(",");
        }
        if (this.getCopyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: ").append(this.getCopyTagsToSnapshot()).append(",");
        }
        if (this.getCrossAccountClone() != null) {
            sb.append("CrossAccountClone: ").append(this.getCrossAccountClone()).append(",");
        }
        if (this.getDomainMemberships() != null) {
            sb.append("DomainMemberships: ").append(this.getDomainMemberships()).append(",");
        }
        if (this.getTagList() != null) {
            sb.append("TagList: ").append(this.getTagList()).append(",");
        }
        if (this.getGlobalWriteForwardingStatus() != null) {
            sb.append("GlobalWriteForwardingStatus: ").append(this.getGlobalWriteForwardingStatus()).append(",");
        }
        if (this.getGlobalWriteForwardingRequested() != null) {
            sb.append("GlobalWriteForwardingRequested: ").append(this.getGlobalWriteForwardingRequested()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getDBClusterInstanceClass() != null) {
            sb.append("DBClusterInstanceClass: ").append(this.getDBClusterInstanceClass()).append(",");
        }
        if (this.getStorageType() != null) {
            sb.append("StorageType: ").append(this.getStorageType()).append(",");
        }
        if (this.getIops() != null) {
            sb.append("Iops: ").append(this.getIops()).append(",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.getPubliclyAccessible()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade()).append(",");
        }
        if (this.getMonitoringInterval() != null) {
            sb.append("MonitoringInterval: ").append(this.getMonitoringInterval()).append(",");
        }
        if (this.getMonitoringRoleArn() != null) {
            sb.append("MonitoringRoleArn: ").append(this.getMonitoringRoleArn()).append(",");
        }
        if (this.getPerformanceInsightsEnabled() != null) {
            sb.append("PerformanceInsightsEnabled: ").append(this.getPerformanceInsightsEnabled()).append(",");
        }
        if (this.getPerformanceInsightsKMSKeyId() != null) {
            sb.append("PerformanceInsightsKMSKeyId: ").append(this.getPerformanceInsightsKMSKeyId()).append(",");
        }
        if (this.getPerformanceInsightsRetentionPeriod() != null) {
            sb.append("PerformanceInsightsRetentionPeriod: ").append(this.getPerformanceInsightsRetentionPeriod()).append(",");
        }
        if (this.getServerlessV2ScalingConfiguration() != null) {
            sb.append("ServerlessV2ScalingConfiguration: ").append(this.getServerlessV2ScalingConfiguration()).append(",");
        }
        if (this.getNetworkType() != null) {
            sb.append("NetworkType: ").append(this.getNetworkType()).append(",");
        }
        if (this.getDBSystemId() != null) {
            sb.append("DBSystemId: ").append(this.getDBSystemId()).append(",");
        }
        if (this.getMasterUserSecret() != null) {
            sb.append("MasterUserSecret: ").append(this.getMasterUserSecret()).append(",");
        }
        if (this.getIOOptimizedNextAllowedModificationTime() != null) {
            sb.append("IOOptimizedNextAllowedModificationTime: ").append(this.getIOOptimizedNextAllowedModificationTime()).append(",");
        }
        if (this.getLocalWriteForwardingStatus() != null) {
            sb.append("LocalWriteForwardingStatus: ").append(this.getLocalWriteForwardingStatus()).append(",");
        }
        if (this.getAwsBackupRecoveryPointArn() != null) {
            sb.append("AwsBackupRecoveryPointArn: ").append(this.getAwsBackupRecoveryPointArn()).append(",");
        }
        if (this.getLimitlessDatabase() != null) {
            sb.append("LimitlessDatabase: ").append(this.getLimitlessDatabase());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster)obj;
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getCharacterSetName() == null ^ this.getCharacterSetName() == null) {
            return false;
        }
        if (other.getCharacterSetName() != null && !other.getCharacterSetName().equals(this.getCharacterSetName())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getDBClusterParameterGroup() == null ^ this.getDBClusterParameterGroup() == null) {
            return false;
        }
        if (other.getDBClusterParameterGroup() != null && !other.getDBClusterParameterGroup().equals(this.getDBClusterParameterGroup())) {
            return false;
        }
        if (other.getDBSubnetGroup() == null ^ this.getDBSubnetGroup() == null) {
            return false;
        }
        if (other.getDBSubnetGroup() != null && !other.getDBSubnetGroup().equals(this.getDBSubnetGroup())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAutomaticRestartTime() == null ^ this.getAutomaticRestartTime() == null) {
            return false;
        }
        if (other.getAutomaticRestartTime() != null && !other.getAutomaticRestartTime().equals(this.getAutomaticRestartTime())) {
            return false;
        }
        if (other.getPercentProgress() == null ^ this.getPercentProgress() == null) {
            return false;
        }
        if (other.getPercentProgress() != null && !other.getPercentProgress().equals(this.getPercentProgress())) {
            return false;
        }
        if (other.getEarliestRestorableTime() == null ^ this.getEarliestRestorableTime() == null) {
            return false;
        }
        if (other.getEarliestRestorableTime() != null && !other.getEarliestRestorableTime().equals(this.getEarliestRestorableTime())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getReaderEndpoint() == null ^ this.getReaderEndpoint() == null) {
            return false;
        }
        if (other.getReaderEndpoint() != null && !other.getReaderEndpoint().equals(this.getReaderEndpoint())) {
            return false;
        }
        if (other.getCustomEndpoints() == null ^ this.getCustomEndpoints() == null) {
            return false;
        }
        if (other.getCustomEndpoints() != null && !other.getCustomEndpoints().equals(this.getCustomEndpoints())) {
            return false;
        }
        if (other.getMultiAZ() == null ^ this.getMultiAZ() == null) {
            return false;
        }
        if (other.getMultiAZ() != null && !other.getMultiAZ().equals(this.getMultiAZ())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getLatestRestorableTime() == null ^ this.getLatestRestorableTime() == null) {
            return false;
        }
        if (other.getLatestRestorableTime() != null && !other.getLatestRestorableTime().equals(this.getLatestRestorableTime())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getDBClusterOptionGroupMemberships() == null ^ this.getDBClusterOptionGroupMemberships() == null) {
            return false;
        }
        if (other.getDBClusterOptionGroupMemberships() != null && !other.getDBClusterOptionGroupMemberships().equals(this.getDBClusterOptionGroupMemberships())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getReplicationSourceIdentifier() == null ^ this.getReplicationSourceIdentifier() == null) {
            return false;
        }
        if (other.getReplicationSourceIdentifier() != null && !other.getReplicationSourceIdentifier().equals(this.getReplicationSourceIdentifier())) {
            return false;
        }
        if (other.getReadReplicaIdentifiers() == null ^ this.getReadReplicaIdentifiers() == null) {
            return false;
        }
        if (other.getReadReplicaIdentifiers() != null && !other.getReadReplicaIdentifiers().equals(this.getReadReplicaIdentifiers())) {
            return false;
        }
        if (other.getStatusInfos() == null ^ this.getStatusInfos() == null) {
            return false;
        }
        if (other.getStatusInfos() != null && !other.getStatusInfos().equals(this.getStatusInfos())) {
            return false;
        }
        if (other.getDBClusterMembers() == null ^ this.getDBClusterMembers() == null) {
            return false;
        }
        if (other.getDBClusterMembers() != null && !other.getDBClusterMembers().equals(this.getDBClusterMembers())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getHostedZoneId() == null ^ this.getHostedZoneId() == null) {
            return false;
        }
        if (other.getHostedZoneId() != null && !other.getHostedZoneId().equals(this.getHostedZoneId())) {
            return false;
        }
        if (other.getStorageEncrypted() == null ^ this.getStorageEncrypted() == null) {
            return false;
        }
        if (other.getStorageEncrypted() != null && !other.getStorageEncrypted().equals(this.getStorageEncrypted())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getDbClusterResourceId() == null ^ this.getDbClusterResourceId() == null) {
            return false;
        }
        if (other.getDbClusterResourceId() != null && !other.getDbClusterResourceId().equals(this.getDbClusterResourceId())) {
            return false;
        }
        if (other.getDBClusterArn() == null ^ this.getDBClusterArn() == null) {
            return false;
        }
        if (other.getDBClusterArn() != null && !other.getDBClusterArn().equals(this.getDBClusterArn())) {
            return false;
        }
        if (other.getAssociatedRoles() == null ^ this.getAssociatedRoles() == null) {
            return false;
        }
        if (other.getAssociatedRoles() != null && !other.getAssociatedRoles().equals(this.getAssociatedRoles())) {
            return false;
        }
        if (other.getIAMDatabaseAuthenticationEnabled() == null ^ this.getIAMDatabaseAuthenticationEnabled() == null) {
            return false;
        }
        if (other.getIAMDatabaseAuthenticationEnabled() != null && !other.getIAMDatabaseAuthenticationEnabled().equals(this.getIAMDatabaseAuthenticationEnabled())) {
            return false;
        }
        if (other.getCloneGroupId() == null ^ this.getCloneGroupId() == null) {
            return false;
        }
        if (other.getCloneGroupId() != null && !other.getCloneGroupId().equals(this.getCloneGroupId())) {
            return false;
        }
        if (other.getClusterCreateTime() == null ^ this.getClusterCreateTime() == null) {
            return false;
        }
        if (other.getClusterCreateTime() != null && !other.getClusterCreateTime().equals(this.getClusterCreateTime())) {
            return false;
        }
        if (other.getEarliestBacktrackTime() == null ^ this.getEarliestBacktrackTime() == null) {
            return false;
        }
        if (other.getEarliestBacktrackTime() != null && !other.getEarliestBacktrackTime().equals(this.getEarliestBacktrackTime())) {
            return false;
        }
        if (other.getBacktrackWindow() == null ^ this.getBacktrackWindow() == null) {
            return false;
        }
        if (other.getBacktrackWindow() != null && !other.getBacktrackWindow().equals(this.getBacktrackWindow())) {
            return false;
        }
        if (other.getBacktrackConsumedChangeRecords() == null ^ this.getBacktrackConsumedChangeRecords() == null) {
            return false;
        }
        if (other.getBacktrackConsumedChangeRecords() != null && !other.getBacktrackConsumedChangeRecords().equals(this.getBacktrackConsumedChangeRecords())) {
            return false;
        }
        if (other.getEnabledCloudwatchLogsExports() == null ^ this.getEnabledCloudwatchLogsExports() == null) {
            return false;
        }
        if (other.getEnabledCloudwatchLogsExports() != null && !other.getEnabledCloudwatchLogsExports().equals(this.getEnabledCloudwatchLogsExports())) {
            return false;
        }
        if (other.getCapacity() == null ^ this.getCapacity() == null) {
            return false;
        }
        if (other.getCapacity() != null && !other.getCapacity().equals(this.getCapacity())) {
            return false;
        }
        if (other.getEngineMode() == null ^ this.getEngineMode() == null) {
            return false;
        }
        if (other.getEngineMode() != null && !other.getEngineMode().equals(this.getEngineMode())) {
            return false;
        }
        if (other.getScalingConfigurationInfo() == null ^ this.getScalingConfigurationInfo() == null) {
            return false;
        }
        if (other.getScalingConfigurationInfo() != null && !other.getScalingConfigurationInfo().equals(this.getScalingConfigurationInfo())) {
            return false;
        }
        if (other.getRdsCustomClusterConfiguration() == null ^ this.getRdsCustomClusterConfiguration() == null) {
            return false;
        }
        if (other.getRdsCustomClusterConfiguration() != null && !other.getRdsCustomClusterConfiguration().equals(this.getRdsCustomClusterConfiguration())) {
            return false;
        }
        if (other.getDeletionProtection() == null ^ this.getDeletionProtection() == null) {
            return false;
        }
        if (other.getDeletionProtection() != null && !other.getDeletionProtection().equals(this.getDeletionProtection())) {
            return false;
        }
        if (other.getHttpEndpointEnabled() == null ^ this.getHttpEndpointEnabled() == null) {
            return false;
        }
        if (other.getHttpEndpointEnabled() != null && !other.getHttpEndpointEnabled().equals(this.getHttpEndpointEnabled())) {
            return false;
        }
        if (other.getActivityStreamMode() == null ^ this.getActivityStreamMode() == null) {
            return false;
        }
        if (other.getActivityStreamMode() != null && !other.getActivityStreamMode().equals(this.getActivityStreamMode())) {
            return false;
        }
        if (other.getActivityStreamStatus() == null ^ this.getActivityStreamStatus() == null) {
            return false;
        }
        if (other.getActivityStreamStatus() != null && !other.getActivityStreamStatus().equals(this.getActivityStreamStatus())) {
            return false;
        }
        if (other.getActivityStreamKmsKeyId() == null ^ this.getActivityStreamKmsKeyId() == null) {
            return false;
        }
        if (other.getActivityStreamKmsKeyId() != null && !other.getActivityStreamKmsKeyId().equals(this.getActivityStreamKmsKeyId())) {
            return false;
        }
        if (other.getActivityStreamKinesisStreamName() == null ^ this.getActivityStreamKinesisStreamName() == null) {
            return false;
        }
        if (other.getActivityStreamKinesisStreamName() != null && !other.getActivityStreamKinesisStreamName().equals(this.getActivityStreamKinesisStreamName())) {
            return false;
        }
        if (other.getCopyTagsToSnapshot() == null ^ this.getCopyTagsToSnapshot() == null) {
            return false;
        }
        if (other.getCopyTagsToSnapshot() != null && !other.getCopyTagsToSnapshot().equals(this.getCopyTagsToSnapshot())) {
            return false;
        }
        if (other.getCrossAccountClone() == null ^ this.getCrossAccountClone() == null) {
            return false;
        }
        if (other.getCrossAccountClone() != null && !other.getCrossAccountClone().equals(this.getCrossAccountClone())) {
            return false;
        }
        if (other.getDomainMemberships() == null ^ this.getDomainMemberships() == null) {
            return false;
        }
        if (other.getDomainMemberships() != null && !other.getDomainMemberships().equals(this.getDomainMemberships())) {
            return false;
        }
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        if (other.getTagList() != null && !other.getTagList().equals(this.getTagList())) {
            return false;
        }
        if (other.getGlobalWriteForwardingStatus() == null ^ this.getGlobalWriteForwardingStatus() == null) {
            return false;
        }
        if (other.getGlobalWriteForwardingStatus() != null && !other.getGlobalWriteForwardingStatus().equals(this.getGlobalWriteForwardingStatus())) {
            return false;
        }
        if (other.getGlobalWriteForwardingRequested() == null ^ this.getGlobalWriteForwardingRequested() == null) {
            return false;
        }
        if (other.getGlobalWriteForwardingRequested() != null && !other.getGlobalWriteForwardingRequested().equals(this.getGlobalWriteForwardingRequested())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getDBClusterInstanceClass() == null ^ this.getDBClusterInstanceClass() == null) {
            return false;
        }
        if (other.getDBClusterInstanceClass() != null && !other.getDBClusterInstanceClass().equals(this.getDBClusterInstanceClass())) {
            return false;
        }
        if (other.getStorageType() == null ^ this.getStorageType() == null) {
            return false;
        }
        if (other.getStorageType() != null && !other.getStorageType().equals(this.getStorageType())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        if (other.getIops() != null && !other.getIops().equals(this.getIops())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() != null && !other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getMonitoringInterval() == null ^ this.getMonitoringInterval() == null) {
            return false;
        }
        if (other.getMonitoringInterval() != null && !other.getMonitoringInterval().equals(this.getMonitoringInterval())) {
            return false;
        }
        if (other.getMonitoringRoleArn() == null ^ this.getMonitoringRoleArn() == null) {
            return false;
        }
        if (other.getMonitoringRoleArn() != null && !other.getMonitoringRoleArn().equals(this.getMonitoringRoleArn())) {
            return false;
        }
        if (other.getPerformanceInsightsEnabled() == null ^ this.getPerformanceInsightsEnabled() == null) {
            return false;
        }
        if (other.getPerformanceInsightsEnabled() != null && !other.getPerformanceInsightsEnabled().equals(this.getPerformanceInsightsEnabled())) {
            return false;
        }
        if (other.getPerformanceInsightsKMSKeyId() == null ^ this.getPerformanceInsightsKMSKeyId() == null) {
            return false;
        }
        if (other.getPerformanceInsightsKMSKeyId() != null && !other.getPerformanceInsightsKMSKeyId().equals(this.getPerformanceInsightsKMSKeyId())) {
            return false;
        }
        if (other.getPerformanceInsightsRetentionPeriod() == null ^ this.getPerformanceInsightsRetentionPeriod() == null) {
            return false;
        }
        if (other.getPerformanceInsightsRetentionPeriod() != null && !other.getPerformanceInsightsRetentionPeriod().equals(this.getPerformanceInsightsRetentionPeriod())) {
            return false;
        }
        if (other.getServerlessV2ScalingConfiguration() == null ^ this.getServerlessV2ScalingConfiguration() == null) {
            return false;
        }
        if (other.getServerlessV2ScalingConfiguration() != null && !other.getServerlessV2ScalingConfiguration().equals(this.getServerlessV2ScalingConfiguration())) {
            return false;
        }
        if (other.getNetworkType() == null ^ this.getNetworkType() == null) {
            return false;
        }
        if (other.getNetworkType() != null && !other.getNetworkType().equals(this.getNetworkType())) {
            return false;
        }
        if (other.getDBSystemId() == null ^ this.getDBSystemId() == null) {
            return false;
        }
        if (other.getDBSystemId() != null && !other.getDBSystemId().equals(this.getDBSystemId())) {
            return false;
        }
        if (other.getMasterUserSecret() == null ^ this.getMasterUserSecret() == null) {
            return false;
        }
        if (other.getMasterUserSecret() != null && !other.getMasterUserSecret().equals(this.getMasterUserSecret())) {
            return false;
        }
        if (other.getIOOptimizedNextAllowedModificationTime() == null ^ this.getIOOptimizedNextAllowedModificationTime() == null) {
            return false;
        }
        if (other.getIOOptimizedNextAllowedModificationTime() != null && !other.getIOOptimizedNextAllowedModificationTime().equals(this.getIOOptimizedNextAllowedModificationTime())) {
            return false;
        }
        if (other.getLocalWriteForwardingStatus() == null ^ this.getLocalWriteForwardingStatus() == null) {
            return false;
        }
        if (other.getLocalWriteForwardingStatus() != null && !other.getLocalWriteForwardingStatus().equals(this.getLocalWriteForwardingStatus())) {
            return false;
        }
        if (other.getAwsBackupRecoveryPointArn() == null ^ this.getAwsBackupRecoveryPointArn() == null) {
            return false;
        }
        if (other.getAwsBackupRecoveryPointArn() != null && !other.getAwsBackupRecoveryPointArn().equals(this.getAwsBackupRecoveryPointArn())) {
            return false;
        }
        if (other.getLimitlessDatabase() == null ^ this.getLimitlessDatabase() == null) {
            return false;
        }
        return other.getLimitlessDatabase() == null || other.getLimitlessDatabase().equals(this.getLimitlessDatabase());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getCharacterSetName() == null ? 0 : this.getCharacterSetName().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterParameterGroup() == null ? 0 : this.getDBClusterParameterGroup().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroup() == null ? 0 : this.getDBSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAutomaticRestartTime() == null ? 0 : this.getAutomaticRestartTime().hashCode());
        hashCode = 31 * hashCode + (this.getPercentProgress() == null ? 0 : this.getPercentProgress().hashCode());
        hashCode = 31 * hashCode + (this.getEarliestRestorableTime() == null ? 0 : this.getEarliestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getReaderEndpoint() == null ? 0 : this.getReaderEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getCustomEndpoints() == null ? 0 : this.getCustomEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getMultiAZ() == null ? 0 : this.getMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLatestRestorableTime() == null ? 0 : this.getLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterOptionGroupMemberships() == null ? 0 : this.getDBClusterOptionGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationSourceIdentifier() == null ? 0 : this.getReplicationSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaIdentifiers() == null ? 0 : this.getReadReplicaIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getStatusInfos() == null ? 0 : this.getStatusInfos().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterMembers() == null ? 0 : this.getDBClusterMembers().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getHostedZoneId() == null ? 0 : this.getHostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.getStorageEncrypted() == null ? 0 : this.getStorageEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getDbClusterResourceId() == null ? 0 : this.getDbClusterResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterArn() == null ? 0 : this.getDBClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedRoles() == null ? 0 : this.getAssociatedRoles().hashCode());
        hashCode = 31 * hashCode + (this.getIAMDatabaseAuthenticationEnabled() == null ? 0 : this.getIAMDatabaseAuthenticationEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getCloneGroupId() == null ? 0 : this.getCloneGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getClusterCreateTime() == null ? 0 : this.getClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getEarliestBacktrackTime() == null ? 0 : this.getEarliestBacktrackTime().hashCode());
        hashCode = 31 * hashCode + (this.getBacktrackWindow() == null ? 0 : this.getBacktrackWindow().hashCode());
        hashCode = 31 * hashCode + (this.getBacktrackConsumedChangeRecords() == null ? 0 : this.getBacktrackConsumedChangeRecords().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledCloudwatchLogsExports() == null ? 0 : this.getEnabledCloudwatchLogsExports().hashCode());
        hashCode = 31 * hashCode + (this.getCapacity() == null ? 0 : this.getCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getEngineMode() == null ? 0 : this.getEngineMode().hashCode());
        hashCode = 31 * hashCode + (this.getScalingConfigurationInfo() == null ? 0 : this.getScalingConfigurationInfo().hashCode());
        hashCode = 31 * hashCode + (this.getRdsCustomClusterConfiguration() == null ? 0 : this.getRdsCustomClusterConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeletionProtection() == null ? 0 : this.getDeletionProtection().hashCode());
        hashCode = 31 * hashCode + (this.getHttpEndpointEnabled() == null ? 0 : this.getHttpEndpointEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamMode() == null ? 0 : this.getActivityStreamMode().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamStatus() == null ? 0 : this.getActivityStreamStatus().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamKmsKeyId() == null ? 0 : this.getActivityStreamKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamKinesisStreamName() == null ? 0 : this.getActivityStreamKinesisStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToSnapshot() == null ? 0 : this.getCopyTagsToSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.getCrossAccountClone() == null ? 0 : this.getCrossAccountClone().hashCode());
        hashCode = 31 * hashCode + (this.getDomainMemberships() == null ? 0 : this.getDomainMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : this.getTagList().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalWriteForwardingStatus() == null ? 0 : this.getGlobalWriteForwardingStatus().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalWriteForwardingRequested() == null ? 0 : this.getGlobalWriteForwardingRequested().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterInstanceClass() == null ? 0 : this.getDBClusterInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getStorageType() == null ? 0 : this.getStorageType().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringInterval() == null ? 0 : this.getMonitoringInterval().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringRoleArn() == null ? 0 : this.getMonitoringRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceInsightsEnabled() == null ? 0 : this.getPerformanceInsightsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceInsightsKMSKeyId() == null ? 0 : this.getPerformanceInsightsKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceInsightsRetentionPeriod() == null ? 0 : this.getPerformanceInsightsRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getServerlessV2ScalingConfiguration() == null ? 0 : this.getServerlessV2ScalingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkType() == null ? 0 : this.getNetworkType().hashCode());
        hashCode = 31 * hashCode + (this.getDBSystemId() == null ? 0 : this.getDBSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUserSecret() == null ? 0 : this.getMasterUserSecret().hashCode());
        hashCode = 31 * hashCode + (this.getIOOptimizedNextAllowedModificationTime() == null ? 0 : this.getIOOptimizedNextAllowedModificationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLocalWriteForwardingStatus() == null ? 0 : this.getLocalWriteForwardingStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAwsBackupRecoveryPointArn() == null ? 0 : this.getAwsBackupRecoveryPointArn().hashCode());
        hashCode = 31 * hashCode + (this.getLimitlessDatabase() == null ? 0 : this.getLimitlessDatabase().hashCode());
        return hashCode;
    }

    public DBCluster clone() {
        try {
            return (DBCluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

