/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Option;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class OptionGroup
implements Serializable,
Cloneable {
    private String optionGroupName;
    private String optionGroupDescription;
    private String engineName;
    private String majorEngineVersion;
    private SdkInternalList<Option> options;
    private Boolean allowsVpcAndNonVpcInstanceMemberships;
    private String vpcId;
    private String optionGroupArn;
    private String sourceOptionGroup;
    private String sourceAccountId;
    private Date copyTimestamp;

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public OptionGroup withOptionGroupName(String optionGroupName) {
        this.setOptionGroupName(optionGroupName);
        return this;
    }

    public void setOptionGroupDescription(String optionGroupDescription) {
        this.optionGroupDescription = optionGroupDescription;
    }

    public String getOptionGroupDescription() {
        return this.optionGroupDescription;
    }

    public OptionGroup withOptionGroupDescription(String optionGroupDescription) {
        this.setOptionGroupDescription(optionGroupDescription);
        return this;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public OptionGroup withEngineName(String engineName) {
        this.setEngineName(engineName);
        return this;
    }

    public void setMajorEngineVersion(String majorEngineVersion) {
        this.majorEngineVersion = majorEngineVersion;
    }

    public String getMajorEngineVersion() {
        return this.majorEngineVersion;
    }

    public OptionGroup withMajorEngineVersion(String majorEngineVersion) {
        this.setMajorEngineVersion(majorEngineVersion);
        return this;
    }

    public List<Option> getOptions() {
        if (this.options == null) {
            this.options = new SdkInternalList();
        }
        return this.options;
    }

    public void setOptions(Collection<Option> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        this.options = new SdkInternalList(options);
    }

    public OptionGroup withOptions(Option ... options) {
        if (this.options == null) {
            this.setOptions((Collection<Option>)new SdkInternalList(options.length));
        }
        for (Option ele : options) {
            this.options.add((Object)ele);
        }
        return this;
    }

    public OptionGroup withOptions(Collection<Option> options) {
        this.setOptions(options);
        return this;
    }

    public void setAllowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
        this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
    }

    public Boolean getAllowsVpcAndNonVpcInstanceMemberships() {
        return this.allowsVpcAndNonVpcInstanceMemberships;
    }

    public OptionGroup withAllowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
        this.setAllowsVpcAndNonVpcInstanceMemberships(allowsVpcAndNonVpcInstanceMemberships);
        return this;
    }

    public Boolean isAllowsVpcAndNonVpcInstanceMemberships() {
        return this.allowsVpcAndNonVpcInstanceMemberships;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public OptionGroup withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setOptionGroupArn(String optionGroupArn) {
        this.optionGroupArn = optionGroupArn;
    }

    public String getOptionGroupArn() {
        return this.optionGroupArn;
    }

    public OptionGroup withOptionGroupArn(String optionGroupArn) {
        this.setOptionGroupArn(optionGroupArn);
        return this;
    }

    public void setSourceOptionGroup(String sourceOptionGroup) {
        this.sourceOptionGroup = sourceOptionGroup;
    }

    public String getSourceOptionGroup() {
        return this.sourceOptionGroup;
    }

    public OptionGroup withSourceOptionGroup(String sourceOptionGroup) {
        this.setSourceOptionGroup(sourceOptionGroup);
        return this;
    }

    public void setSourceAccountId(String sourceAccountId) {
        this.sourceAccountId = sourceAccountId;
    }

    public String getSourceAccountId() {
        return this.sourceAccountId;
    }

    public OptionGroup withSourceAccountId(String sourceAccountId) {
        this.setSourceAccountId(sourceAccountId);
        return this;
    }

    public void setCopyTimestamp(Date copyTimestamp) {
        this.copyTimestamp = copyTimestamp;
    }

    public Date getCopyTimestamp() {
        return this.copyTimestamp;
    }

    public OptionGroup withCopyTimestamp(Date copyTimestamp) {
        this.setCopyTimestamp(copyTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.getOptionGroupName()).append(",");
        }
        if (this.getOptionGroupDescription() != null) {
            sb.append("OptionGroupDescription: ").append(this.getOptionGroupDescription()).append(",");
        }
        if (this.getEngineName() != null) {
            sb.append("EngineName: ").append(this.getEngineName()).append(",");
        }
        if (this.getMajorEngineVersion() != null) {
            sb.append("MajorEngineVersion: ").append(this.getMajorEngineVersion()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions()).append(",");
        }
        if (this.getAllowsVpcAndNonVpcInstanceMemberships() != null) {
            sb.append("AllowsVpcAndNonVpcInstanceMemberships: ").append(this.getAllowsVpcAndNonVpcInstanceMemberships()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getOptionGroupArn() != null) {
            sb.append("OptionGroupArn: ").append(this.getOptionGroupArn()).append(",");
        }
        if (this.getSourceOptionGroup() != null) {
            sb.append("SourceOptionGroup: ").append(this.getSourceOptionGroup()).append(",");
        }
        if (this.getSourceAccountId() != null) {
            sb.append("SourceAccountId: ").append(this.getSourceAccountId()).append(",");
        }
        if (this.getCopyTimestamp() != null) {
            sb.append("CopyTimestamp: ").append(this.getCopyTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroup)) {
            return false;
        }
        OptionGroup other = (OptionGroup)obj;
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.getOptionGroupDescription() == null ^ this.getOptionGroupDescription() == null) {
            return false;
        }
        if (other.getOptionGroupDescription() != null && !other.getOptionGroupDescription().equals(this.getOptionGroupDescription())) {
            return false;
        }
        if (other.getEngineName() == null ^ this.getEngineName() == null) {
            return false;
        }
        if (other.getEngineName() != null && !other.getEngineName().equals(this.getEngineName())) {
            return false;
        }
        if (other.getMajorEngineVersion() == null ^ this.getMajorEngineVersion() == null) {
            return false;
        }
        if (other.getMajorEngineVersion() != null && !other.getMajorEngineVersion().equals(this.getMajorEngineVersion())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        if (other.getOptions() != null && !other.getOptions().equals(this.getOptions())) {
            return false;
        }
        if (other.getAllowsVpcAndNonVpcInstanceMemberships() == null ^ this.getAllowsVpcAndNonVpcInstanceMemberships() == null) {
            return false;
        }
        if (other.getAllowsVpcAndNonVpcInstanceMemberships() != null && !other.getAllowsVpcAndNonVpcInstanceMemberships().equals(this.getAllowsVpcAndNonVpcInstanceMemberships())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getOptionGroupArn() == null ^ this.getOptionGroupArn() == null) {
            return false;
        }
        if (other.getOptionGroupArn() != null && !other.getOptionGroupArn().equals(this.getOptionGroupArn())) {
            return false;
        }
        if (other.getSourceOptionGroup() == null ^ this.getSourceOptionGroup() == null) {
            return false;
        }
        if (other.getSourceOptionGroup() != null && !other.getSourceOptionGroup().equals(this.getSourceOptionGroup())) {
            return false;
        }
        if (other.getSourceAccountId() == null ^ this.getSourceAccountId() == null) {
            return false;
        }
        if (other.getSourceAccountId() != null && !other.getSourceAccountId().equals(this.getSourceAccountId())) {
            return false;
        }
        if (other.getCopyTimestamp() == null ^ this.getCopyTimestamp() == null) {
            return false;
        }
        return other.getCopyTimestamp() == null || other.getCopyTimestamp().equals(this.getCopyTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupDescription() == null ? 0 : this.getOptionGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEngineName() == null ? 0 : this.getEngineName().hashCode());
        hashCode = 31 * hashCode + (this.getMajorEngineVersion() == null ? 0 : this.getMajorEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        hashCode = 31 * hashCode + (this.getAllowsVpcAndNonVpcInstanceMemberships() == null ? 0 : this.getAllowsVpcAndNonVpcInstanceMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupArn() == null ? 0 : this.getOptionGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getSourceOptionGroup() == null ? 0 : this.getSourceOptionGroup().hashCode());
        hashCode = 31 * hashCode + (this.getSourceAccountId() == null ? 0 : this.getSourceAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTimestamp() == null ? 0 : this.getCopyTimestamp().hashCode());
        return hashCode;
    }

    public OptionGroup clone() {
        try {
            return (OptionGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

