/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.ConnectionPoolConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ConnectionPoolConfigurationStaxUnmarshaller
implements Unmarshaller<ConnectionPoolConfiguration, StaxUnmarshallerContext> {
    private static ConnectionPoolConfigurationStaxUnmarshaller instance;

    public ConnectionPoolConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConnectionPoolConfiguration connectionPoolConfiguration = new ConnectionPoolConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return connectionPoolConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MaxConnectionsPercent", targetDepth)) {
                    connectionPoolConfiguration.setMaxConnectionsPercent(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxIdleConnectionsPercent", targetDepth)) {
                    connectionPoolConfiguration.setMaxIdleConnectionsPercent(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConnectionBorrowTimeout", targetDepth)) {
                    connectionPoolConfiguration.setConnectionBorrowTimeout(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SessionPinningFilters", targetDepth)) {
                    connectionPoolConfiguration.withSessionPinningFilters(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SessionPinningFilters/member", targetDepth)) {
                    connectionPoolConfiguration.withSessionPinningFilters(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("InitQuery", targetDepth)) continue;
                connectionPoolConfiguration.setInitQuery(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return connectionPoolConfiguration;
    }

    public static ConnectionPoolConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConnectionPoolConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

