/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.ContextAttribute;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ContextAttributeStaxUnmarshaller
implements Unmarshaller<ContextAttribute, StaxUnmarshallerContext> {
    private static ContextAttributeStaxUnmarshaller instance;

    public ContextAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        ContextAttribute contextAttribute = new ContextAttribute();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return contextAttribute;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Key", targetDepth)) {
                    contextAttribute.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                contextAttribute.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return contextAttribute;
    }

    public static ContextAttributeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ContextAttributeStaxUnmarshaller();
        }
        return instance;
    }
}

