/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ModifyDBProxyRequest;
import com.amazonaws.services.rds.model.UserAuthConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBProxyRequestMarshaller
implements Marshaller<Request<ModifyDBProxyRequest>, ModifyDBProxyRequest> {
    public Request<ModifyDBProxyRequest> marshall(ModifyDBProxyRequest modifyDBProxyRequest) {
        if (modifyDBProxyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBProxyRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBProxy");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBProxyRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)modifyDBProxyRequest.getDBProxyName()));
        }
        if (modifyDBProxyRequest.getNewDBProxyName() != null) {
            request.addParameter("NewDBProxyName", StringUtils.fromString((String)modifyDBProxyRequest.getNewDBProxyName()));
        }
        if (!modifyDBProxyRequest.getAuth().isEmpty() || !((SdkInternalList)modifyDBProxyRequest.getAuth()).isAutoConstruct()) {
            SdkInternalList authList = (SdkInternalList)modifyDBProxyRequest.getAuth();
            int authListIndex = 1;
            for (UserAuthConfig authListValue : authList) {
                if (authListValue != null) {
                    if (authListValue.getDescription() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".Description", StringUtils.fromString((String)authListValue.getDescription()));
                    }
                    if (authListValue.getUserName() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".UserName", StringUtils.fromString((String)authListValue.getUserName()));
                    }
                    if (authListValue.getAuthScheme() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".AuthScheme", StringUtils.fromString((String)authListValue.getAuthScheme()));
                    }
                    if (authListValue.getSecretArn() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".SecretArn", StringUtils.fromString((String)authListValue.getSecretArn()));
                    }
                    if (authListValue.getIAMAuth() != null) {
                        request.addParameter("Auth.member." + authListIndex + ".IAMAuth", StringUtils.fromString((String)authListValue.getIAMAuth()));
                    }
                }
                ++authListIndex;
            }
        }
        if (modifyDBProxyRequest.getRequireTLS() != null) {
            request.addParameter("RequireTLS", StringUtils.fromBoolean((Boolean)modifyDBProxyRequest.getRequireTLS()));
        }
        if (modifyDBProxyRequest.getIdleClientTimeout() != null) {
            request.addParameter("IdleClientTimeout", StringUtils.fromInteger((Integer)modifyDBProxyRequest.getIdleClientTimeout()));
        }
        if (modifyDBProxyRequest.getDebugLogging() != null) {
            request.addParameter("DebugLogging", StringUtils.fromBoolean((Boolean)modifyDBProxyRequest.getDebugLogging()));
        }
        if (modifyDBProxyRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)modifyDBProxyRequest.getRoleArn()));
        }
        if (!modifyDBProxyRequest.getSecurityGroups().isEmpty() || !((SdkInternalList)modifyDBProxyRequest.getSecurityGroups()).isAutoConstruct()) {
            SdkInternalList securityGroupsList = (SdkInternalList)modifyDBProxyRequest.getSecurityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        return request;
    }
}

