/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.rdsdata.AWSRDSData;
import com.amazonaws.services.rdsdata.AWSRDSDataClientBuilder;
import com.amazonaws.services.rdsdata.model.AWSRDSDataException;
import com.amazonaws.services.rdsdata.model.BatchExecuteStatementRequest;
import com.amazonaws.services.rdsdata.model.BatchExecuteStatementResult;
import com.amazonaws.services.rdsdata.model.BeginTransactionRequest;
import com.amazonaws.services.rdsdata.model.BeginTransactionResult;
import com.amazonaws.services.rdsdata.model.CommitTransactionRequest;
import com.amazonaws.services.rdsdata.model.CommitTransactionResult;
import com.amazonaws.services.rdsdata.model.ExecuteSqlRequest;
import com.amazonaws.services.rdsdata.model.ExecuteSqlResult;
import com.amazonaws.services.rdsdata.model.ExecuteStatementRequest;
import com.amazonaws.services.rdsdata.model.ExecuteStatementResult;
import com.amazonaws.services.rdsdata.model.RollbackTransactionRequest;
import com.amazonaws.services.rdsdata.model.RollbackTransactionResult;
import com.amazonaws.services.rdsdata.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.BatchExecuteStatementRequestProtocolMarshaller;
import com.amazonaws.services.rdsdata.model.transform.BatchExecuteStatementResultJsonUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.BeginTransactionRequestProtocolMarshaller;
import com.amazonaws.services.rdsdata.model.transform.BeginTransactionResultJsonUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.CommitTransactionRequestProtocolMarshaller;
import com.amazonaws.services.rdsdata.model.transform.CommitTransactionResultJsonUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.ExecuteSqlRequestProtocolMarshaller;
import com.amazonaws.services.rdsdata.model.transform.ExecuteSqlResultJsonUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.ExecuteStatementRequestProtocolMarshaller;
import com.amazonaws.services.rdsdata.model.transform.ExecuteStatementResultJsonUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.RollbackTransactionRequestProtocolMarshaller;
import com.amazonaws.services.rdsdata.model.transform.RollbackTransactionResultJsonUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.ServiceUnavailableErrorExceptionUnmarshaller;
import com.amazonaws.services.rdsdata.model.transform.StatementTimeoutExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSRDSDataClient
extends AmazonWebServiceClient
implements AWSRDSData {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSRDSData.class);
    private static final String DEFAULT_SIGNING_NAME = "rds-data";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableError").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StatementTimeoutException").withExceptionUnmarshaller((JsonErrorUnmarshaller)StatementTimeoutExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSRDSDataException.class));

    public static AWSRDSDataClientBuilder builder() {
        return AWSRDSDataClientBuilder.standard();
    }

    AWSRDSDataClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSRDSDataClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("rds-data.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/rdsdata/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/rdsdata/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchExecuteStatementResult batchExecuteStatement(BatchExecuteStatementRequest request) {
        request = (BatchExecuteStatementRequest)this.beforeClientExecution(request);
        return this.executeBatchExecuteStatement(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchExecuteStatementResult executeBatchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchExecuteStatementRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchExecuteStatementRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchExecuteStatementRequestProtocolMarshaller(protocolFactory).marshall((BatchExecuteStatementRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchExecuteStatementRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RDS Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchExecuteStatement");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchExecuteStatementResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchExecuteStatementResult batchExecuteStatementResult = (BatchExecuteStatementResult)response.getAwsResponse();
            return batchExecuteStatementResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BeginTransactionResult beginTransaction(BeginTransactionRequest request) {
        request = (BeginTransactionRequest)this.beforeClientExecution(request);
        return this.executeBeginTransaction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BeginTransactionResult executeBeginTransaction(BeginTransactionRequest beginTransactionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(beginTransactionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BeginTransactionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BeginTransactionRequestProtocolMarshaller(protocolFactory).marshall((BeginTransactionRequest)super.beforeMarshalling((AmazonWebServiceRequest)beginTransactionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RDS Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BeginTransaction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BeginTransactionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BeginTransactionResult beginTransactionResult = (BeginTransactionResult)response.getAwsResponse();
            return beginTransactionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CommitTransactionResult commitTransaction(CommitTransactionRequest request) {
        request = (CommitTransactionRequest)this.beforeClientExecution(request);
        return this.executeCommitTransaction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CommitTransactionResult executeCommitTransaction(CommitTransactionRequest commitTransactionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(commitTransactionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CommitTransactionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CommitTransactionRequestProtocolMarshaller(protocolFactory).marshall((CommitTransactionRequest)super.beforeMarshalling((AmazonWebServiceRequest)commitTransactionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RDS Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CommitTransaction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CommitTransactionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CommitTransactionResult commitTransactionResult = (CommitTransactionResult)response.getAwsResponse();
            return commitTransactionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    @Deprecated
    public ExecuteSqlResult executeSql(ExecuteSqlRequest request) {
        request = (ExecuteSqlRequest)this.beforeClientExecution(request);
        return this.executeExecuteSql(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExecuteSqlResult executeExecuteSql(ExecuteSqlRequest executeSqlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(executeSqlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExecuteSqlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExecuteSqlRequestProtocolMarshaller(protocolFactory).marshall((ExecuteSqlRequest)super.beforeMarshalling((AmazonWebServiceRequest)executeSqlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RDS Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExecuteSql");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExecuteSqlResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExecuteSqlResult executeSqlResult = (ExecuteSqlResult)response.getAwsResponse();
            return executeSqlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExecuteStatementResult executeStatement(ExecuteStatementRequest request) {
        request = (ExecuteStatementRequest)this.beforeClientExecution(request);
        return this.executeExecuteStatement(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExecuteStatementResult executeExecuteStatement(ExecuteStatementRequest executeStatementRequest) {
        ExecutionContext executionContext = this.createExecutionContext(executeStatementRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExecuteStatementRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExecuteStatementRequestProtocolMarshaller(protocolFactory).marshall((ExecuteStatementRequest)super.beforeMarshalling((AmazonWebServiceRequest)executeStatementRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RDS Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExecuteStatement");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExecuteStatementResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExecuteStatementResult executeStatementResult = (ExecuteStatementResult)response.getAwsResponse();
            return executeStatementResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RollbackTransactionResult rollbackTransaction(RollbackTransactionRequest request) {
        request = (RollbackTransactionRequest)this.beforeClientExecution(request);
        return this.executeRollbackTransaction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RollbackTransactionResult executeRollbackTransaction(RollbackTransactionRequest rollbackTransactionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rollbackTransactionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RollbackTransactionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RollbackTransactionRequestProtocolMarshaller(protocolFactory).marshall((RollbackTransactionRequest)super.beforeMarshalling((AmazonWebServiceRequest)rollbackTransactionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RDS Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RollbackTransaction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RollbackTransactionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RollbackTransactionResult rollbackTransactionResult = (RollbackTransactionResult)response.getAwsResponse();
            return rollbackTransactionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

