/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rdsdata.model.transform;

import java.math.*;
import java.nio.ByteBuffer;
import javax.annotation.Generated;

import com.amazonaws.services.rdsdata.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Value JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ValueJsonUnmarshaller implements Unmarshaller<Value, JsonUnmarshallerContext> {

    public Value unmarshall(JsonUnmarshallerContext context) throws Exception {
        Value value = new Value();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("isNull", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setIsNull(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("bitValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setBitValue(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("bigIntValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setBigIntValue(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("intValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setIntValue(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("doubleValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setDoubleValue(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("realValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setRealValue(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("stringValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setStringValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("blobValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setBlobValue(context.getUnmarshaller(java.nio.ByteBuffer.class).unmarshall(context));
                }
                if (context.testExpression("arrayValues", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setArrayValues(new ListUnmarshaller<Value>(ValueJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("structValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    value.setStructValue(StructValueJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return value;
    }

    private static ValueJsonUnmarshaller instance;

    public static ValueJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new ValueJsonUnmarshaller();
        return instance;
    }
}
