/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * <fullname>RDS Data API</fullname>
 * <p>
 * Amazon RDS provides an HTTP endpoint to run SQL statements on an Amazon Aurora DB cluster. To run these statements,
 * you use the RDS Data API (Data API).
 * </p>
 * <p>
 * Data API is available with the following types of Aurora databases:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Aurora PostgreSQL - Serverless v2, Serverless v1, and provisioned
 * </p>
 * </li>
 * <li>
 * <p>
 * Aurora MySQL - Serverless v1 only
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about the Data API, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the
 * <i>Amazon Aurora User Guide</i>.
 * </p>
 * </p>
 */
package com.amazonaws.services.rdsdata;

