/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in compliance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.redshift.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p/>
 */
public class DescribeEventSubscriptionsRequest extends AmazonWebServiceRequest
        implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the Amazon Redshift event notification subscription to be
     * described.
     * </p>
     */
    private String subscriptionName;
    /**
     * <p>
     * The maximum number of response records to return in each call. If the
     * number of remaining response records exceeds the specified
     * <code>MaxRecords</code> value, a value is returned in a
     * <code>marker</code> field of the response. You can retrieve the next set
     * of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     */
    private Integer maxRecords;
    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set
     * of response records. When the results of a
     * <a>DescribeEventSubscriptions</a> request exceed the value specified in
     * <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code>
     * field of the response. You can retrieve the next set of response records
     * by providing the returned marker value in the <code>Marker</code>
     * parameter and retrying the request.
     * </p>
     */
    private String marker;

    /**
     * <p>
     * The name of the Amazon Redshift event notification subscription to be
     * described.
     * </p>
     * 
     * @param subscriptionName
     *        The name of the Amazon Redshift event notification subscription to
     *        be described.
     */

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    /**
     * <p>
     * The name of the Amazon Redshift event notification subscription to be
     * described.
     * </p>
     * 
     * @return The name of the Amazon Redshift event notification subscription
     *         to be described.
     */

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    /**
     * <p>
     * The name of the Amazon Redshift event notification subscription to be
     * described.
     * </p>
     * 
     * @param subscriptionName
     *        The name of the Amazon Redshift event notification subscription to
     *        be described.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeEventSubscriptionsRequest withSubscriptionName(
            String subscriptionName) {
        setSubscriptionName(subscriptionName);
        return this;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the
     * number of remaining response records exceeds the specified
     * <code>MaxRecords</code> value, a value is returned in a
     * <code>marker</code> field of the response. You can retrieve the next set
     * of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @param maxRecords
     *        The maximum number of response records to return in each call. If
     *        the number of remaining response records exceeds the specified
     *        <code>MaxRecords</code> value, a value is returned in a
     *        <code>marker</code> field of the response. You can retrieve the
     *        next set of records by retrying the command with the returned
     *        marker value. </p>
     *        <p>
     *        Default: <code>100</code>
     *        </p>
     *        <p>
     *        Constraints: minimum 20, maximum 100.
     */

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the
     * number of remaining response records exceeds the specified
     * <code>MaxRecords</code> value, a value is returned in a
     * <code>marker</code> field of the response. You can retrieve the next set
     * of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If
     *         the number of remaining response records exceeds the specified
     *         <code>MaxRecords</code> value, a value is returned in a
     *         <code>marker</code> field of the response. You can retrieve the
     *         next set of records by retrying the command with the returned
     *         marker value. </p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <p>
     *         Constraints: minimum 20, maximum 100.
     */

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the
     * number of remaining response records exceeds the specified
     * <code>MaxRecords</code> value, a value is returned in a
     * <code>marker</code> field of the response. You can retrieve the next set
     * of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @param maxRecords
     *        The maximum number of response records to return in each call. If
     *        the number of remaining response records exceeds the specified
     *        <code>MaxRecords</code> value, a value is returned in a
     *        <code>marker</code> field of the response. You can retrieve the
     *        next set of records by retrying the command with the returned
     *        marker value. </p>
     *        <p>
     *        Default: <code>100</code>
     *        </p>
     *        <p>
     *        Constraints: minimum 20, maximum 100.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeEventSubscriptionsRequest withMaxRecords(Integer maxRecords) {
        setMaxRecords(maxRecords);
        return this;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set
     * of response records. When the results of a
     * <a>DescribeEventSubscriptions</a> request exceed the value specified in
     * <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code>
     * field of the response. You can retrieve the next set of response records
     * by providing the returned marker value in the <code>Marker</code>
     * parameter and retrying the request.
     * </p>
     * 
     * @param marker
     *        An optional parameter that specifies the starting point to return
     *        a set of response records. When the results of a
     *        <a>DescribeEventSubscriptions</a> request exceed the value
     *        specified in <code>MaxRecords</code>, AWS returns a value in the
     *        <code>Marker</code> field of the response. You can retrieve the
     *        next set of response records by providing the returned marker
     *        value in the <code>Marker</code> parameter and retrying the
     *        request.
     */

    public void setMarker(String marker) {
        this.marker = marker;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set
     * of response records. When the results of a
     * <a>DescribeEventSubscriptions</a> request exceed the value specified in
     * <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code>
     * field of the response. You can retrieve the next set of response records
     * by providing the returned marker value in the <code>Marker</code>
     * parameter and retrying the request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return
     *         a set of response records. When the results of a
     *         <a>DescribeEventSubscriptions</a> request exceed the value
     *         specified in <code>MaxRecords</code>, AWS returns a value in the
     *         <code>Marker</code> field of the response. You can retrieve the
     *         next set of response records by providing the returned marker
     *         value in the <code>Marker</code> parameter and retrying the
     *         request.
     */

    public String getMarker() {
        return this.marker;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set
     * of response records. When the results of a
     * <a>DescribeEventSubscriptions</a> request exceed the value specified in
     * <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code>
     * field of the response. You can retrieve the next set of response records
     * by providing the returned marker value in the <code>Marker</code>
     * parameter and retrying the request.
     * </p>
     * 
     * @param marker
     *        An optional parameter that specifies the starting point to return
     *        a set of response records. When the results of a
     *        <a>DescribeEventSubscriptions</a> request exceed the value
     *        specified in <code>MaxRecords</code>, AWS returns a value in the
     *        <code>Marker</code> field of the response. You can retrieve the
     *        next set of response records by providing the returned marker
     *        value in the <code>Marker</code> parameter and retrying the
     *        request.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeEventSubscriptionsRequest withMarker(String marker) {
        setMarker(marker);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSubscriptionName() != null)
            sb.append("SubscriptionName: " + getSubscriptionName() + ",");
        if (getMaxRecords() != null)
            sb.append("MaxRecords: " + getMaxRecords() + ",");
        if (getMarker() != null)
            sb.append("Marker: " + getMarker());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeEventSubscriptionsRequest == false)
            return false;
        DescribeEventSubscriptionsRequest other = (DescribeEventSubscriptionsRequest) obj;
        if (other.getSubscriptionName() == null
                ^ this.getSubscriptionName() == null)
            return false;
        if (other.getSubscriptionName() != null
                && other.getSubscriptionName().equals(
                        this.getSubscriptionName()) == false)
            return false;
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null)
            return false;
        if (other.getMaxRecords() != null
                && other.getMaxRecords().equals(this.getMaxRecords()) == false)
            return false;
        if (other.getMarker() == null ^ this.getMarker() == null)
            return false;
        if (other.getMarker() != null
                && other.getMarker().equals(this.getMarker()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getSubscriptionName() == null) ? 0 : getSubscriptionName()
                        .hashCode());
        hashCode = prime * hashCode
                + ((getMaxRecords() == null) ? 0 : getMaxRecords().hashCode());
        hashCode = prime * hashCode
                + ((getMarker() == null) ? 0 : getMarker().hashCode());
        return hashCode;
    }

    @Override
    public DescribeEventSubscriptionsRequest clone() {
        return (DescribeEventSubscriptionsRequest) super.clone();
    }
}
