/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.RevisionTarget;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RevisionTargetStaxUnmarshaller
implements Unmarshaller<RevisionTarget, StaxUnmarshallerContext> {
    private static RevisionTargetStaxUnmarshaller instance;

    public RevisionTarget unmarshall(StaxUnmarshallerContext context) throws Exception {
        RevisionTarget revisionTarget = new RevisionTarget();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return revisionTarget;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DatabaseRevision", targetDepth)) {
                    revisionTarget.setDatabaseRevision(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    revisionTarget.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DatabaseRevisionReleaseDate", targetDepth)) continue;
                revisionTarget.setDatabaseRevisionReleaseDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return revisionTarget;
    }

    public static RevisionTargetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RevisionTargetStaxUnmarshaller();
        }
        return instance;
    }
}

