/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshift.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * A maintenance track that you can switch the current track to.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/UpdateTarget" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateTarget implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the new maintenance track.
     * </p>
     */
    private String maintenanceTrackName;
    /**
     * <p>
     * The cluster version for the new maintenance track.
     * </p>
     */
    private String databaseVersion;

    /**
     * <p>
     * The name of the new maintenance track.
     * </p>
     * 
     * @param maintenanceTrackName
     *        The name of the new maintenance track.
     */

    public void setMaintenanceTrackName(String maintenanceTrackName) {
        this.maintenanceTrackName = maintenanceTrackName;
    }

    /**
     * <p>
     * The name of the new maintenance track.
     * </p>
     * 
     * @return The name of the new maintenance track.
     */

    public String getMaintenanceTrackName() {
        return this.maintenanceTrackName;
    }

    /**
     * <p>
     * The name of the new maintenance track.
     * </p>
     * 
     * @param maintenanceTrackName
     *        The name of the new maintenance track.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateTarget withMaintenanceTrackName(String maintenanceTrackName) {
        setMaintenanceTrackName(maintenanceTrackName);
        return this;
    }

    /**
     * <p>
     * The cluster version for the new maintenance track.
     * </p>
     * 
     * @param databaseVersion
     *        The cluster version for the new maintenance track.
     */

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    /**
     * <p>
     * The cluster version for the new maintenance track.
     * </p>
     * 
     * @return The cluster version for the new maintenance track.
     */

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    /**
     * <p>
     * The cluster version for the new maintenance track.
     * </p>
     * 
     * @param databaseVersion
     *        The cluster version for the new maintenance track.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateTarget withDatabaseVersion(String databaseVersion) {
        setDatabaseVersion(databaseVersion);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMaintenanceTrackName() != null)
            sb.append("MaintenanceTrackName: ").append(getMaintenanceTrackName()).append(",");
        if (getDatabaseVersion() != null)
            sb.append("DatabaseVersion: ").append(getDatabaseVersion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateTarget == false)
            return false;
        UpdateTarget other = (UpdateTarget) obj;
        if (other.getMaintenanceTrackName() == null ^ this.getMaintenanceTrackName() == null)
            return false;
        if (other.getMaintenanceTrackName() != null && other.getMaintenanceTrackName().equals(this.getMaintenanceTrackName()) == false)
            return false;
        if (other.getDatabaseVersion() == null ^ this.getDatabaseVersion() == null)
            return false;
        if (other.getDatabaseVersion() != null && other.getDatabaseVersion().equals(this.getDatabaseVersion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMaintenanceTrackName() == null) ? 0 : getMaintenanceTrackName().hashCode());
        hashCode = prime * hashCode + ((getDatabaseVersion() == null) ? 0 : getDatabaseVersion().hashCode());
        return hashCode;
    }

    @Override
    public UpdateTarget clone() {
        try {
            return (UpdateTarget) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
