/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeClustersRequestMarshaller
implements Marshaller<Request<DescribeClustersRequest>, DescribeClustersRequest> {
    public Request<DescribeClustersRequest> marshall(DescribeClustersRequest describeClustersRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeClustersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClustersRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeClusters");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClustersRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeClustersRequest.getClusterIdentifier()));
        }
        if (describeClustersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClustersRequest.getMaxRecords()));
        }
        if (describeClustersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClustersRequest.getMarker()));
        }
        if (!(tagKeysList = (SdkInternalList)describeClustersRequest.getTagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeClustersRequest.getTagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

