/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshift.model;

/**
 * <p>
 * There is no Amazon Redshift HSM client certificate with the specified identifier.
 * </p>
 */
public class HsmClientCertificateNotFoundException extends com.amazonaws.services.redshift.model.AmazonRedshiftException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new HsmClientCertificateNotFoundException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public HsmClientCertificateNotFoundException(String message) {
        super(message);
    }

}
