/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.CreateSnapshotScheduleRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateSnapshotScheduleRequestMarshaller
implements Marshaller<Request<CreateSnapshotScheduleRequest>, CreateSnapshotScheduleRequest> {
    public Request<CreateSnapshotScheduleRequest> marshall(CreateSnapshotScheduleRequest createSnapshotScheduleRequest) {
        if (createSnapshotScheduleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSnapshotScheduleRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateSnapshotSchedule");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!createSnapshotScheduleRequest.getScheduleDefinitions().isEmpty() || !((SdkInternalList)createSnapshotScheduleRequest.getScheduleDefinitions()).isAutoConstruct()) {
            SdkInternalList scheduleDefinitionsList = (SdkInternalList)createSnapshotScheduleRequest.getScheduleDefinitions();
            int scheduleDefinitionsListIndex = 1;
            for (String scheduleDefinitionsListValue : scheduleDefinitionsList) {
                if (scheduleDefinitionsListValue != null) {
                    request.addParameter("ScheduleDefinitions.ScheduleDefinition." + scheduleDefinitionsListIndex, StringUtils.fromString((String)scheduleDefinitionsListValue));
                }
                ++scheduleDefinitionsListIndex;
            }
        }
        if (createSnapshotScheduleRequest.getScheduleIdentifier() != null) {
            request.addParameter("ScheduleIdentifier", StringUtils.fromString((String)createSnapshotScheduleRequest.getScheduleIdentifier()));
        }
        if (createSnapshotScheduleRequest.getScheduleDescription() != null) {
            request.addParameter("ScheduleDescription", StringUtils.fromString((String)createSnapshotScheduleRequest.getScheduleDescription()));
        }
        if (!createSnapshotScheduleRequest.getTags().isEmpty() || !((SdkInternalList)createSnapshotScheduleRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createSnapshotScheduleRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (createSnapshotScheduleRequest.getDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)createSnapshotScheduleRequest.getDryRun()));
        }
        if (createSnapshotScheduleRequest.getNextInvocations() != null) {
            request.addParameter("NextInvocations", StringUtils.fromInteger((Integer)createSnapshotScheduleRequest.getNextInvocations()));
        }
        return request;
    }
}

