/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshift.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * DescribeDataSharesRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeDataSharesRequestMarshaller implements Marshaller<Request<DescribeDataSharesRequest>, DescribeDataSharesRequest> {

    public Request<DescribeDataSharesRequest> marshall(DescribeDataSharesRequest describeDataSharesRequest) {

        if (describeDataSharesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeDataSharesRequest> request = new DefaultRequest<DescribeDataSharesRequest>(describeDataSharesRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeDataShares");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeDataSharesRequest.getDataShareArn() != null) {
            request.addParameter("DataShareArn", StringUtils.fromString(describeDataSharesRequest.getDataShareArn()));
        }

        if (describeDataSharesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeDataSharesRequest.getMaxRecords()));
        }

        if (describeDataSharesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeDataSharesRequest.getMarker()));
        }

        return request;
    }

}
