/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.IPRange;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class IPRangeStaxUnmarshaller
implements Unmarshaller<IPRange, StaxUnmarshallerContext> {
    private static IPRangeStaxUnmarshaller instance;

    public IPRange unmarshall(StaxUnmarshallerContext context) throws Exception {
        IPRange iPRange = new IPRange();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return iPRange;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    iPRange.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CIDRIP", targetDepth)) continue;
                iPRange.setCIDRIP(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return iPRange;
    }

    public static IPRangeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IPRangeStaxUnmarshaller();
        }
        return instance;
    }
}

