/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftdataapi;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.redshiftdataapi.AWSRedshiftDataAPIAsync;
import com.amazonaws.services.redshiftdataapi.AWSRedshiftDataAPIAsyncClientBuilder;
import com.amazonaws.services.redshiftdataapi.AWSRedshiftDataAPIClient;
import com.amazonaws.services.redshiftdataapi.model.CancelStatementRequest;
import com.amazonaws.services.redshiftdataapi.model.CancelStatementResult;
import com.amazonaws.services.redshiftdataapi.model.DescribeStatementRequest;
import com.amazonaws.services.redshiftdataapi.model.DescribeStatementResult;
import com.amazonaws.services.redshiftdataapi.model.DescribeTableRequest;
import com.amazonaws.services.redshiftdataapi.model.DescribeTableResult;
import com.amazonaws.services.redshiftdataapi.model.ExecuteStatementRequest;
import com.amazonaws.services.redshiftdataapi.model.ExecuteStatementResult;
import com.amazonaws.services.redshiftdataapi.model.GetStatementResultRequest;
import com.amazonaws.services.redshiftdataapi.model.GetStatementResultResult;
import com.amazonaws.services.redshiftdataapi.model.ListDatabasesRequest;
import com.amazonaws.services.redshiftdataapi.model.ListDatabasesResult;
import com.amazonaws.services.redshiftdataapi.model.ListSchemasRequest;
import com.amazonaws.services.redshiftdataapi.model.ListSchemasResult;
import com.amazonaws.services.redshiftdataapi.model.ListStatementsRequest;
import com.amazonaws.services.redshiftdataapi.model.ListStatementsResult;
import com.amazonaws.services.redshiftdataapi.model.ListTablesRequest;
import com.amazonaws.services.redshiftdataapi.model.ListTablesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSRedshiftDataAPIAsyncClient
extends AWSRedshiftDataAPIClient
implements AWSRedshiftDataAPIAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSRedshiftDataAPIAsyncClientBuilder asyncBuilder() {
        return AWSRedshiftDataAPIAsyncClientBuilder.standard();
    }

    AWSRedshiftDataAPIAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSRedshiftDataAPIAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelStatementResult> cancelStatementAsync(CancelStatementRequest request) {
        return this.cancelStatementAsync(request, null);
    }

    @Override
    public Future<CancelStatementResult> cancelStatementAsync(CancelStatementRequest request, final AsyncHandler<CancelStatementRequest, CancelStatementResult> asyncHandler) {
        final CancelStatementRequest finalRequest = (CancelStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelStatementResult>(){

            @Override
            public CancelStatementResult call() throws Exception {
                CancelStatementResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeCancelStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStatementResult> describeStatementAsync(DescribeStatementRequest request) {
        return this.describeStatementAsync(request, null);
    }

    @Override
    public Future<DescribeStatementResult> describeStatementAsync(DescribeStatementRequest request, final AsyncHandler<DescribeStatementRequest, DescribeStatementResult> asyncHandler) {
        final DescribeStatementRequest finalRequest = (DescribeStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStatementResult>(){

            @Override
            public DescribeStatementResult call() throws Exception {
                DescribeStatementResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeDescribeStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request) {
        return this.describeTableAsync(request, null);
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request, final AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        final DescribeTableRequest finalRequest = (DescribeTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                DescribeTableResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeDescribeTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExecuteStatementResult> executeStatementAsync(ExecuteStatementRequest request) {
        return this.executeStatementAsync(request, null);
    }

    @Override
    public Future<ExecuteStatementResult> executeStatementAsync(ExecuteStatementRequest request, final AsyncHandler<ExecuteStatementRequest, ExecuteStatementResult> asyncHandler) {
        final ExecuteStatementRequest finalRequest = (ExecuteStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExecuteStatementResult>(){

            @Override
            public ExecuteStatementResult call() throws Exception {
                ExecuteStatementResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeExecuteStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStatementResultResult> getStatementResultAsync(GetStatementResultRequest request) {
        return this.getStatementResultAsync(request, null);
    }

    @Override
    public Future<GetStatementResultResult> getStatementResultAsync(GetStatementResultRequest request, final AsyncHandler<GetStatementResultRequest, GetStatementResultResult> asyncHandler) {
        final GetStatementResultRequest finalRequest = (GetStatementResultRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStatementResultResult>(){

            @Override
            public GetStatementResultResult call() throws Exception {
                GetStatementResultResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeGetStatementResult(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request) {
        return this.listDatabasesAsync(request, null);
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request, final AsyncHandler<ListDatabasesRequest, ListDatabasesResult> asyncHandler) {
        final ListDatabasesRequest finalRequest = (ListDatabasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatabasesResult>(){

            @Override
            public ListDatabasesResult call() throws Exception {
                ListDatabasesResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeListDatabases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSchemasResult> listSchemasAsync(ListSchemasRequest request) {
        return this.listSchemasAsync(request, null);
    }

    @Override
    public Future<ListSchemasResult> listSchemasAsync(ListSchemasRequest request, final AsyncHandler<ListSchemasRequest, ListSchemasResult> asyncHandler) {
        final ListSchemasRequest finalRequest = (ListSchemasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSchemasResult>(){

            @Override
            public ListSchemasResult call() throws Exception {
                ListSchemasResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeListSchemas(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStatementsResult> listStatementsAsync(ListStatementsRequest request) {
        return this.listStatementsAsync(request, null);
    }

    @Override
    public Future<ListStatementsResult> listStatementsAsync(ListStatementsRequest request, final AsyncHandler<ListStatementsRequest, ListStatementsResult> asyncHandler) {
        final ListStatementsRequest finalRequest = (ListStatementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStatementsResult>(){

            @Override
            public ListStatementsResult call() throws Exception {
                ListStatementsResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeListStatements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request) {
        return this.listTablesAsync(request, null);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        final ListTablesRequest finalRequest = (ListTablesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult result = null;
                try {
                    result = AWSRedshiftDataAPIAsyncClient.this.executeListTables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

