/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftserverless.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshiftserverless-2021-04-21/DeleteWorkgroup" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteWorkgroupResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The deleted workgroup object.
     * </p>
     */
    private Workgroup workgroup;

    /**
     * <p>
     * The deleted workgroup object.
     * </p>
     * 
     * @param workgroup
     *        The deleted workgroup object.
     */

    public void setWorkgroup(Workgroup workgroup) {
        this.workgroup = workgroup;
    }

    /**
     * <p>
     * The deleted workgroup object.
     * </p>
     * 
     * @return The deleted workgroup object.
     */

    public Workgroup getWorkgroup() {
        return this.workgroup;
    }

    /**
     * <p>
     * The deleted workgroup object.
     * </p>
     * 
     * @param workgroup
     *        The deleted workgroup object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteWorkgroupResult withWorkgroup(Workgroup workgroup) {
        setWorkgroup(workgroup);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getWorkgroup() != null)
            sb.append("Workgroup: ").append(getWorkgroup());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteWorkgroupResult == false)
            return false;
        DeleteWorkgroupResult other = (DeleteWorkgroupResult) obj;
        if (other.getWorkgroup() == null ^ this.getWorkgroup() == null)
            return false;
        if (other.getWorkgroup() != null && other.getWorkgroup().equals(this.getWorkgroup()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getWorkgroup() == null) ? 0 : getWorkgroup().hashCode());
        return hashCode;
    }

    @Override
    public DeleteWorkgroupResult clone() {
        try {
            return (DeleteWorkgroupResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
