/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition;

import com.amazonaws.services.rekognition.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonRekognition}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
public class AbstractAmazonRekognition implements AmazonRekognition {

    protected AbstractAmazonRekognition() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CompareFacesResult compareFaces(CompareFacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCollectionResult createCollection(CreateCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCollectionResult deleteCollection(DeleteCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFacesResult deleteFaces(DeleteFacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectFacesResult detectFaces(DetectFacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectLabelsResult detectLabels(DetectLabelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public IndexFacesResult indexFaces(IndexFacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCollectionsResult listCollections(ListCollectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFacesResult listFaces(ListFacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchFacesResult searchFaces(SearchFacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchFacesByImageResult searchFacesByImage(SearchFacesByImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
