/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.rekognition.model.*;

import com.amazonaws.protocol.json.*;

/**
 * EyeglassesMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EyeglassesJsonMarshaller {

    /**
     * Marshall the given parameter object, and output to a SdkJsonGenerator
     */
    public void marshall(Eyeglasses eyeglasses, StructuredJsonGenerator jsonGenerator) {

        if (eyeglasses == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            jsonGenerator.writeStartObject();

            if (eyeglasses.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(eyeglasses.getValue());
            }
            if (eyeglasses.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(eyeglasses.getConfidence());
            }

            jsonGenerator.writeEndObject();
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    private static EyeglassesJsonMarshaller instance;

    public static EyeglassesJsonMarshaller getInstance() {
        if (instance == null)
            instance = new EyeglassesJsonMarshaller();
        return instance;
    }

}
