/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.Instance;
import com.amazonaws.services.rekognition.model.Parent;
import com.amazonaws.services.rekognition.model.transform.LabelMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Label
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Float confidence;
    private List<Instance> instances;
    private List<Parent> parents;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Label withName(String name) {
        this.setName(name);
        return this;
    }

    public void setConfidence(Float confidence) {
        this.confidence = confidence;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public Label withConfidence(Float confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<Instance>(instances);
    }

    public Label withInstances(Instance ... instances) {
        if (this.instances == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public Label withInstances(Collection<Instance> instances) {
        this.setInstances(instances);
        return this;
    }

    public List<Parent> getParents() {
        return this.parents;
    }

    public void setParents(Collection<Parent> parents) {
        if (parents == null) {
            this.parents = null;
            return;
        }
        this.parents = new ArrayList<Parent>(parents);
    }

    public Label withParents(Parent ... parents) {
        if (this.parents == null) {
            this.setParents(new ArrayList<Parent>(parents.length));
        }
        for (Parent ele : parents) {
            this.parents.add(ele);
        }
        return this;
    }

    public Label withParents(Collection<Parent> parents) {
        this.setParents(parents);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getParents() != null) {
            sb.append("Parents: ").append(this.getParents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Label)) {
            return false;
        }
        Label other = (Label)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getParents() == null ^ this.getParents() == null) {
            return false;
        }
        return other.getParents() == null || other.getParents().equals(this.getParents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getParents() == null ? 0 : this.getParents().hashCode());
        return hashCode;
    }

    public Label clone() {
        try {
            return (Label)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LabelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

