/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.Asset;
import com.amazonaws.services.rekognition.model.transform.TestingDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TestingData
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Asset> assets;
    private Boolean autoCreate;

    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(Collection<Asset> assets) {
        if (assets == null) {
            this.assets = null;
            return;
        }
        this.assets = new ArrayList<Asset>(assets);
    }

    public TestingData withAssets(Asset ... assets) {
        if (this.assets == null) {
            this.setAssets(new ArrayList<Asset>(assets.length));
        }
        for (Asset ele : assets) {
            this.assets.add(ele);
        }
        return this;
    }

    public TestingData withAssets(Collection<Asset> assets) {
        this.setAssets(assets);
        return this;
    }

    public void setAutoCreate(Boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public Boolean getAutoCreate() {
        return this.autoCreate;
    }

    public TestingData withAutoCreate(Boolean autoCreate) {
        this.setAutoCreate(autoCreate);
        return this;
    }

    public Boolean isAutoCreate() {
        return this.autoCreate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssets() != null) {
            sb.append("Assets: ").append(this.getAssets()).append(",");
        }
        if (this.getAutoCreate() != null) {
            sb.append("AutoCreate: ").append(this.getAutoCreate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestingData)) {
            return false;
        }
        TestingData other = (TestingData)obj;
        if (other.getAssets() == null ^ this.getAssets() == null) {
            return false;
        }
        if (other.getAssets() != null && !other.getAssets().equals(this.getAssets())) {
            return false;
        }
        if (other.getAutoCreate() == null ^ this.getAutoCreate() == null) {
            return false;
        }
        return other.getAutoCreate() == null || other.getAutoCreate().equals(this.getAutoCreate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssets() == null ? 0 : this.getAssets().hashCode());
        hashCode = 31 * hashCode + (this.getAutoCreate() == null ? 0 : this.getAutoCreate().hashCode());
        return hashCode;
    }

    public TestingData clone() {
        try {
            return (TestingData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TestingDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

