/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.rekognition.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DetectLabelsImageProperties JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DetectLabelsImagePropertiesJsonUnmarshaller implements Unmarshaller<DetectLabelsImageProperties, JsonUnmarshallerContext> {

    public DetectLabelsImageProperties unmarshall(JsonUnmarshallerContext context) throws Exception {
        DetectLabelsImageProperties detectLabelsImageProperties = new DetectLabelsImageProperties();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Quality", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    detectLabelsImageProperties.setQuality(DetectLabelsImageQualityJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DominantColors", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    detectLabelsImageProperties.setDominantColors(new ListUnmarshaller<DominantColor>(DominantColorJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("Foreground", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    detectLabelsImageProperties.setForeground(DetectLabelsImageForegroundJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Background", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    detectLabelsImageProperties.setBackground(DetectLabelsImageBackgroundJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return detectLabelsImageProperties;
    }

    private static DetectLabelsImagePropertiesJsonUnmarshaller instance;

    public static DetectLabelsImagePropertiesJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DetectLabelsImagePropertiesJsonUnmarshaller();
        return instance;
    }
}
