/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.rekognition.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetFaceSearchResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetFaceSearchResultJsonUnmarshaller implements Unmarshaller<GetFaceSearchResult, JsonUnmarshallerContext> {

    public GetFaceSearchResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetFaceSearchResult getFaceSearchResult = new GetFaceSearchResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getFaceSearchResult;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("JobStatus", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    getFaceSearchResult.setJobStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StatusMessage", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    getFaceSearchResult.setStatusMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NextToken", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    getFaceSearchResult.setNextToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VideoMetadata", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    getFaceSearchResult.setVideoMetadata(VideoMetadataJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Persons", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    getFaceSearchResult.setPersons(new ListUnmarshaller<PersonMatch>(PersonMatchJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("JobId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    getFaceSearchResult.setJobId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Video", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    getFaceSearchResult.setVideo(VideoJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("JobTag", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    getFaceSearchResult.setJobTag(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getFaceSearchResult;
    }

    private static GetFaceSearchResultJsonUnmarshaller instance;

    public static GetFaceSearchResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new GetFaceSearchResultJsonUnmarshaller();
        return instance;
    }
}
