/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.LivenessOutputConfig;

@SdkInternalApi
public class LivenessOutputConfigMarshaller {
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").build();
    private static final MarshallingInfo<String> S3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3KeyPrefix").build();
    private static final LivenessOutputConfigMarshaller instance = new LivenessOutputConfigMarshaller();

    public static LivenessOutputConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(LivenessOutputConfig livenessOutputConfig, ProtocolMarshaller protocolMarshaller) {
        if (livenessOutputConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)livenessOutputConfig.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)livenessOutputConfig.getS3KeyPrefix(), S3KEYPREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

