/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeProjectsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Rekognition returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
     * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * A list of the projects that you want Rekognition to describe. If you don't specify a value, the response includes
     * descriptions for all the projects in your AWS account.
     * </p>
     */
    private java.util.List<String> projectNames;
    /**
     * <p>
     * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as a
     * default.
     * </p>
     */
    private java.util.List<String> features;

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Rekognition returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of results.
     * </p>
     * 
     * @param nextToken
     *        If the previous response was incomplete (because there is more results to retrieve), Rekognition returns a
     *        pagination token in the response. You can use this pagination token to retrieve the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Rekognition returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of results.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more results to retrieve), Rekognition returns
     *         a pagination token in the response. You can use this pagination token to retrieve the next set of
     *         results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Rekognition returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of results.
     * </p>
     * 
     * @param nextToken
     *        If the previous response was incomplete (because there is more results to retrieve), Rekognition returns a
     *        pagination token in the response. You can use this pagination token to retrieve the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeProjectsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
     * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return per paginated call. The largest value you can specify is 100. If
     *        you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
     * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * </p>
     * 
     * @return The maximum number of results to return per paginated call. The largest value you can specify is 100. If
     *         you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
     * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return per paginated call. The largest value you can specify is 100. If
     *        you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeProjectsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * A list of the projects that you want Rekognition to describe. If you don't specify a value, the response includes
     * descriptions for all the projects in your AWS account.
     * </p>
     * 
     * @return A list of the projects that you want Rekognition to describe. If you don't specify a value, the response
     *         includes descriptions for all the projects in your AWS account.
     */

    public java.util.List<String> getProjectNames() {
        return projectNames;
    }

    /**
     * <p>
     * A list of the projects that you want Rekognition to describe. If you don't specify a value, the response includes
     * descriptions for all the projects in your AWS account.
     * </p>
     * 
     * @param projectNames
     *        A list of the projects that you want Rekognition to describe. If you don't specify a value, the response
     *        includes descriptions for all the projects in your AWS account.
     */

    public void setProjectNames(java.util.Collection<String> projectNames) {
        if (projectNames == null) {
            this.projectNames = null;
            return;
        }

        this.projectNames = new java.util.ArrayList<String>(projectNames);
    }

    /**
     * <p>
     * A list of the projects that you want Rekognition to describe. If you don't specify a value, the response includes
     * descriptions for all the projects in your AWS account.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProjectNames(java.util.Collection)} or {@link #withProjectNames(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param projectNames
     *        A list of the projects that you want Rekognition to describe. If you don't specify a value, the response
     *        includes descriptions for all the projects in your AWS account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeProjectsRequest withProjectNames(String... projectNames) {
        if (this.projectNames == null) {
            setProjectNames(new java.util.ArrayList<String>(projectNames.length));
        }
        for (String ele : projectNames) {
            this.projectNames.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of the projects that you want Rekognition to describe. If you don't specify a value, the response includes
     * descriptions for all the projects in your AWS account.
     * </p>
     * 
     * @param projectNames
     *        A list of the projects that you want Rekognition to describe. If you don't specify a value, the response
     *        includes descriptions for all the projects in your AWS account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeProjectsRequest withProjectNames(java.util.Collection<String> projectNames) {
        setProjectNames(projectNames);
        return this;
    }

    /**
     * <p>
     * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as a
     * default.
     * </p>
     * 
     * @return Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is
     *         used as a default.
     * @see CustomizationFeature
     */

    public java.util.List<String> getFeatures() {
        return features;
    }

    /**
     * <p>
     * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as a
     * default.
     * </p>
     * 
     * @param features
     *        Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used
     *        as a default.
     * @see CustomizationFeature
     */

    public void setFeatures(java.util.Collection<String> features) {
        if (features == null) {
            this.features = null;
            return;
        }

        this.features = new java.util.ArrayList<String>(features);
    }

    /**
     * <p>
     * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as a
     * default.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFeatures(java.util.Collection)} or {@link #withFeatures(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param features
     *        Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used
     *        as a default.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CustomizationFeature
     */

    public DescribeProjectsRequest withFeatures(String... features) {
        if (this.features == null) {
            setFeatures(new java.util.ArrayList<String>(features.length));
        }
        for (String ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as a
     * default.
     * </p>
     * 
     * @param features
     *        Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used
     *        as a default.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CustomizationFeature
     */

    public DescribeProjectsRequest withFeatures(java.util.Collection<String> features) {
        setFeatures(features);
        return this;
    }

    /**
     * <p>
     * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as a
     * default.
     * </p>
     * 
     * @param features
     *        Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used
     *        as a default.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CustomizationFeature
     */

    public DescribeProjectsRequest withFeatures(CustomizationFeature... features) {
        java.util.ArrayList<String> featuresCopy = new java.util.ArrayList<String>(features.length);
        for (CustomizationFeature value : features) {
            featuresCopy.add(value.toString());
        }
        if (getFeatures() == null) {
            setFeatures(featuresCopy);
        } else {
            getFeatures().addAll(featuresCopy);
        }
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getProjectNames() != null)
            sb.append("ProjectNames: ").append(getProjectNames()).append(",");
        if (getFeatures() != null)
            sb.append("Features: ").append(getFeatures());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeProjectsRequest == false)
            return false;
        DescribeProjectsRequest other = (DescribeProjectsRequest) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getProjectNames() == null ^ this.getProjectNames() == null)
            return false;
        if (other.getProjectNames() != null && other.getProjectNames().equals(this.getProjectNames()) == false)
            return false;
        if (other.getFeatures() == null ^ this.getFeatures() == null)
            return false;
        if (other.getFeatures() != null && other.getFeatures().equals(this.getFeatures()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getProjectNames() == null) ? 0 : getProjectNames().hashCode());
        hashCode = prime * hashCode + ((getFeatures() == null) ? 0 : getFeatures().hashCode());
        return hashCode;
    }

    @Override
    public DescribeProjectsRequest clone() {
        return (DescribeProjectsRequest) super.clone();
    }

}
