/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.FaceDetail;
import com.amazonaws.services.rekognition.model.Reason;
import com.amazonaws.services.rekognition.model.transform.UnindexedFaceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnindexedFace
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> reasons;
    private FaceDetail faceDetail;

    public List<String> getReasons() {
        return this.reasons;
    }

    public void setReasons(Collection<String> reasons) {
        if (reasons == null) {
            this.reasons = null;
            return;
        }
        this.reasons = new ArrayList<String>(reasons);
    }

    public UnindexedFace withReasons(String ... reasons) {
        if (this.reasons == null) {
            this.setReasons(new ArrayList<String>(reasons.length));
        }
        for (String ele : reasons) {
            this.reasons.add(ele);
        }
        return this;
    }

    public UnindexedFace withReasons(Collection<String> reasons) {
        this.setReasons(reasons);
        return this;
    }

    public UnindexedFace withReasons(Reason ... reasons) {
        ArrayList<String> reasonsCopy = new ArrayList<String>(reasons.length);
        for (Reason value : reasons) {
            reasonsCopy.add(value.toString());
        }
        if (this.getReasons() == null) {
            this.setReasons(reasonsCopy);
        } else {
            this.getReasons().addAll(reasonsCopy);
        }
        return this;
    }

    public void setFaceDetail(FaceDetail faceDetail) {
        this.faceDetail = faceDetail;
    }

    public FaceDetail getFaceDetail() {
        return this.faceDetail;
    }

    public UnindexedFace withFaceDetail(FaceDetail faceDetail) {
        this.setFaceDetail(faceDetail);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReasons() != null) {
            sb.append("Reasons: ").append(this.getReasons()).append(",");
        }
        if (this.getFaceDetail() != null) {
            sb.append("FaceDetail: ").append(this.getFaceDetail());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnindexedFace)) {
            return false;
        }
        UnindexedFace other = (UnindexedFace)obj;
        if (other.getReasons() == null ^ this.getReasons() == null) {
            return false;
        }
        if (other.getReasons() != null && !other.getReasons().equals(this.getReasons())) {
            return false;
        }
        if (other.getFaceDetail() == null ^ this.getFaceDetail() == null) {
            return false;
        }
        return other.getFaceDetail() == null || other.getFaceDetail().equals(this.getFaceDetail());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReasons() == null ? 0 : this.getReasons().hashCode());
        hashCode = 31 * hashCode + (this.getFaceDetail() == null ? 0 : this.getFaceDetail().hashCode());
        return hashCode;
    }

    public UnindexedFace clone() {
        try {
            return (UnindexedFace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UnindexedFaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

