/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.ContentType;

@SdkInternalApi
public class ContentTypeMarshaller {
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final ContentTypeMarshaller instance = new ContentTypeMarshaller();

    public static ContentTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContentType contentType, ProtocolMarshaller protocolMarshaller) {
        if (contentType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)contentType.getConfidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)contentType.getName(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

