/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.rekognition.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * GeneralLabelsSettingsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class GeneralLabelsSettingsMarshaller {

    private static final MarshallingInfo<List> LABELINCLUSIONFILTERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabelInclusionFilters").build();
    private static final MarshallingInfo<List> LABELEXCLUSIONFILTERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabelExclusionFilters").build();
    private static final MarshallingInfo<List> LABELCATEGORYINCLUSIONFILTERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabelCategoryInclusionFilters").build();
    private static final MarshallingInfo<List> LABELCATEGORYEXCLUSIONFILTERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabelCategoryExclusionFilters").build();

    private static final GeneralLabelsSettingsMarshaller instance = new GeneralLabelsSettingsMarshaller();

    public static GeneralLabelsSettingsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(GeneralLabelsSettings generalLabelsSettings, ProtocolMarshaller protocolMarshaller) {

        if (generalLabelsSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(generalLabelsSettings.getLabelInclusionFilters(), LABELINCLUSIONFILTERS_BINDING);
            protocolMarshaller.marshall(generalLabelsSettings.getLabelExclusionFilters(), LABELEXCLUSIONFILTERS_BINDING);
            protocolMarshaller.marshall(generalLabelsSettings.getLabelCategoryInclusionFilters(), LABELCATEGORYINCLUSIONFILTERS_BINDING);
            protocolMarshaller.marshall(generalLabelsSettings.getLabelCategoryExclusionFilters(), LABELCATEGORYEXCLUSIONFILTERS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
